/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal.antlr;

import com.github.jknack.handlebars.internal.antlr.ANTLRErrorListener;
import com.github.jknack.handlebars.internal.antlr.CharStream;
import com.github.jknack.handlebars.internal.antlr.CommonTokenFactory;
import com.github.jknack.handlebars.internal.antlr.IntStream;
import com.github.jknack.handlebars.internal.antlr.LexerNoViableAltException;
import com.github.jknack.handlebars.internal.antlr.RecognitionException;
import com.github.jknack.handlebars.internal.antlr.Recognizer;
import com.github.jknack.handlebars.internal.antlr.Token;
import com.github.jknack.handlebars.internal.antlr.TokenFactory;
import com.github.jknack.handlebars.internal.antlr.TokenSource;
import com.github.jknack.handlebars.internal.antlr.atn.ATNSimulator;
import com.github.jknack.handlebars.internal.antlr.atn.LexerATNSimulator;
import com.github.jknack.handlebars.internal.antlr.misc.IntegerStack;
import com.github.jknack.handlebars.internal.antlr.misc.Interval;
import com.github.jknack.handlebars.internal.antlr.misc.Pair;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.List;

public abstract class Lexer
extends Recognizer<Integer, LexerATNSimulator>
implements TokenSource {
    public static final int DEFAULT_MODE = 0;
    public static final int MORE = -2;
    public static final int SKIP = -3;
    public static final int DEFAULT_TOKEN_CHANNEL = 0;
    public static final int HIDDEN = 1;
    public static final int MIN_CHAR_VALUE = 0;
    public static final int MAX_CHAR_VALUE = 0x10FFFF;
    public CharStream _input;
    protected Pair<TokenSource, CharStream> _tokenFactorySourcePair;
    protected TokenFactory<?> _factory = CommonTokenFactory.DEFAULT;
    public Token _token;
    public int _tokenStartCharIndex = -1;
    public int _tokenStartLine;
    public int _tokenStartCharPositionInLine;
    public boolean _hitEOF;
    public int _channel;
    public int _type;
    public final IntegerStack _modeStack = new IntegerStack();
    public int _mode = 0;
    public String _text;

    public Lexer() {
    }

    public Lexer(CharStream charStream) {
        this._input = charStream;
        this._tokenFactorySourcePair = new Pair<Lexer, CharStream>(this, charStream);
    }

    public void reset() {
        if (this._input != null) {
            this._input.seek(0);
        }
        this._token = null;
        this._type = 0;
        this._channel = 0;
        this._tokenStartCharIndex = -1;
        this._tokenStartCharPositionInLine = -1;
        this._tokenStartLine = -1;
        this._text = null;
        this._hitEOF = false;
        this._mode = 0;
        this._modeStack.clear();
        ((ATNSimulator)((LexerATNSimulator)this.getInterpreter())).reset();
    }

    @Override
    public Token nextToken() {
        if (this._input == null) {
            throw new IllegalStateException("nextToken requires a non-null input stream.");
        }
        int n2 = this._input.mark();
        try {
            block6: while (true) {
                if (this._hitEOF) {
                    this.emitEOF();
                    Token token = this._token;
                    return token;
                }
                this._token = null;
                this._channel = 0;
                this._tokenStartCharIndex = this._input.index();
                this._tokenStartCharPositionInLine = ((LexerATNSimulator)this.getInterpreter()).getCharPositionInLine();
                this._tokenStartLine = ((LexerATNSimulator)this.getInterpreter()).getLine();
                this._text = null;
                do {
                    int n3;
                    this._type = 0;
                    try {
                        n3 = ((LexerATNSimulator)this.getInterpreter()).match(this._input, this._mode);
                    }
                    catch (LexerNoViableAltException lexerNoViableAltException) {
                        this.notifyListeners(lexerNoViableAltException);
                        this.recover(lexerNoViableAltException);
                        n3 = -3;
                    }
                    if (this._input.LA(1) == -1) {
                        this._hitEOF = true;
                    }
                    if (this._type == 0) {
                        this._type = n3;
                    }
                    if (this._type == -3) continue block6;
                } while (this._type == -2);
                break;
            }
            if (this._token == null) {
                this.emit();
            }
            Token token = this._token;
            return token;
        }
        finally {
            this._input.release(n2);
        }
    }

    public void skip() {
        this._type = -3;
    }

    public void more() {
        this._type = -2;
    }

    public void mode(int n2) {
        this._mode = n2;
    }

    public void pushMode(int n2) {
        this._modeStack.push(this._mode);
        this.mode(n2);
    }

    public int popMode() {
        if (this._modeStack.isEmpty()) {
            throw new EmptyStackException();
        }
        Lexer lexer = this;
        lexer.mode(lexer._modeStack.pop());
        return this._mode;
    }

    @Override
    public void setTokenFactory(TokenFactory<?> tokenFactory) {
        this._factory = tokenFactory;
    }

    @Override
    public TokenFactory<? extends Token> getTokenFactory() {
        return this._factory;
    }

    @Override
    public void setInputStream(IntStream intStream) {
        this._input = null;
        Lexer lexer = this;
        this._tokenFactorySourcePair = new Pair<Lexer, CharStream>(lexer, lexer._input);
        this.reset();
        this._input = (CharStream)intStream;
        Lexer lexer2 = this;
        this._tokenFactorySourcePair = new Pair<Lexer, CharStream>(lexer2, lexer2._input);
    }

    @Override
    public String getSourceName() {
        return this._input.getSourceName();
    }

    @Override
    public CharStream getInputStream() {
        return this._input;
    }

    public void emit(Token token) {
        this._token = token;
    }

    public Token emit() {
        Object obj = this._factory.create(this._tokenFactorySourcePair, this._type, this._text, this._channel, this._tokenStartCharIndex, this.getCharIndex() - 1, this._tokenStartLine, this._tokenStartCharPositionInLine);
        this.emit((Token)obj);
        return obj;
    }

    public Token emitEOF() {
        int n2 = this.getCharPositionInLine();
        int n3 = this.getLine();
        Object obj = this._factory.create(this._tokenFactorySourcePair, -1, null, 0, this._input.index(), this._input.index() - 1, n3, n2);
        this.emit((Token)obj);
        return obj;
    }

    @Override
    public int getLine() {
        return ((LexerATNSimulator)this.getInterpreter()).getLine();
    }

    @Override
    public int getCharPositionInLine() {
        return ((LexerATNSimulator)this.getInterpreter()).getCharPositionInLine();
    }

    public void setLine(int n2) {
        ((LexerATNSimulator)this.getInterpreter()).setLine(n2);
    }

    public void setCharPositionInLine(int n2) {
        ((LexerATNSimulator)this.getInterpreter()).setCharPositionInLine(n2);
    }

    public int getCharIndex() {
        return this._input.index();
    }

    public String getText() {
        if (this._text != null) {
            return this._text;
        }
        return ((LexerATNSimulator)this.getInterpreter()).getText(this._input);
    }

    public void setText(String string) {
        this._text = string;
    }

    public Token getToken() {
        return this._token;
    }

    public void setToken(Token token) {
        this._token = token;
    }

    public void setType(int n2) {
        this._type = n2;
    }

    public int getType() {
        return this._type;
    }

    public void setChannel(int n2) {
        this._channel = n2;
    }

    public int getChannel() {
        return this._channel;
    }

    public String[] getChannelNames() {
        return null;
    }

    public String[] getModeNames() {
        return null;
    }

    @Override
    @Deprecated
    public String[] getTokenNames() {
        return null;
    }

    public List<? extends Token> getAllTokens() {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        Token token = this.nextToken();
        while (token.getType() != -1) {
            arrayList.add(token);
            token = this.nextToken();
        }
        return arrayList;
    }

    public void recover(LexerNoViableAltException lexerNoViableAltException) {
        if (this._input.LA(1) != -1) {
            ((LexerATNSimulator)this.getInterpreter()).consume(this._input);
        }
    }

    public void notifyListeners(LexerNoViableAltException lexerNoViableAltException) {
        String string = this._input.getText(Interval.of(this._tokenStartCharIndex, this._input.index()));
        string = "token recognition error at: '" + this.getErrorDisplay(string) + "'";
        ANTLRErrorListener aNTLRErrorListener = this.getErrorListenerDispatch();
        aNTLRErrorListener.syntaxError(this, null, this._tokenStartLine, this._tokenStartCharPositionInLine, string, lexerNoViableAltException);
    }

    public String getErrorDisplay(String object) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = object[i2];
            stringBuilder.append(this.getErrorDisplay((int)object2));
        }
        return stringBuilder.toString();
    }

    public String getErrorDisplay(int n2) {
        String string = String.valueOf((char)n2);
        switch (n2) {
            case -1: {
                string = "<EOF>";
                break;
            }
            case 10: {
                string = "\\n";
                break;
            }
            case 9: {
                string = "\\t";
                break;
            }
            case 13: {
                string = "\\r";
            }
        }
        return string;
    }

    public String getCharErrorDisplay(int n2) {
        String string = this.getErrorDisplay(n2);
        return "'" + string + "'";
    }

    public void recover(RecognitionException recognitionException) {
        this._input.consume();
    }
}

