/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal.antlr.atn;

import com.github.jknack.handlebars.internal.antlr.atn.PredictionContext;
import com.github.jknack.handlebars.internal.antlr.atn.SingletonPredictionContext;
import java.util.Arrays;

public class ArrayPredictionContext
extends PredictionContext {
    public final PredictionContext[] parents;
    public final int[] returnStates;

    public ArrayPredictionContext(SingletonPredictionContext singletonPredictionContext) {
        this(new PredictionContext[]{singletonPredictionContext.parent}, new int[]{singletonPredictionContext.returnState});
    }

    public ArrayPredictionContext(PredictionContext[] predictionContextArray, int[] nArray) {
        super(ArrayPredictionContext.calculateHashCode(predictionContextArray, nArray));
        assert (predictionContextArray != null && predictionContextArray.length > 0);
        assert (nArray != null && nArray.length > 0);
        this.parents = predictionContextArray;
        this.returnStates = nArray;
    }

    @Override
    public boolean isEmpty() {
        return this.returnStates[0] == Integer.MAX_VALUE;
    }

    @Override
    public int size() {
        return this.returnStates.length;
    }

    @Override
    public PredictionContext getParent(int n2) {
        return this.parents[n2];
    }

    @Override
    public int getReturnState(int n2) {
        return this.returnStates[n2];
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ArrayPredictionContext)) {
            return false;
        }
        if (this.hashCode() != object.hashCode()) {
            return false;
        }
        object = (ArrayPredictionContext)object;
        return Arrays.equals(this.returnStates, ((ArrayPredictionContext)object).returnStates) && Arrays.equals(this.parents, ((ArrayPredictionContext)object).parents);
    }

    public String toString() {
        if (((PredictionContext)this).isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i2 = 0; i2 < this.returnStates.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(", ");
            }
            if (this.returnStates[i2] == Integer.MAX_VALUE) {
                stringBuilder.append("$");
                continue;
            }
            stringBuilder.append(this.returnStates[i2]);
            if (this.parents[i2] != null) {
                stringBuilder.append(' ');
                stringBuilder.append(this.parents[i2].toString());
                continue;
            }
            stringBuilder.append("null");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

