/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal.antlr.atn;

import com.github.jknack.handlebars.internal.antlr.Recognizer;
import com.github.jknack.handlebars.internal.antlr.RuleContext;
import com.github.jknack.handlebars.internal.antlr.misc.MurmurHash;
import com.github.jknack.handlebars.internal.antlr.misc.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public abstract class SemanticContext {
    public static final SemanticContext NONE = new Predicate();

    public abstract boolean eval(Recognizer<?, ?> var1, RuleContext var2);

    public SemanticContext evalPrecedence(Recognizer<?, ?> recognizer, RuleContext ruleContext) {
        return this;
    }

    public static SemanticContext and(SemanticContext semanticContext, SemanticContext semanticContext2) {
        if (semanticContext == null || semanticContext == NONE) {
            return semanticContext2;
        }
        if (semanticContext2 == null || semanticContext2 == NONE) {
            return semanticContext;
        }
        semanticContext = new AND(semanticContext, semanticContext2);
        if (((AND)semanticContext).opnds.length == 1) {
            return ((AND)semanticContext).opnds[0];
        }
        return semanticContext;
    }

    public static SemanticContext or(SemanticContext semanticContext, SemanticContext semanticContext2) {
        if (semanticContext == null) {
            return semanticContext2;
        }
        if (semanticContext2 == null) {
            return semanticContext;
        }
        if (semanticContext == NONE || semanticContext2 == NONE) {
            return NONE;
        }
        semanticContext = new OR(semanticContext, semanticContext2);
        if (((OR)semanticContext).opnds.length == 1) {
            return ((OR)semanticContext).opnds[0];
        }
        return semanticContext;
    }

    static /* synthetic */ List a(Collection object) {
        ArrayList<PrecedencePredicate> arrayList = null;
        object = object.iterator();
        while (object.hasNext()) {
            SemanticContext semanticContext = (SemanticContext)object.next();
            if (!(semanticContext instanceof PrecedencePredicate)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<PrecedencePredicate>();
            }
            arrayList.add((PrecedencePredicate)semanticContext);
            object.remove();
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    public static class OR
    extends Operator {
        public final SemanticContext[] opnds;

        public OR(SemanticContext object, SemanticContext semanticContext) {
            HashSet<Object> hashSet = new HashSet<Object>();
            if (object instanceof OR) {
                hashSet.addAll(Arrays.asList(((OR)object).opnds));
            } else {
                hashSet.add(object);
            }
            if (semanticContext instanceof OR) {
                hashSet.addAll(Arrays.asList(((OR)semanticContext).opnds));
            } else {
                hashSet.add(semanticContext);
            }
            object = SemanticContext.a(hashSet);
            if (!object.isEmpty()) {
                object = (PrecedencePredicate)Collections.max(object);
                hashSet.add(object);
            }
            HashSet<Object> hashSet2 = hashSet;
            this.opnds = hashSet2.toArray(new SemanticContext[hashSet2.size()]);
        }

        @Override
        public Collection<SemanticContext> getOperands() {
            return Arrays.asList(this.opnds);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof OR)) {
                return false;
            }
            object = (OR)object;
            return Arrays.equals(this.opnds, ((OR)object).opnds);
        }

        public int hashCode() {
            return MurmurHash.hashCode(this.opnds, OR.class.hashCode());
        }

        @Override
        public boolean eval(Recognizer<?, ?> recognizer, RuleContext ruleContext) {
            SemanticContext[] semanticContextArray = this.opnds;
            int n2 = this.opnds.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                SemanticContext semanticContext = semanticContextArray[i2];
                if (!semanticContext.eval(recognizer, ruleContext)) continue;
                return true;
            }
            return false;
        }

        @Override
        public SemanticContext evalPrecedence(Recognizer<?, ?> recognizer, RuleContext ruleContext) {
            boolean bl2 = false;
            ArrayList<SemanticContext> arrayList = new ArrayList<SemanticContext>();
            Object object = this.opnds;
            int n2 = this.opnds.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                SemanticContext semanticContext = object[i2];
                SemanticContext semanticContext2 = semanticContext.evalPrecedence(recognizer, ruleContext);
                bl2 |= semanticContext2 != semanticContext;
                if (semanticContext2 == NONE) {
                    return NONE;
                }
                if (semanticContext2 == null) continue;
                arrayList.add(semanticContext2);
            }
            if (!bl2) {
                return this;
            }
            if (arrayList.isEmpty()) {
                return null;
            }
            object = (SemanticContext)arrayList.get(0);
            for (n2 = 1; n2 < arrayList.size(); ++n2) {
                object = SemanticContext.or((SemanticContext)object, (SemanticContext)arrayList.get(n2));
            }
            return object;
        }

        public String toString() {
            return Utils.join(Arrays.asList(this.opnds).iterator(), "||");
        }
    }

    public static class AND
    extends Operator {
        public final SemanticContext[] opnds;

        public AND(SemanticContext object, SemanticContext semanticContext) {
            HashSet<Object> hashSet = new HashSet<Object>();
            if (object instanceof AND) {
                hashSet.addAll(Arrays.asList(((AND)object).opnds));
            } else {
                hashSet.add(object);
            }
            if (semanticContext instanceof AND) {
                hashSet.addAll(Arrays.asList(((AND)semanticContext).opnds));
            } else {
                hashSet.add(semanticContext);
            }
            object = SemanticContext.a(hashSet);
            if (!object.isEmpty()) {
                object = (PrecedencePredicate)Collections.min(object);
                hashSet.add(object);
            }
            HashSet<Object> hashSet2 = hashSet;
            this.opnds = hashSet2.toArray(new SemanticContext[hashSet2.size()]);
        }

        @Override
        public Collection<SemanticContext> getOperands() {
            return Arrays.asList(this.opnds);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof AND)) {
                return false;
            }
            object = (AND)object;
            return Arrays.equals(this.opnds, ((AND)object).opnds);
        }

        public int hashCode() {
            return MurmurHash.hashCode(this.opnds, AND.class.hashCode());
        }

        @Override
        public boolean eval(Recognizer<?, ?> recognizer, RuleContext ruleContext) {
            SemanticContext[] semanticContextArray = this.opnds;
            int n2 = this.opnds.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                SemanticContext semanticContext = semanticContextArray[i2];
                if (semanticContext.eval(recognizer, ruleContext)) continue;
                return false;
            }
            return true;
        }

        @Override
        public SemanticContext evalPrecedence(Recognizer<?, ?> recognizer, RuleContext ruleContext) {
            boolean bl2 = false;
            ArrayList<SemanticContext> arrayList = new ArrayList<SemanticContext>();
            Object object = this.opnds;
            int n2 = this.opnds.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                SemanticContext semanticContext = object[i2];
                SemanticContext semanticContext2 = semanticContext.evalPrecedence(recognizer, ruleContext);
                bl2 |= semanticContext2 != semanticContext;
                if (semanticContext2 == null) {
                    return null;
                }
                if (semanticContext2 == NONE) continue;
                arrayList.add(semanticContext2);
            }
            if (!bl2) {
                return this;
            }
            if (arrayList.isEmpty()) {
                return NONE;
            }
            object = (SemanticContext)arrayList.get(0);
            for (n2 = 1; n2 < arrayList.size(); ++n2) {
                object = SemanticContext.and((SemanticContext)object, (SemanticContext)arrayList.get(n2));
            }
            return object;
        }

        public String toString() {
            return Utils.join(Arrays.asList(this.opnds).iterator(), "&&");
        }
    }

    public static abstract class Operator
    extends SemanticContext {
        public abstract Collection<SemanticContext> getOperands();
    }

    public static class PrecedencePredicate
    extends SemanticContext
    implements Comparable<PrecedencePredicate> {
        public final int precedence;

        protected PrecedencePredicate() {
            this.precedence = 0;
        }

        public PrecedencePredicate(int n2) {
            this.precedence = n2;
        }

        @Override
        public boolean eval(Recognizer<?, ?> recognizer, RuleContext ruleContext) {
            return recognizer.precpred(ruleContext, this.precedence);
        }

        @Override
        public SemanticContext evalPrecedence(Recognizer<?, ?> recognizer, RuleContext ruleContext) {
            if (recognizer.precpred(ruleContext, this.precedence)) {
                return NONE;
            }
            return null;
        }

        @Override
        public int compareTo(PrecedencePredicate precedencePredicate) {
            return this.precedence - precedencePredicate.precedence;
        }

        public int hashCode() {
            int n2 = 31 + this.precedence;
            return n2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof PrecedencePredicate)) {
                return false;
            }
            if (this == object) {
                return true;
            }
            object = (PrecedencePredicate)object;
            return this.precedence == ((PrecedencePredicate)object).precedence;
        }

        public String toString() {
            return "{" + this.precedence + ">=prec}?";
        }
    }

    public static class Predicate
    extends SemanticContext {
        public final int ruleIndex;
        public final int predIndex;
        public final boolean isCtxDependent;

        protected Predicate() {
            this.ruleIndex = -1;
            this.predIndex = -1;
            this.isCtxDependent = false;
        }

        public Predicate(int n2, int n3, boolean bl2) {
            this.ruleIndex = n2;
            this.predIndex = n3;
            this.isCtxDependent = bl2;
        }

        @Override
        public boolean eval(Recognizer<?, ?> recognizer, RuleContext ruleContext) {
            ruleContext = this.isCtxDependent ? ruleContext : null;
            return recognizer.sempred(ruleContext, this.ruleIndex, this.predIndex);
        }

        public int hashCode() {
            int n2 = MurmurHash.initialize();
            n2 = MurmurHash.update(n2, this.ruleIndex);
            n2 = MurmurHash.update(n2, this.predIndex);
            n2 = MurmurHash.update(n2, this.isCtxDependent ? 1 : 0);
            n2 = MurmurHash.finish(n2, 3);
            return n2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Predicate)) {
                return false;
            }
            if (this == object) {
                return true;
            }
            object = (Predicate)object;
            return this.ruleIndex == ((Predicate)object).ruleIndex && this.predIndex == ((Predicate)object).predIndex && this.isCtxDependent == ((Predicate)object).isCtxDependent;
        }

        public String toString() {
            return "{" + this.ruleIndex + ":" + this.predIndex + "}?";
        }
    }
}

