/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal.antlr.misc;

import com.github.jknack.handlebars.internal.antlr.misc.AbstractEqualityComparator;
import com.github.jknack.handlebars.internal.antlr.misc.MurmurHash;
import com.github.jknack.handlebars.internal.antlr.misc.ObjectEqualityComparator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class Array2DHashSet<T>
implements Set<T> {
    public static final int INITAL_CAPACITY = 16;
    public static final int INITAL_BUCKET_CAPACITY = 8;
    public static final double LOAD_FACTOR = 0.75;
    protected final AbstractEqualityComparator<? super T> comparator;
    protected T[][] buckets;
    protected int n = 0;
    protected int threshold = (int)Math.floor(12.0);
    protected int currentPrime = 1;
    protected int initialBucketCapacity = 8;

    public Array2DHashSet() {
        this(null, 16, 8);
    }

    public Array2DHashSet(AbstractEqualityComparator<? super T> abstractEqualityComparator) {
        this(abstractEqualityComparator, 16, 8);
    }

    public Array2DHashSet(AbstractEqualityComparator<? super T> objectEqualityComparator, int n2, int n3) {
        if (objectEqualityComparator == null) {
            objectEqualityComparator = ObjectEqualityComparator.INSTANCE;
        }
        this.comparator = objectEqualityComparator;
        this.buckets = this.createBuckets(n2);
        this.initialBucketCapacity = n3;
    }

    public final T getOrAdd(T t2) {
        if (this.n > this.threshold) {
            this.expand();
        }
        return this.getOrAddImpl(t2);
    }

    protected T getOrAddImpl(T t2) {
        int n2;
        int n3 = this.getBucket(t2);
        T[] TArray = this.buckets[n3];
        if (TArray == null) {
            Array2DHashSet array2DHashSet = this;
            T[] TArray2 = array2DHashSet.createBucket(array2DHashSet.initialBucketCapacity);
            TArray = TArray2;
            TArray2[0] = t2;
            this.buckets[n3] = TArray;
            ++this.n;
            return t2;
        }
        for (n2 = 0; n2 < TArray.length; ++n2) {
            T t3 = TArray[n2];
            if (t3 == null) {
                TArray[n2] = t2;
                ++this.n;
                return t2;
            }
            if (!this.comparator.equals(t3, t2)) continue;
            return t3;
        }
        n2 = TArray.length;
        TArray = Arrays.copyOf(TArray, TArray.length << 1);
        this.buckets[n3] = TArray;
        TArray[n2] = t2;
        ++this.n;
        return t2;
    }

    public T get(T t2) {
        if (t2 == null) {
            return t2;
        }
        int n2 = this.getBucket(t2);
        T[] TArray = this.buckets[n2];
        if (TArray == null) {
            return null;
        }
        for (T t3 : TArray) {
            if (t3 == null) {
                return null;
            }
            if (!this.comparator.equals(t3, t2)) continue;
            return t3;
        }
        return null;
    }

    protected final int getBucket(T t2) {
        int n2 = this.comparator.hashCode(t2);
        return n2 &= this.buckets.length - 1;
    }

    @Override
    public int hashCode() {
        int n2 = MurmurHash.initialize();
        T[][] TArray = this.buckets;
        int n3 = this.buckets.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            T[] TArray2 = TArray[i2];
            if (TArray2 == null) continue;
            for (T t2 : TArray2) {
                if (t2 == null) break;
                n2 = MurmurHash.update(n2, this.comparator.hashCode(t2));
            }
        }
        n2 = MurmurHash.finish(n2, this.size());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Array2DHashSet)) {
            return false;
        }
        if (((Array2DHashSet)(object = (Array2DHashSet)object)).size() != this.size()) {
            return false;
        }
        boolean bl2 = this.containsAll((Collection<?>)object);
        return bl2;
    }

    protected void expand() {
        T[][] TArray = this.buckets;
        this.currentPrime += 4;
        int n2 = this.buckets.length << 1;
        T[][] TArray2 = this.createBuckets(n2);
        int[] nArray = new int[TArray2.length];
        this.buckets = TArray2;
        this.threshold = (int)((double)n2 * 0.75);
        n2 = this.size();
        for (T[] TArray3 : TArray) {
            T t2;
            if (TArray3 == null) continue;
            int n3 = TArray3.length;
            for (int i2 = 0; i2 < n3 && (t2 = TArray3[i2]) != null; ++i2) {
                T[] TArray4;
                int n4 = this.getBucket(t2);
                int n5 = nArray[n4];
                if (n5 == 0) {
                    Array2DHashSet array2DHashSet = this;
                    TArray4 = array2DHashSet.createBucket(array2DHashSet.initialBucketCapacity);
                    TArray2[n4] = TArray4;
                } else {
                    TArray4 = TArray2[n4];
                    if (n5 == TArray4.length) {
                        TArray4 = Arrays.copyOf(TArray4, TArray4.length << 1);
                        TArray2[n4] = TArray4;
                    }
                }
                TArray4[n5] = t2;
                int n6 = n4;
                nArray[n6] = nArray[n6] + 1;
            }
        }
        assert (this.n == n2);
    }

    @Override
    public final boolean add(T t2) {
        T t3 = this.getOrAdd(t2);
        return t3 == t2;
    }

    @Override
    public final int size() {
        return this.n;
    }

    @Override
    public final boolean isEmpty() {
        return this.n == 0;
    }

    @Override
    public final boolean contains(Object object) {
        Array2DHashSet array2DHashSet = this;
        return array2DHashSet.containsFast(array2DHashSet.asElementType(object));
    }

    public boolean containsFast(T t2) {
        if (t2 == null) {
            return false;
        }
        return this.get(t2) != null;
    }

    @Override
    public Iterator<T> iterator() {
        Array2DHashSet array2DHashSet = this;
        return new SetIterator(array2DHashSet, array2DHashSet.toArray());
    }

    @Override
    public T[] toArray() {
        Array2DHashSet array2DHashSet = this;
        T[] TArray = array2DHashSet.createBucket(array2DHashSet.size());
        int n2 = 0;
        T[][] TArray2 = this.buckets;
        int n3 = this.buckets.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            T[] TArray3 = TArray2[i2];
            if (TArray3 == null) continue;
            for (T t2 : TArray3) {
                if (t2 == null) break;
                TArray[n2++] = t2;
            }
        }
        return TArray;
    }

    @Override
    public <U> U[] toArray(U[] UArray) {
        if (UArray.length < this.size()) {
            UArray = Arrays.copyOf(UArray, this.size());
        }
        int n2 = 0;
        T[][] TArray = this.buckets;
        int n3 = this.buckets.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            T[] TArray2 = TArray[i2];
            if (TArray2 == null) continue;
            for (T t2 : TArray2) {
                if (t2 == null) break;
                UArray[n2++] = t2;
            }
        }
        return UArray;
    }

    @Override
    public final boolean remove(Object object) {
        Array2DHashSet array2DHashSet = this;
        return array2DHashSet.removeFast(array2DHashSet.asElementType(object));
    }

    public boolean removeFast(T t2) {
        if (t2 == null) {
            return false;
        }
        int n2 = this.getBucket(t2);
        T[] TArray = this.buckets[n2];
        if (TArray == null) {
            return false;
        }
        for (int i2 = 0; i2 < TArray.length; ++i2) {
            T t3 = TArray[i2];
            if (t3 == null) {
                return false;
            }
            if (!this.comparator.equals(t3, t2)) continue;
            System.arraycopy(TArray, i2 + 1, TArray, i2, TArray.length - i2 - 1);
            TArray[TArray.length - 1] = null;
            --this.n;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> object) {
        if (object instanceof Array2DHashSet) {
            object = (Array2DHashSet)object;
            T[][] TArray = ((Array2DHashSet)object).buckets;
            int n2 = ((Array2DHashSet)object).buckets.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                T[] TArray2 = TArray[i2];
                if (TArray2 == null) continue;
                for (T t2 : TArray2) {
                    if (t2 == null) break;
                    Array2DHashSet array2DHashSet = this;
                    if (array2DHashSet.containsFast(array2DHashSet.asElementType(t2))) continue;
                    return false;
                }
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                Object e2 = object.next();
                Array2DHashSet array2DHashSet = this;
                if (array2DHashSet.containsFast(array2DHashSet.asElementType(e2))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> object) {
        boolean bl2 = false;
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            Object e3 = this.getOrAdd(e2);
            if (e3 == e2) continue;
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        int n2 = 0;
        T[][] TArray = this.buckets;
        int n3 = this.buckets.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4;
            T[] TArray2 = TArray[i2];
            if (TArray2 == null) continue;
            int n5 = 0;
            for (n4 = 0; n4 < TArray2.length && TArray2[n4] != null; ++n4) {
                if (!collection.contains(TArray2[n4])) continue;
                if (n4 != n5) {
                    TArray2[n5] = TArray2[n4];
                }
                ++n5;
                ++n2;
            }
            n2 += n5;
            while (n5 < n4) {
                TArray2[n5] = null;
                ++n5;
            }
        }
        boolean bl2 = n2 != this.n;
        this.n = n2;
        return bl2;
    }

    @Override
    public boolean removeAll(Collection<?> object) {
        boolean bl2 = false;
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            Array2DHashSet array2DHashSet = this;
            bl2 |= array2DHashSet.removeFast(array2DHashSet.asElementType(e2));
        }
        return bl2;
    }

    @Override
    public void clear() {
        this.buckets = this.createBuckets(16);
        this.n = 0;
        this.threshold = (int)Math.floor(12.0);
    }

    public String toString() {
        if (this.size() == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        boolean bl2 = true;
        T[][] TArray = this.buckets;
        int n2 = this.buckets.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            T[] TArray2 = TArray[i2];
            if (TArray2 == null) continue;
            for (T t2 : TArray2) {
                if (t2 == null) break;
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(t2.toString());
            }
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public String toTableString() {
        StringBuilder stringBuilder = new StringBuilder();
        T[][] TArray = this.buckets;
        int n2 = this.buckets.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            T[] TArray2 = TArray[i2];
            if (TArray2 == null) {
                stringBuilder.append("null\n");
                continue;
            }
            stringBuilder.append('[');
            boolean bl2 = true;
            for (T t2 : TArray2) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuilder.append(" ");
                }
                if (t2 == null) {
                    stringBuilder.append("_");
                    continue;
                }
                stringBuilder.append(t2.toString());
            }
            stringBuilder.append("]\n");
        }
        return stringBuilder.toString();
    }

    protected T asElementType(Object object) {
        return (T)object;
    }

    protected T[][] createBuckets(int n2) {
        return new Object[n2][];
    }

    protected T[] createBucket(int n2) {
        return new Object[n2];
    }

    protected class SetIterator
    implements Iterator<T> {
        private T[] a;
        private int b = 0;
        private boolean c = true;
        private /* synthetic */ Array2DHashSet d;

        public SetIterator(Array2DHashSet array2DHashSet, T[] TArray) {
            this.d = array2DHashSet;
            this.a = TArray;
        }

        @Override
        public boolean hasNext() {
            return this.b < this.a.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.c = false;
            return this.a[this.b++];
        }

        @Override
        public void remove() {
            if (this.c) {
                throw new IllegalStateException();
            }
            this.d.remove(this.a[this.b - 1]);
            this.c = true;
        }
    }
}

