/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal.antlr.misc;

import com.github.jknack.handlebars.internal.antlr.misc.AbstractEqualityComparator;
import com.github.jknack.handlebars.internal.antlr.misc.MurmurHash;
import com.github.jknack.handlebars.internal.antlr.misc.ObjectEqualityComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class FlexibleHashMap<K, V>
implements Map<K, V> {
    public static final int INITAL_CAPACITY = 16;
    public static final int INITAL_BUCKET_CAPACITY = 8;
    public static final double LOAD_FACTOR = 0.75;
    protected final AbstractEqualityComparator<? super K> comparator;
    protected LinkedList<Entry<K, V>>[] buckets;
    protected int n = 0;
    protected int threshold = 12;
    protected int currentPrime = 1;
    protected int initialBucketCapacity = 8;

    public FlexibleHashMap() {
        this(null, 16, 8);
    }

    public FlexibleHashMap(AbstractEqualityComparator<? super K> abstractEqualityComparator) {
        this(abstractEqualityComparator, 16, 8);
    }

    public FlexibleHashMap(AbstractEqualityComparator<? super K> objectEqualityComparator, int n2, int n3) {
        if (objectEqualityComparator == null) {
            objectEqualityComparator = ObjectEqualityComparator.INSTANCE;
        }
        this.comparator = objectEqualityComparator;
        this.buckets = FlexibleHashMap.a(n3);
        this.initialBucketCapacity = n3;
    }

    private static <K, V> LinkedList<Entry<K, V>>[] a(int n2) {
        LinkedList[] linkedListArray = new LinkedList[n2];
        return linkedListArray;
    }

    protected int getBucket(K k2) {
        int n2 = this.comparator.hashCode(k2);
        return n2 &= this.buckets.length - 1;
    }

    @Override
    public V get(Object object) {
        Object object2 = object;
        if (object == null) {
            return null;
        }
        int n2 = this.getBucket(object2);
        LinkedList<Entry<K, V>> linkedList = this.buckets[n2];
        if (linkedList == null) {
            return null;
        }
        for (Entry entry : linkedList) {
            if (!this.comparator.equals(entry.key, object2)) continue;
            return entry.value;
        }
        return null;
    }

    @Override
    public V put(K object, V v2) {
        int n2;
        LinkedList<Entry<K, V>> linkedList;
        if (object == null) {
            return null;
        }
        if (this.n > this.threshold) {
            this.expand();
        }
        if ((linkedList = this.buckets[n2 = this.getBucket(object)]) == null) {
            this.buckets[n2] = new LinkedList();
            linkedList = this.buckets[n2];
        }
        for (Entry entry : linkedList) {
            if (!this.comparator.equals(entry.key, object)) continue;
            object = entry.value;
            entry.value = v2;
            ++this.n;
            return (V)object;
        }
        linkedList.add(new Entry<Object, V>(object, v2));
        ++this.n;
        return null;
    }

    @Override
    public V remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        ArrayList arrayList = new ArrayList(this.size());
        LinkedList<Entry<K, V>>[] linkedListArray = this.buckets;
        int n2 = this.buckets.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            LinkedList<Entry<K, V>> linkedList = linkedListArray[i2];
            if (linkedList == null) continue;
            for (Entry entry : linkedList) {
                arrayList.add(entry.value);
            }
        }
        return arrayList;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        int n2 = MurmurHash.initialize();
        LinkedList<Entry<K, V>>[] linkedListArray = this.buckets;
        int n3 = this.buckets.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Entry entry;
            LinkedList<Entry<K, V>> linkedList = linkedListArray[i2];
            if (linkedList == null) continue;
            linkedList = linkedList.iterator();
            while (linkedList.hasNext() && (entry = (Entry)linkedList.next()) != null) {
                n2 = MurmurHash.update(n2, this.comparator.hashCode(entry.key));
            }
        }
        n2 = MurmurHash.finish(n2, this.size());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        throw new UnsupportedOperationException();
    }

    protected void expand() {
        LinkedList<Entry<K, V>>[] linkedListArray = this.buckets;
        this.currentPrime += 4;
        int n2 = this.buckets.length << 1;
        LinkedList<Entry<K, V>>[] linkedListArray2 = FlexibleHashMap.a(n2);
        this.buckets = linkedListArray2;
        this.threshold = (int)((double)n2 * 0.75);
        n2 = this.size();
        for (LinkedList<Entry<K, V>> linkedList : linkedListArray) {
            Entry entry;
            if (linkedList == null) continue;
            linkedList = linkedList.iterator();
            while (linkedList.hasNext() && (entry = (Entry)linkedList.next()) != null) {
                this.put(entry.key, entry.value);
            }
        }
        this.n = n2;
    }

    @Override
    public int size() {
        return this.n;
    }

    @Override
    public boolean isEmpty() {
        return this.n == 0;
    }

    @Override
    public void clear() {
        this.buckets = FlexibleHashMap.a(16);
        this.n = 0;
    }

    public String toString() {
        if (this.size() == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        boolean bl2 = true;
        LinkedList<Entry<K, V>>[] linkedListArray = this.buckets;
        int n2 = this.buckets.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Entry entry;
            LinkedList<Entry<K, V>> linkedList = linkedListArray[i2];
            if (linkedList == null) continue;
            linkedList = linkedList.iterator();
            while (linkedList.hasNext() && (entry = (Entry)linkedList.next()) != null) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(entry.toString());
            }
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public String toTableString() {
        StringBuilder stringBuilder = new StringBuilder();
        LinkedList<Entry<K, V>>[] linkedListArray = this.buckets;
        int n2 = this.buckets.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            LinkedList<Entry<K, V>> linkedList = linkedListArray[i2];
            if (linkedList == null) {
                stringBuilder.append("null\n");
                continue;
            }
            stringBuilder.append('[');
            boolean bl2 = true;
            for (Entry entry : linkedList) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuilder.append(" ");
                }
                if (entry == null) {
                    stringBuilder.append("_");
                    continue;
                }
                stringBuilder.append(entry.toString());
            }
            stringBuilder.append("]\n");
        }
        return stringBuilder.toString();
    }

    public static void main(String[] object) {
        object = new FlexibleHashMap<String, Integer>();
        ((FlexibleHashMap)object).put("hi", 1);
        ((FlexibleHashMap)object).put("mom", 2);
        ((FlexibleHashMap)object).put("foo", 3);
        ((FlexibleHashMap)object).put("ach", 4);
        ((FlexibleHashMap)object).put("cbba", 5);
        ((FlexibleHashMap)object).put("d", 6);
        ((FlexibleHashMap)object).put("edf", 7);
        ((FlexibleHashMap)object).put("mom", 8);
        ((FlexibleHashMap)object).put("hi", 9);
        System.out.println(object);
        System.out.println(((FlexibleHashMap)object).toTableString());
    }

    public static class Entry<K, V> {
        public final K key;
        public V value;

        public Entry(K k2, V v2) {
            this.key = k2;
            this.value = v2;
        }

        public String toString() {
            return this.key.toString() + ":" + this.value.toString();
        }
    }
}

