/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal.antlr.misc;

public class Interval {
    public static final int INTERVAL_POOL_MAX_VALUE = 1000;
    public static final Interval INVALID = new Interval(-1, -2);
    private static Interval[] c = new Interval[1001];
    public int a;
    public int b;
    public static int creates = 0;
    public static int misses = 0;
    public static int hits = 0;
    public static int outOfRange = 0;

    public Interval(int n2, int n3) {
        this.a = n2;
        this.b = n3;
    }

    public static Interval of(int n2, int n3) {
        if (n2 != n3 || n2 < 0 || n2 > 1000) {
            return new Interval(n2, n3);
        }
        if (c[n2] == null) {
            int n4 = n2;
            Interval.c[n2] = new Interval(n4, n4);
        }
        return c[n2];
    }

    public int length() {
        if (this.b < this.a) {
            return 0;
        }
        return this.b - this.a + 1;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Interval)) {
            return false;
        }
        object = (Interval)object;
        return this.a == ((Interval)object).a && this.b == ((Interval)object).b;
    }

    public int hashCode() {
        int n2 = 713 + this.a;
        n2 = n2 * 31 + this.b;
        return n2;
    }

    public boolean startsBeforeDisjoint(Interval interval) {
        return this.a < interval.a && this.b < interval.a;
    }

    public boolean startsBeforeNonDisjoint(Interval interval) {
        return this.a <= interval.a && this.b >= interval.a;
    }

    public boolean startsAfter(Interval interval) {
        return this.a > interval.a;
    }

    public boolean startsAfterDisjoint(Interval interval) {
        return this.a > interval.b;
    }

    public boolean startsAfterNonDisjoint(Interval interval) {
        return this.a > interval.a && this.a <= interval.b;
    }

    public boolean disjoint(Interval interval) {
        return this.startsBeforeDisjoint(interval) || this.startsAfterDisjoint(interval);
    }

    public boolean adjacent(Interval interval) {
        return this.a == interval.b + 1 || this.b == interval.a - 1;
    }

    public boolean properlyContains(Interval interval) {
        return interval.a >= this.a && interval.b <= this.b;
    }

    public Interval union(Interval interval) {
        return Interval.of(Math.min(this.a, interval.a), Math.max(this.b, interval.b));
    }

    public Interval intersection(Interval interval) {
        return Interval.of(Math.max(this.a, interval.a), Math.min(this.b, interval.b));
    }

    public Interval differenceNotProperlyContained(Interval interval) {
        Interval interval2 = null;
        if (interval.startsBeforeNonDisjoint(this)) {
            interval2 = Interval.of(Math.max(this.a, interval.b + 1), this.b);
        } else if (interval.startsAfterNonDisjoint(this)) {
            interval2 = Interval.of(this.a, interval.a - 1);
        }
        return interval2;
    }

    public String toString() {
        return this.a + ".." + this.b;
    }
}

