/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal.antlr.misc;

import com.github.jknack.handlebars.internal.antlr.Vocabulary;
import com.github.jknack.handlebars.internal.antlr.VocabularyImpl;
import com.github.jknack.handlebars.internal.antlr.misc.IntSet;
import com.github.jknack.handlebars.internal.antlr.misc.IntegerList;
import com.github.jknack.handlebars.internal.antlr.misc.Interval;
import com.github.jknack.handlebars.internal.antlr.misc.MurmurHash;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class IntervalSet
implements IntSet {
    public static final IntervalSet COMPLETE_CHAR_SET = IntervalSet.of(0, 0x10FFFF);
    public static final IntervalSet EMPTY_SET;
    protected List<Interval> intervals;
    protected boolean readonly;

    public IntervalSet(List<Interval> list) {
        this.intervals = list;
    }

    public IntervalSet(IntervalSet intervalSet) {
        this(new int[0]);
        this.addAll(intervalSet);
    }

    public IntervalSet(int ... nArray) {
        if (nArray == null) {
            this.intervals = new ArrayList<Interval>(2);
            return;
        }
        this.intervals = new ArrayList<Interval>(nArray.length);
        for (int n2 : nArray) {
            this.add(n2);
        }
    }

    public static IntervalSet of(int n2) {
        IntervalSet intervalSet = new IntervalSet(new int[0]);
        intervalSet.add(n2);
        return intervalSet;
    }

    public static IntervalSet of(int n2, int n3) {
        IntervalSet intervalSet = new IntervalSet(new int[0]);
        intervalSet.add(n2, n3);
        return intervalSet;
    }

    public void clear() {
        if (this.readonly) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        this.intervals.clear();
    }

    @Override
    public void add(int n2) {
        if (this.readonly) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        int n3 = n2;
        this.add(n3, n3);
    }

    public void add(int n2, int n3) {
        this.add(Interval.of(n2, n3));
    }

    protected void add(Interval interval) {
        if (this.readonly) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        if (interval.b < interval.a) {
            return;
        }
        ListIterator<Interval> listIterator = this.intervals.listIterator();
        while (listIterator.hasNext()) {
            Interval interval2 = listIterator.next();
            if (interval.equals(interval2)) {
                return;
            }
            if (interval.adjacent(interval2) || !interval.disjoint(interval2)) {
                interval = interval.union(interval2);
                listIterator.set(interval);
                while (listIterator.hasNext() && (interval.adjacent(interval2 = listIterator.next()) || !interval.disjoint(interval2))) {
                    listIterator.remove();
                    listIterator.previous();
                    listIterator.set(interval.union(interval2));
                    listIterator.next();
                }
                return;
            }
            if (!interval.startsBeforeDisjoint(interval2)) continue;
            listIterator.previous();
            listIterator.add(interval);
            return;
        }
        this.intervals.add(interval);
    }

    public static IntervalSet or(IntervalSet[] intervalSetArray) {
        IntervalSet intervalSet = new IntervalSet(new int[0]);
        for (IntervalSet intervalSet2 : intervalSetArray) {
            intervalSet.addAll(intervalSet2);
        }
        return intervalSet;
    }

    @Override
    public IntervalSet addAll(IntSet object) {
        if (object == null) {
            return this;
        }
        if (object instanceof IntervalSet) {
            object = (IntervalSet)object;
            int n2 = ((IntervalSet)object).intervals.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Interval interval = ((IntervalSet)object).intervals.get(i2);
                this.add(interval.a, interval.b);
            }
        } else {
            object = object.toList().iterator();
            while (object.hasNext()) {
                int n3 = (Integer)object.next();
                this.add(n3);
            }
        }
        return this;
    }

    public IntervalSet complement(int n2, int n3) {
        return this.complement(IntervalSet.of(n2, n3));
    }

    @Override
    public IntervalSet complement(IntSet intSet) {
        IntervalSet intervalSet;
        if (intSet == null || intSet.isNil()) {
            return null;
        }
        if (intSet instanceof IntervalSet) {
            intervalSet = (IntervalSet)intSet;
        } else {
            intervalSet = new IntervalSet(new int[0]);
            intervalSet.addAll(intSet);
        }
        return intervalSet.subtract(this);
    }

    @Override
    public IntervalSet subtract(IntSet intSet) {
        if (intSet == null || intSet.isNil()) {
            return new IntervalSet(this);
        }
        if (intSet instanceof IntervalSet) {
            return IntervalSet.subtract(this, (IntervalSet)intSet);
        }
        IntervalSet intervalSet = new IntervalSet(new int[0]);
        intervalSet.addAll(intSet);
        return IntervalSet.subtract(this, intervalSet);
    }

    public static IntervalSet subtract(IntervalSet intervalSet, IntervalSet intervalSet2) {
        if (intervalSet == null || intervalSet.isNil()) {
            return new IntervalSet(new int[0]);
        }
        intervalSet = new IntervalSet(intervalSet);
        if (intervalSet2 == null || intervalSet2.isNil()) {
            return intervalSet;
        }
        int n2 = 0;
        int n3 = 0;
        while (n2 < intervalSet.intervals.size() && n3 < intervalSet2.intervals.size()) {
            Interval interval = intervalSet.intervals.get(n2);
            Interval interval2 = intervalSet2.intervals.get(n3);
            if (interval2.b < interval.a) {
                ++n3;
                continue;
            }
            if (interval2.a > interval.b) {
                ++n2;
                continue;
            }
            Interval interval3 = null;
            Interval interval4 = null;
            if (interval2.a > interval.a) {
                interval3 = new Interval(interval.a, interval2.a - 1);
            }
            if (interval2.b < interval.b) {
                interval4 = new Interval(interval2.b + 1, interval.b);
            }
            if (interval3 != null) {
                if (interval4 != null) {
                    intervalSet.intervals.set(n2, interval3);
                    intervalSet.intervals.add(n2 + 1, interval4);
                    ++n2;
                    ++n3;
                    continue;
                }
                intervalSet.intervals.set(n2, interval3);
                ++n2;
                continue;
            }
            if (interval4 != null) {
                intervalSet.intervals.set(n2, interval4);
                ++n3;
                continue;
            }
            intervalSet.intervals.remove(n2);
        }
        return intervalSet;
    }

    @Override
    public IntervalSet or(IntSet intSet) {
        IntervalSet intervalSet = new IntervalSet(new int[0]);
        intervalSet.addAll(this);
        intervalSet.addAll(intSet);
        return intervalSet;
    }

    @Override
    public IntervalSet and(IntSet object) {
        if (object == null) {
            return null;
        }
        List<Interval> list = this.intervals;
        object = ((IntervalSet)object).intervals;
        IntervalSet intervalSet = null;
        int n2 = list.size();
        int n3 = object.size();
        int n4 = 0;
        int n5 = 0;
        while (n4 < n2 && n5 < n3) {
            Interval interval;
            Interval interval2 = list.get(n4);
            if (interval2.startsBeforeDisjoint(interval = (Interval)object.get(n5))) {
                ++n4;
                continue;
            }
            if (interval.startsBeforeDisjoint(interval2)) {
                ++n5;
                continue;
            }
            if (interval2.properlyContains(interval)) {
                if (intervalSet == null) {
                    intervalSet = new IntervalSet(new int[0]);
                }
                intervalSet.add(interval2.intersection(interval));
                ++n5;
                continue;
            }
            if (interval.properlyContains(interval2)) {
                if (intervalSet == null) {
                    intervalSet = new IntervalSet(new int[0]);
                }
                intervalSet.add(interval2.intersection(interval));
                ++n4;
                continue;
            }
            if (interval2.disjoint(interval)) continue;
            if (intervalSet == null) {
                intervalSet = new IntervalSet(new int[0]);
            }
            intervalSet.add(interval2.intersection(interval));
            if (interval2.startsAfterNonDisjoint(interval)) {
                ++n5;
                continue;
            }
            if (!interval.startsAfterNonDisjoint(interval2)) continue;
            ++n4;
        }
        if (intervalSet == null) {
            return new IntervalSet(new int[0]);
        }
        return intervalSet;
    }

    @Override
    public boolean contains(int n2) {
        int n3 = this.intervals.size();
        int n4 = 0;
        --n3;
        while (n4 <= n3) {
            int n5 = (n4 + n3) / 2;
            Interval interval = this.intervals.get(n5);
            int n6 = interval.a;
            int n7 = interval.b;
            if (n7 < n2) {
                n4 = n5 + 1;
                continue;
            }
            if (n6 > n2) {
                n3 = n5 - 1;
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isNil() {
        return this.intervals == null || this.intervals.isEmpty();
    }

    public int getMaxElement() {
        if (this.isNil()) {
            throw new RuntimeException("set is empty");
        }
        Interval interval = this.intervals.get(this.intervals.size() - 1);
        return interval.b;
    }

    public int getMinElement() {
        if (this.isNil()) {
            throw new RuntimeException("set is empty");
        }
        return this.intervals.get((int)0).a;
    }

    public List<Interval> getIntervals() {
        return this.intervals;
    }

    public int hashCode() {
        int n2 = MurmurHash.initialize();
        for (Interval interval : this.intervals) {
            n2 = MurmurHash.update(n2, interval.a);
            n2 = MurmurHash.update(n2, interval.b);
        }
        n2 = MurmurHash.finish(n2, this.intervals.size() << 1);
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof IntervalSet)) {
            return false;
        }
        object = (IntervalSet)object;
        return this.intervals.equals(((IntervalSet)object).intervals);
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.intervals == null || this.intervals.isEmpty()) {
            return "{}";
        }
        if (this.size() > 1) {
            stringBuilder.append("{");
        }
        Iterator<Interval> iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            Interval interval = iterator.next();
            int n2 = interval.a;
            int n3 = interval.b;
            if (n2 == n3) {
                if (n2 == -1) {
                    stringBuilder.append("<EOF>");
                } else if (bl2) {
                    stringBuilder.append("'").appendCodePoint(n2).append("'");
                } else {
                    stringBuilder.append(n2);
                }
            } else if (bl2) {
                stringBuilder.append("'").appendCodePoint(n2).append("'..'").appendCodePoint(n3).append("'");
            } else {
                stringBuilder.append(n2).append("..").append(n3);
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        if (this.size() > 1) {
            stringBuilder.append("}");
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public String toString(String[] stringArray) {
        return this.toString(VocabularyImpl.fromTokenNames(stringArray));
    }

    public String toString(Vocabulary vocabulary) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.intervals == null || this.intervals.isEmpty()) {
            return "{}";
        }
        if (this.size() > 1) {
            stringBuilder.append("{");
        }
        Iterator<Interval> iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            Interval interval = iterator.next();
            int n2 = interval.a;
            int n3 = interval.b;
            if (n2 == n3) {
                stringBuilder.append(this.elementName(vocabulary, n2));
            } else {
                for (int i2 = n2; i2 <= n3; ++i2) {
                    if (i2 > n2) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(this.elementName(vocabulary, i2));
                }
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        if (this.size() > 1) {
            stringBuilder.append("}");
        }
        return stringBuilder.toString();
    }

    @Deprecated
    protected String elementName(String[] stringArray, int n2) {
        return this.elementName(VocabularyImpl.fromTokenNames(stringArray), n2);
    }

    protected String elementName(Vocabulary vocabulary, int n2) {
        if (n2 == -1) {
            return "<EOF>";
        }
        if (n2 == -2) {
            return "<EPSILON>";
        }
        return vocabulary.getDisplayName(n2);
    }

    @Override
    public int size() {
        int n2 = 0;
        int n3 = this.intervals.size();
        if (n3 == 1) {
            Interval interval = this.intervals.get(0);
            return interval.b - interval.a + 1;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            Interval interval = this.intervals.get(i2);
            n2 += interval.b - interval.a + 1;
        }
        return n2;
    }

    public IntegerList toIntegerList() {
        IntegerList integerList = new IntegerList(this.size());
        int n2 = this.intervals.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Interval interval = this.intervals.get(i2);
            int n3 = interval.a;
            int n4 = interval.b;
            while (n3 <= n4) {
                integerList.add(n3);
                ++n3;
            }
        }
        return integerList;
    }

    @Override
    public List<Integer> toList() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = this.intervals.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Interval interval = this.intervals.get(i2);
            int n3 = interval.a;
            int n4 = interval.b;
            while (n3 <= n4) {
                arrayList.add(n3);
                ++n3;
            }
        }
        return arrayList;
    }

    public Set<Integer> toSet() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Interval interval : this.intervals) {
            int n2 = interval.a;
            int n3 = interval.b;
            while (n2 <= n3) {
                hashSet.add(n2);
                ++n2;
            }
        }
        return hashSet;
    }

    public int get(int n2) {
        int n3 = this.intervals.size();
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            Interval interval = this.intervals.get(i2);
            int n5 = interval.a;
            int n6 = interval.b;
            while (n5 <= n6) {
                if (n4 == n2) {
                    return n5;
                }
                ++n4;
                ++n5;
            }
        }
        return -1;
    }

    public int[] toArray() {
        return this.toIntegerList().toArray();
    }

    @Override
    public void remove(int n2) {
        if (this.readonly) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        int n3 = this.intervals.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            Interval interval = this.intervals.get(i2);
            int n4 = interval.a;
            int n5 = interval.b;
            if (n2 < n4) break;
            if (n2 == n4 && n2 == n5) {
                this.intervals.remove(i2);
                return;
            }
            if (n2 == n4) {
                ++interval.a;
                return;
            }
            if (n2 == n5) {
                --interval.b;
                return;
            }
            if (n2 <= n4 || n2 >= n5) continue;
            n4 = interval.b;
            interval.b = n2 - 1;
            this.add(n2 + 1, n4);
        }
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean bl2) {
        if (this.readonly && !bl2) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        this.readonly = bl2;
    }

    static {
        COMPLETE_CHAR_SET.setReadonly(true);
        EMPTY_SET = new IntervalSet(new int[0]);
        EMPTY_SET.setReadonly(true);
    }
}

