/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal.antlr.misc;

import com.github.jknack.handlebars.internal.antlr.misc.IntegerList;
import com.github.jknack.handlebars.internal.antlr.misc.IntervalSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Utils {
    public static <T> String join(Iterator<T> iterator, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static <T> String join(T[] TArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < TArray.length; ++i2) {
            stringBuilder.append(TArray[i2]);
            if (i2 >= TArray.length - 1) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static int numNonnull(Object[] objectArray) {
        int n2 = 0;
        if (objectArray == null) {
            return 0;
        }
        for (Object object : objectArray) {
            if (object == null) continue;
            ++n2;
        }
        return n2;
    }

    public static <T> void removeAllElements(Collection<T> collection, T t2) {
        if (collection == null) {
            return;
        }
        while (collection.contains(t2)) {
            collection.remove(t2);
        }
    }

    public static String escapeWhitespace(String object, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = object[i2];
            if (object2 == 32 && bl2) {
                stringBuilder.append('\u00b7');
                continue;
            }
            if (object2 == 9) {
                stringBuilder.append("\\t");
                continue;
            }
            if (object2 == 10) {
                stringBuilder.append("\\n");
                continue;
            }
            if (object2 == 13) {
                stringBuilder.append("\\r");
                continue;
            }
            stringBuilder.append((char)object2);
        }
        return stringBuilder.toString();
    }

    public static void writeFile(String string, String string2) {
        Utils.writeFile(string, string2, null);
    }

    public static void writeFile(String object, String string, String string2) {
        object = new File((String)object);
        object = new FileOutputStream((File)object);
        object = string2 != null ? new OutputStreamWriter((OutputStream)object, string2) : new OutputStreamWriter((OutputStream)object);
        try {
            ((Writer)object).write(string);
            return;
        }
        finally {
            ((OutputStreamWriter)object).close();
        }
    }

    public static char[] readFile(String string) {
        return Utils.readFile(string, null);
    }

    public static char[] readFile(String object, String object2) {
        File file = new File((String)object);
        int n2 = (int)file.length();
        object = new FileInputStream((String)object);
        object = object2 != null ? new InputStreamReader((InputStream)object, (String)object2) : new InputStreamReader((InputStream)object);
        try {
            object2 = new char[n2];
            n2 = ((Reader)object).read((char[])object2);
            if (n2 < ((Object)object2).length) {
                object2 = Arrays.copyOf((char[])object2, n2);
            }
        }
        finally {
            ((InputStreamReader)object).close();
        }
        return object2;
    }

    public static Map<String, Integer> toMap(String[] stringArray) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            hashMap.put(stringArray[i2], i2);
        }
        return hashMap;
    }

    public static char[] toCharArray(IntegerList integerList) {
        if (integerList == null) {
            return null;
        }
        return integerList.toCharArray();
    }

    public static IntervalSet toSet(BitSet bitSet) {
        IntervalSet intervalSet = new IntervalSet(new int[0]);
        int n2 = bitSet.nextSetBit(0);
        while (n2 >= 0) {
            intervalSet.add(n2);
            n2 = bitSet.nextSetBit(n2 + 1);
        }
        return intervalSet;
    }

    public static String expandTabs(String string, int n2) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        block4: for (int i2 = 0; i2 < string.length(); ++i2) {
            int n4 = string.charAt(i2);
            switch (n4) {
                case 10: {
                    n3 = 0;
                    stringBuilder.append((char)n4);
                    continue block4;
                }
                case 9: {
                    n4 = n2 - n3 % n2;
                    n3 += n4;
                    stringBuilder.append(Utils.spaces(n4));
                    continue block4;
                }
                default: {
                    ++n3;
                    stringBuilder.append((char)n4);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String spaces(int n2) {
        return Utils.sequence(n2, " ");
    }

    public static String newlines(int n2) {
        return Utils.sequence(n2, "\n");
    }

    public static String sequence(int n2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 1; i2 <= n2; ++i2) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static int count(String string, char c2) {
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) != c2) continue;
            ++n2;
        }
        return n2;
    }
}

