/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal.antlr.tree;

import com.github.jknack.handlebars.internal.antlr.CommonToken;
import com.github.jknack.handlebars.internal.antlr.Parser;
import com.github.jknack.handlebars.internal.antlr.ParserRuleContext;
import com.github.jknack.handlebars.internal.antlr.RuleContext;
import com.github.jknack.handlebars.internal.antlr.Token;
import com.github.jknack.handlebars.internal.antlr.misc.Interval;
import com.github.jknack.handlebars.internal.antlr.misc.Predicate;
import com.github.jknack.handlebars.internal.antlr.misc.Utils;
import com.github.jknack.handlebars.internal.antlr.tree.ErrorNode;
import com.github.jknack.handlebars.internal.antlr.tree.ParseTree;
import com.github.jknack.handlebars.internal.antlr.tree.TerminalNode;
import com.github.jknack.handlebars.internal.antlr.tree.TerminalNodeImpl;
import com.github.jknack.handlebars.internal.antlr.tree.Tree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Trees {
    public static String toStringTree(Tree tree) {
        return Trees.toStringTree(tree, null);
    }

    public static String toStringTree(Tree tree, Parser object) {
        object = object != null ? object.getRuleNames() : null;
        object = object != null ? Arrays.asList(object) : null;
        return Trees.toStringTree(tree, (List<String>)object);
    }

    public static String toStringTree(Tree tree, List<String> list) {
        String string = Utils.escapeWhitespace(Trees.getNodeText(tree, list), false);
        if (tree.getChildCount() == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        string = Utils.escapeWhitespace(Trees.getNodeText(tree, list), false);
        stringBuilder.append(string);
        stringBuilder.append(' ');
        for (int i2 = 0; i2 < tree.getChildCount(); ++i2) {
            if (i2 > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(Trees.toStringTree(tree.getChild(i2), list));
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static String getNodeText(Tree tree, Parser object) {
        object = object != null ? object.getRuleNames() : null;
        object = object != null ? Arrays.asList(object) : null;
        return Trees.getNodeText(tree, (List<String>)object);
    }

    public static String getNodeText(Tree tree, List<String> object) {
        Object object2;
        if (object != null) {
            if (tree instanceof RuleContext) {
                int n2 = ((RuleContext)tree).getRuleContext().getRuleIndex();
                object = object.get(n2);
                int n3 = ((RuleContext)tree).getAltNumber();
                if (n3 != 0) {
                    return (String)object + ":" + n3;
                }
                return object;
            }
            if (tree instanceof ErrorNode) {
                return tree.toString();
            }
            if (tree instanceof TerminalNode && (object2 = ((TerminalNode)tree).getSymbol()) != null) {
                object = object2.getText();
                return object;
            }
        }
        if ((object2 = tree.getPayload()) instanceof Token) {
            return ((Token)object2).getText();
        }
        return tree.getPayload().toString();
    }

    public static List<Tree> getChildren(Tree tree) {
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        for (int i2 = 0; i2 < tree.getChildCount(); ++i2) {
            arrayList.add(tree.getChild(i2));
        }
        return arrayList;
    }

    public static List<? extends Tree> getAncestors(Tree tree) {
        if (tree.getParent() == null) {
            return Collections.emptyList();
        }
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        for (tree = tree.getParent(); tree != null; tree = tree.getParent()) {
            arrayList.add(0, tree);
        }
        return arrayList;
    }

    public static boolean isAncestorOf(Tree tree, Tree tree2) {
        if (tree == null || tree2 == null || tree.getParent() == null) {
            return false;
        }
        for (tree2 = tree2.getParent(); tree2 != null; tree2 = tree2.getParent()) {
            if (tree != tree2) continue;
            return true;
        }
        return false;
    }

    public static Collection<ParseTree> findAllTokenNodes(ParseTree parseTree, int n2) {
        return Trees.findAllNodes(parseTree, n2, true);
    }

    public static Collection<ParseTree> findAllRuleNodes(ParseTree parseTree, int n2) {
        return Trees.findAllNodes(parseTree, n2, false);
    }

    public static List<ParseTree> findAllNodes(ParseTree parseTree, int n2, boolean bl2) {
        ArrayList<ParseTree> arrayList = new ArrayList<ParseTree>();
        Trees._findAllNodes(parseTree, n2, bl2, arrayList);
        return arrayList;
    }

    public static void _findAllNodes(ParseTree parseTree, int n2, boolean bl2, List<? super ParseTree> list) {
        ParseTree parseTree2;
        if (bl2 && parseTree instanceof TerminalNode) {
            parseTree2 = (TerminalNode)parseTree;
            if (parseTree2.getSymbol().getType() == n2) {
                list.add(parseTree);
            }
        } else if (!bl2 && parseTree instanceof ParserRuleContext && ((RuleContext)(parseTree2 = (ParserRuleContext)parseTree)).getRuleIndex() == n2) {
            list.add(parseTree);
        }
        for (int i2 = 0; i2 < parseTree.getChildCount(); ++i2) {
            Trees._findAllNodes(parseTree.getChild(i2), n2, bl2, list);
        }
    }

    public static List<ParseTree> getDescendants(ParseTree parseTree) {
        ArrayList<ParseTree> arrayList = new ArrayList<ParseTree>();
        arrayList.add(parseTree);
        int n2 = parseTree.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.addAll(Trees.getDescendants(parseTree.getChild(i2)));
        }
        return arrayList;
    }

    public static List<ParseTree> descendants(ParseTree parseTree) {
        return Trees.getDescendants(parseTree);
    }

    public static ParserRuleContext getRootOfSubtreeEnclosingRegion(ParseTree parseTree, int n2, int n3) {
        ParserRuleContext parserRuleContext;
        int n4 = parseTree.getChildCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            ParseTree parseTree2 = parseTree.getChild(i2);
            if ((parseTree2 = Trees.getRootOfSubtreeEnclosingRegion(parseTree2, n2, n3)) == null) continue;
            return parseTree2;
        }
        if (parseTree instanceof ParserRuleContext && n2 >= (parserRuleContext = (ParserRuleContext)parseTree).getStart().getTokenIndex() && (parserRuleContext.getStop() == null || n3 <= parserRuleContext.getStop().getTokenIndex())) {
            return parserRuleContext;
        }
        return null;
    }

    public static void stripChildrenOutOfRange(ParserRuleContext parserRuleContext, ParserRuleContext parserRuleContext2, int n2, int n3) {
        if (parserRuleContext == null) {
            return;
        }
        for (int i2 = 0; i2 < ((RuleContext)parserRuleContext).getChildCount(); ++i2) {
            Object object = ((RuleContext)parserRuleContext).getChild(i2);
            Interval interval = object.getSourceInterval();
            if (!(object instanceof ParserRuleContext) || interval.b >= n2 && interval.a <= n3 || !Trees.isAncestorOf((Tree)object, parserRuleContext2)) continue;
            object = new CommonToken(0, "...");
            parserRuleContext.children.set(i2, new TerminalNodeImpl((Token)object));
        }
    }

    public static Tree findNodeSuchThat(Tree tree, Predicate<Tree> predicate) {
        if (predicate.test(tree)) {
            return tree;
        }
        if (tree == null) {
            return null;
        }
        int n2 = tree.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Tree tree2 = Trees.findNodeSuchThat(tree.getChild(i2), predicate);
            if (tree2 == null) continue;
            return tree2;
        }
        return null;
    }

    private Trees() {
    }
}

