/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal.antlr.tree.xpath;

import com.github.jknack.handlebars.internal.antlr.ANTLRInputStream;
import com.github.jknack.handlebars.internal.antlr.BufferedTokenStream;
import com.github.jknack.handlebars.internal.antlr.CommonTokenStream;
import com.github.jknack.handlebars.internal.antlr.Lexer;
import com.github.jknack.handlebars.internal.antlr.LexerNoViableAltException;
import com.github.jknack.handlebars.internal.antlr.Parser;
import com.github.jknack.handlebars.internal.antlr.ParserRuleContext;
import com.github.jknack.handlebars.internal.antlr.Recognizer;
import com.github.jknack.handlebars.internal.antlr.Token;
import com.github.jknack.handlebars.internal.antlr.TokenSource;
import com.github.jknack.handlebars.internal.antlr.tree.ParseTree;
import com.github.jknack.handlebars.internal.antlr.tree.xpath.XPathElement;
import com.github.jknack.handlebars.internal.antlr.tree.xpath.XPathLexer;
import com.github.jknack.handlebars.internal.antlr.tree.xpath.XPathLexerErrorListener;
import com.github.jknack.handlebars.internal.antlr.tree.xpath.XPathRuleAnywhereElement;
import com.github.jknack.handlebars.internal.antlr.tree.xpath.XPathRuleElement;
import com.github.jknack.handlebars.internal.antlr.tree.xpath.XPathTokenAnywhereElement;
import com.github.jknack.handlebars.internal.antlr.tree.xpath.XPathTokenElement;
import com.github.jknack.handlebars.internal.antlr.tree.xpath.XPathWildcardAnywhereElement;
import com.github.jknack.handlebars.internal.antlr.tree.xpath.XPathWildcardElement;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;

public class XPath {
    public static final String WILDCARD = "*";
    public static final String NOT = "!";
    protected String path;
    protected XPathElement[] elements;
    protected Parser parser;

    public XPath(Parser parser, String string) {
        this.parser = parser;
        this.path = string;
        this.elements = this.split(string);
    }

    public XPathElement[] split(String string) {
        ArrayList<Object> arrayList;
        try {
            arrayList = new ANTLRInputStream(new StringReader(string));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Could not read path: " + string, iOException);
        }
        arrayList = new XPathLexer(this, (ANTLRInputStream)((Object)arrayList)){
            private /* synthetic */ XPath a;
            {
                this.a = xPath;
                super(aNTLRInputStream);
            }

            @Override
            public final void recover(LexerNoViableAltException lexerNoViableAltException) {
                throw lexerNoViableAltException;
            }
        };
        ((Recognizer)((Object)arrayList)).removeErrorListeners();
        ((Recognizer)((Object)arrayList)).addErrorListener(new XPathLexerErrorListener());
        Object object = new CommonTokenStream((TokenSource)((Object)arrayList));
        try {
            ((BufferedTokenStream)object).fill();
        }
        catch (LexerNoViableAltException lexerNoViableAltException) {
            int n2 = ((Lexer)((Object)arrayList)).getCharPositionInLine();
            string = "Invalid tokens or characters at index " + n2 + " in path '" + string + "'";
            throw new IllegalArgumentException(string, lexerNoViableAltException);
        }
        object = ((BufferedTokenStream)object).getTokens();
        arrayList = new ArrayList<Object>();
        int n3 = object.size();
        int n4 = 0;
        block9: while (n4 < n3) {
            Object object2 = (Token)object.get(n4);
            switch (object2.getType()) {
                case 3: 
                case 4: {
                    boolean bl2 = object2.getType() == 3;
                    object2 = (Token)object.get(++n4);
                    boolean bl3 = object2.getType() == 6;
                    if (bl3) {
                        object2 = (Token)object.get(++n4);
                    }
                    object2 = this.getXPathElement((Token)object2, bl2);
                    v0.invert = bl3;
                    arrayList.add(object2);
                    ++n4;
                    continue block9;
                }
                case 1: 
                case 2: 
                case 5: {
                    arrayList.add(this.getXPathElement((Token)object2, false));
                    ++n4;
                    continue block9;
                }
                case -1: {
                    break block9;
                }
                default: {
                    throw new IllegalArgumentException("Unknowth path element " + object2);
                }
            }
        }
        return arrayList.toArray(new XPathElement[0]);
    }

    protected XPathElement getXPathElement(Token token, boolean bl2) {
        if (token.getType() == -1) {
            throw new IllegalArgumentException("Missing path element at end of path");
        }
        String string = token.getText();
        int n2 = this.parser.getTokenType(string);
        int n3 = this.parser.getRuleIndex(string);
        switch (token.getType()) {
            case 5: {
                if (bl2) {
                    return new XPathWildcardAnywhereElement();
                }
                return new XPathWildcardElement();
            }
            case 1: 
            case 8: {
                if (n2 == 0) {
                    throw new IllegalArgumentException(string + " at index " + token.getStartIndex() + " isn't a valid token name");
                }
                if (bl2) {
                    return new XPathTokenAnywhereElement(string, n2);
                }
                return new XPathTokenElement(string, n2);
            }
        }
        if (n3 == -1) {
            throw new IllegalArgumentException(string + " at index " + token.getStartIndex() + " isn't a valid rule name");
        }
        if (bl2) {
            return new XPathRuleAnywhereElement(string, n3);
        }
        return new XPathRuleElement(string, n3);
    }

    public static Collection<ParseTree> findAll(ParseTree parseTree, String object, Parser parser) {
        object = new XPath(parser, (String)object);
        return ((XPath)object).evaluate(parseTree);
    }

    public Collection<ParseTree> evaluate(ParseTree object) {
        ParserRuleContext parserRuleContext = new ParserRuleContext();
        new ParserRuleContext().children = Collections.singletonList(object);
        object = Collections.singleton(parserRuleContext);
        for (int i2 = 0; i2 < this.elements.length; ++i2) {
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (ParseTree)object.next();
                if (object2.getChildCount() <= 0) continue;
                object2 = this.elements[i2].evaluate((ParseTree)object2);
                linkedHashSet.addAll(object2);
            }
            object = linkedHashSet;
        }
        return object;
    }
}

