/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal.lang3;

import com.github.jknack.handlebars.internal.lang3.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LocaleUtils {
    private static final ConcurrentMap<String, List<Locale>> a = new ConcurrentHashMap<String, List<Locale>>();
    private static final ConcurrentMap<String, List<Locale>> b = new ConcurrentHashMap<String, List<Locale>>();

    public static List<Locale> availableLocaleList() {
        return com.github.jknack.handlebars.internal.lang3.LocaleUtils$a.a;
    }

    public static Set<Locale> availableLocaleSet() {
        return com.github.jknack.handlebars.internal.lang3.LocaleUtils$a.b;
    }

    public static List<Locale> countriesByLanguage(String string) {
        if (string == null) {
            return Collections.emptyList();
        }
        List<Locale> list = (ArrayList)b.get(string);
        if (list == null) {
            list = new ArrayList();
            Object object = LocaleUtils.availableLocaleList();
            object = object.iterator();
            while (object.hasNext()) {
                Locale locale = (Locale)object.next();
                if (!string.equals(locale.getLanguage()) || locale.getCountry().isEmpty() || !locale.getVariant().isEmpty()) continue;
                list.add(locale);
            }
            list = Collections.unmodifiableList(list);
            b.putIfAbsent(string, list);
            list = (List)b.get(string);
        }
        return list;
    }

    public static boolean isAvailableLocale(Locale locale) {
        return LocaleUtils.availableLocaleList().contains(locale);
    }

    private static boolean a(String string) {
        return StringUtils.isAllUpperCase(string) && string.length() == 2;
    }

    private static boolean b(String string) {
        return StringUtils.isAllLowerCase(string) && (string.length() == 2 || string.length() == 3);
    }

    private static boolean c(String string) {
        return StringUtils.isNumeric(string) && string.length() == 3;
    }

    public static List<Locale> languagesByCountry(String string) {
        if (string == null) {
            return Collections.emptyList();
        }
        List<Locale> list = (ArrayList)a.get(string);
        if (list == null) {
            list = new ArrayList();
            Object object = LocaleUtils.availableLocaleList();
            object = object.iterator();
            while (object.hasNext()) {
                Locale locale = (Locale)object.next();
                if (!string.equals(locale.getCountry()) || !locale.getVariant().isEmpty()) continue;
                list.add(locale);
            }
            list = Collections.unmodifiableList(list);
            a.putIfAbsent(string, list);
            list = (List)a.get(string);
        }
        return list;
    }

    public static List<Locale> localeLookupList(Locale locale) {
        Locale locale2 = locale;
        return LocaleUtils.localeLookupList(locale2, locale2);
    }

    public static List<Locale> localeLookupList(Locale locale, Locale locale2) {
        ArrayList<Locale> arrayList = new ArrayList<Locale>(4);
        if (locale != null) {
            arrayList.add(locale);
            if (!locale.getVariant().isEmpty()) {
                arrayList.add(new Locale(locale.getLanguage(), locale.getCountry()));
            }
            if (!locale.getCountry().isEmpty()) {
                arrayList.add(new Locale(locale.getLanguage(), ""));
            }
            if (!arrayList.contains(locale2)) {
                arrayList.add(locale2);
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static Locale toLocale(Locale locale) {
        if (locale != null) {
            return locale;
        }
        return Locale.getDefault();
    }

    public static Locale toLocale(String string) {
        if (string == null) {
            return null;
        }
        if (string.isEmpty()) {
            return new Locale("", "");
        }
        if (string.contains("#")) {
            throw new IllegalArgumentException("Invalid locale format: " + string);
        }
        int n2 = string.length();
        if (n2 < 2) {
            throw new IllegalArgumentException("Invalid locale format: " + string);
        }
        char c2 = string.charAt(0);
        if (c2 == '_') {
            if (n2 < 3) {
                throw new IllegalArgumentException("Invalid locale format: " + string);
            }
            c2 = string.charAt(1);
            char c3 = string.charAt(2);
            if (!Character.isUpperCase(c2) || !Character.isUpperCase(c3)) {
                throw new IllegalArgumentException("Invalid locale format: " + string);
            }
            if (n2 == 3) {
                return new Locale("", string.substring(1, 3));
            }
            if (n2 < 5) {
                throw new IllegalArgumentException("Invalid locale format: " + string);
            }
            if (string.charAt(3) != '_') {
                throw new IllegalArgumentException("Invalid locale format: " + string);
            }
            return new Locale("", string.substring(1, 3), string.substring(4));
        }
        if (LocaleUtils.b(string)) {
            return new Locale(string);
        }
        Object object = string.split("_", -1);
        String string2 = object[0];
        if (((String[])object).length == 2) {
            String string3 = object[1];
            if (LocaleUtils.b(string2) && LocaleUtils.a(string3) || LocaleUtils.c(string3)) {
                return new Locale(string2, string3);
            }
        } else if (((String[])object).length == 3) {
            String string4 = object[1];
            object = object[2];
            if (LocaleUtils.b(string2) && (string4.isEmpty() || LocaleUtils.a(string4) || LocaleUtils.c(string4)) && !((String)object).isEmpty()) {
                return new Locale(string2, string4, (String)object);
            }
        }
        throw new IllegalArgumentException("Invalid locale format: " + string);
    }

    static final class a {
        private static final List<Locale> a;
        private static final Set<Locale> b;

        static {
            ArrayList<Locale> arrayList = new ArrayList<Locale>(Arrays.asList(Locale.getAvailableLocales()));
            a = Collections.unmodifiableList(arrayList);
            b = Collections.unmodifiableSet(new HashSet<Locale>(arrayList));
        }
    }
}

