/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal.lang3.time;

import com.github.jknack.handlebars.internal.lang3.ObjectUtils;
import com.github.jknack.handlebars.internal.lang3.Range;
import com.github.jknack.handlebars.internal.lang3.function.FailableBiConsumer;
import com.github.jknack.handlebars.internal.lang3.math.NumberUtils;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class DurationUtils {
    private static Range<Long> a = Range.between(NumberUtils.LONG_INT_MIN_VALUE, NumberUtils.LONG_INT_MAX_VALUE);

    public static <T extends Throwable> void accept(FailableBiConsumer<Long, Integer, T> failableBiConsumer, Duration duration) {
        if (failableBiConsumer != null && duration != null) {
            failableBiConsumer.accept(duration.toMillis(), DurationUtils.getNanosOfMiili(duration));
        }
    }

    public static int getNanosOfMiili(Duration duration) {
        return duration.getNano() % 1000000;
    }

    public static boolean isPositive(Duration duration) {
        return !duration.isNegative() && !duration.isZero();
    }

    public static Duration toDuration(long l2, TimeUnit timeUnit) {
        ChronoUnit chronoUnit;
        TimeUnit timeUnit2 = timeUnit;
        switch (Objects.requireNonNull(timeUnit2)) {
            case NANOSECONDS: {
                chronoUnit = ChronoUnit.NANOS;
                break;
            }
            case MICROSECONDS: {
                chronoUnit = ChronoUnit.MICROS;
                break;
            }
            case MILLISECONDS: {
                chronoUnit = ChronoUnit.MILLIS;
                break;
            }
            case SECONDS: {
                chronoUnit = ChronoUnit.SECONDS;
                break;
            }
            case MINUTES: {
                chronoUnit = ChronoUnit.MINUTES;
                break;
            }
            case HOURS: {
                chronoUnit = ChronoUnit.HOURS;
                break;
            }
            case DAYS: {
                chronoUnit = ChronoUnit.DAYS;
                break;
            }
            default: {
                throw new IllegalArgumentException(timeUnit2.toString());
            }
        }
        return Duration.of(l2, chronoUnit);
    }

    public static int toMillisInt(Duration duration) {
        Objects.requireNonNull(duration, "duration");
        return a.fit(duration.toMillis()).intValue();
    }

    public static Duration zeroIfNull(Duration duration) {
        return ObjectUtils.defaultIfNull(duration, Duration.ZERO);
    }
}

