/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal.lang3.tuple;

import com.github.jknack.handlebars.internal.lang3.tuple.Pair;
import java.util.Map;

public final class ImmutablePair<L, R>
extends Pair<L, R> {
    public static final ImmutablePair<?, ?>[] EMPTY_ARRAY = new ImmutablePair[0];
    private static final ImmutablePair a = ImmutablePair.of(null, null);
    public final L left;
    public final R right;

    public static <L, R> ImmutablePair<L, R>[] emptyArray() {
        return EMPTY_ARRAY;
    }

    public static <L, R> Pair<L, R> left(L l2) {
        return ImmutablePair.of(l2, null);
    }

    public static <L, R> ImmutablePair<L, R> nullPair() {
        return a;
    }

    public static <L, R> ImmutablePair<L, R> of(L l2, R r2) {
        return new ImmutablePair<L, R>(l2, r2);
    }

    public static <L, R> ImmutablePair<L, R> of(Map.Entry<L, R> entry) {
        L l2;
        if (entry != null) {
            l2 = entry.getKey();
            entry = entry.getValue();
        } else {
            l2 = null;
            entry = null;
        }
        return new ImmutablePair<Object, Map.Entry<L, R>>(l2, entry);
    }

    public static <L, R> Pair<L, R> right(R r2) {
        return ImmutablePair.of(null, r2);
    }

    public ImmutablePair(L l2, R r2) {
        this.left = l2;
        this.right = r2;
    }

    @Override
    public final L getLeft() {
        return this.left;
    }

    @Override
    public final R getRight() {
        return this.right;
    }

    @Override
    public final R setValue(R r2) {
        throw new UnsupportedOperationException();
    }
}

