/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal.text;

import com.github.jknack.handlebars.internal.lang3.ArrayUtils;
import com.github.jknack.handlebars.internal.lang3.StringUtils;
import com.github.jknack.handlebars.internal.text.Builder;
import com.github.jknack.handlebars.internal.text.StringTokenizer;
import com.github.jknack.handlebars.internal.text.matcher.StringMatcher;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class TextStringBuilder
implements Builder<String>,
Serializable,
Appendable,
CharSequence {
    private static final int a = Boolean.FALSE.toString().length();
    private static final int b = Boolean.TRUE.toString().length();
    private char[] c;
    private String d;
    private String e;
    private int f;
    private int g;

    public static TextStringBuilder wrap(char[] cArray) {
        Objects.requireNonNull(cArray, "initialBuffer");
        return new TextStringBuilder(cArray, cArray.length);
    }

    public static TextStringBuilder wrap(char[] cArray, int n2) {
        return new TextStringBuilder(cArray, n2);
    }

    public TextStringBuilder() {
        this(32);
    }

    private TextStringBuilder(char[] cArray, int n2) {
        this.c = Objects.requireNonNull(cArray, "initialBuffer");
        if (n2 < 0 || n2 > cArray.length) {
            throw new IllegalArgumentException("initialBuffer.length=" + cArray.length + ", length=" + n2);
        }
        this.g = n2;
    }

    public TextStringBuilder(CharSequence charSequence) {
        this(StringUtils.length(charSequence) + 32);
        if (charSequence != null) {
            this.append(charSequence);
        }
    }

    public TextStringBuilder(int n2) {
        this.c = new char[n2 <= 0 ? 32 : n2];
    }

    public TextStringBuilder(String string) {
        this(StringUtils.length(string) + 32);
        if (string != null) {
            this.append(string);
        }
    }

    public TextStringBuilder append(boolean bl2) {
        if (bl2) {
            TextStringBuilder textStringBuilder = this;
            textStringBuilder.ensureCapacity(textStringBuilder.g + b);
            TextStringBuilder textStringBuilder2 = this;
            textStringBuilder2.b(textStringBuilder2.g);
        } else {
            TextStringBuilder textStringBuilder = this;
            textStringBuilder.ensureCapacity(textStringBuilder.g + a);
            TextStringBuilder textStringBuilder3 = this;
            textStringBuilder3.a(textStringBuilder3.g);
        }
        return this;
    }

    @Override
    public TextStringBuilder append(char c2) {
        int n2 = this.length();
        this.ensureCapacity(n2 + 1);
        this.c[this.g++] = c2;
        return this;
    }

    public TextStringBuilder append(char[] cArray) {
        if (cArray == null) {
            return this.appendNull();
        }
        int n2 = cArray.length;
        if (n2 > 0) {
            int n3 = this.length();
            this.ensureCapacity(n3 + n2);
            System.arraycopy(cArray, 0, this.c, n3, n2);
            this.g += n2;
        }
        return this;
    }

    public TextStringBuilder append(char[] cArray, int n2, int n3) {
        if (cArray == null) {
            return this.appendNull();
        }
        if (n2 < 0 || n2 > cArray.length) {
            throw new StringIndexOutOfBoundsException("Invalid startIndex: " + n3);
        }
        if (n3 < 0 || n2 + n3 > cArray.length) {
            throw new StringIndexOutOfBoundsException("Invalid length: " + n3);
        }
        if (n3 > 0) {
            int n4 = this.length();
            this.ensureCapacity(n4 + n3);
            System.arraycopy(cArray, n2, this.c, n4, n3);
            this.g += n3;
        }
        return this;
    }

    public TextStringBuilder append(CharBuffer charBuffer) {
        return this.append(charBuffer, 0, StringUtils.length(charBuffer));
    }

    public TextStringBuilder append(CharBuffer charBuffer, int n2, int n3) {
        if (charBuffer == null) {
            return this.appendNull();
        }
        if (charBuffer.hasArray()) {
            int n4 = charBuffer.remaining();
            if (n2 < 0 || n2 > n4) {
                throw new StringIndexOutOfBoundsException("startIndex must be valid");
            }
            if (n3 < 0 || n2 + n3 > n4) {
                throw new StringIndexOutOfBoundsException("length must be valid");
            }
            n4 = this.length();
            this.ensureCapacity(n4 + n3);
            System.arraycopy(charBuffer.array(), charBuffer.arrayOffset() + charBuffer.position() + n2, this.c, n4, n3);
            this.g += n3;
        } else {
            this.append(charBuffer.toString(), n2, n3);
        }
        return this;
    }

    @Override
    public TextStringBuilder append(CharSequence charSequence) {
        if (charSequence == null) {
            return this.appendNull();
        }
        if (charSequence instanceof TextStringBuilder) {
            return this.append((TextStringBuilder)charSequence);
        }
        if (charSequence instanceof StringBuilder) {
            return this.append((StringBuilder)charSequence);
        }
        if (charSequence instanceof StringBuffer) {
            return this.append((StringBuffer)charSequence);
        }
        if (charSequence instanceof CharBuffer) {
            return this.append((CharBuffer)charSequence);
        }
        return this.append(charSequence.toString());
    }

    @Override
    public TextStringBuilder append(CharSequence charSequence, int n2, int n3) {
        if (charSequence == null) {
            return this.appendNull();
        }
        if (n3 <= 0) {
            throw new StringIndexOutOfBoundsException("endIndex must be valid");
        }
        if (n2 >= n3) {
            throw new StringIndexOutOfBoundsException("endIndex must be greater than startIndex");
        }
        return this.append(charSequence.toString(), n2, n3 - n2);
    }

    public TextStringBuilder append(double d2) {
        return this.append(String.valueOf(d2));
    }

    public TextStringBuilder append(float f2) {
        return this.append(String.valueOf(f2));
    }

    public TextStringBuilder append(int n2) {
        return this.append(String.valueOf(n2));
    }

    public TextStringBuilder append(long l2) {
        return this.append(String.valueOf(l2));
    }

    public TextStringBuilder append(Object object) {
        if (object == null) {
            return this.appendNull();
        }
        if (object instanceof CharSequence) {
            return this.append((CharSequence)object);
        }
        return this.append(object.toString());
    }

    public TextStringBuilder append(String string) {
        return this.append(string, 0, StringUtils.length(string));
    }

    public TextStringBuilder append(String string, int n2, int n3) {
        if (string == null) {
            return this.appendNull();
        }
        if (n2 < 0 || n2 > string.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (n3 < 0 || n2 + n3 > string.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (n3 > 0) {
            int n4 = this.length();
            this.ensureCapacity(n4 + n3);
            int n5 = n2;
            string.getChars(n5, n5 + n3, this.c, n4);
            this.g += n3;
        }
        return this;
    }

    public TextStringBuilder append(String string, Object ... objectArray) {
        return this.append(String.format(string, objectArray));
    }

    public TextStringBuilder append(StringBuffer stringBuffer) {
        return this.append(stringBuffer, 0, StringUtils.length(stringBuffer));
    }

    public TextStringBuilder append(StringBuffer stringBuffer, int n2, int n3) {
        if (stringBuffer == null) {
            return this.appendNull();
        }
        if (n2 < 0 || n2 > stringBuffer.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (n3 < 0 || n2 + n3 > stringBuffer.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (n3 > 0) {
            int n4 = this.length();
            this.ensureCapacity(n4 + n3);
            int n5 = n2;
            stringBuffer.getChars(n5, n5 + n3, this.c, n4);
            this.g += n3;
        }
        return this;
    }

    public TextStringBuilder append(StringBuilder stringBuilder) {
        return this.append(stringBuilder, 0, StringUtils.length(stringBuilder));
    }

    public TextStringBuilder append(StringBuilder stringBuilder, int n2, int n3) {
        if (stringBuilder == null) {
            return this.appendNull();
        }
        if (n2 < 0 || n2 > stringBuilder.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (n3 < 0 || n2 + n3 > stringBuilder.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (n3 > 0) {
            int n4 = this.length();
            this.ensureCapacity(n4 + n3);
            int n5 = n2;
            stringBuilder.getChars(n5, n5 + n3, this.c, n4);
            this.g += n3;
        }
        return this;
    }

    public TextStringBuilder append(TextStringBuilder textStringBuilder) {
        return this.append(textStringBuilder, 0, StringUtils.length(textStringBuilder));
    }

    public TextStringBuilder append(TextStringBuilder textStringBuilder, int n2, int n3) {
        if (textStringBuilder == null) {
            return this.appendNull();
        }
        if (n2 < 0 || n2 > textStringBuilder.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (n3 < 0 || n2 + n3 > textStringBuilder.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (n3 > 0) {
            int n4 = this.length();
            this.ensureCapacity(n4 + n3);
            int n5 = n2;
            textStringBuilder.getChars(n5, n5 + n3, this.c, n4);
            this.g += n3;
        }
        return this;
    }

    public TextStringBuilder appendAll(Iterable<?> iterable) {
        if (iterable != null) {
            iterable.forEach(this::append);
        }
        return this;
    }

    public TextStringBuilder appendAll(Iterator<?> iterator) {
        if (iterator != null) {
            iterator.forEachRemaining(this::append);
        }
        return this;
    }

    public <T> TextStringBuilder appendAll(T ... TArray) {
        if (TArray != null && TArray.length > 0) {
            for (T t2 : TArray) {
                this.append(t2);
            }
        }
        return this;
    }

    private void a(int n2) {
        this.c[n2++] = 102;
        this.c[n2++] = 97;
        this.c[n2++] = 108;
        this.c[n2++] = 115;
        this.c[n2] = 101;
        this.g += a;
    }

    public TextStringBuilder appendFixedWidthPadLeft(int n2, int n3, char c2) {
        return this.appendFixedWidthPadLeft(String.valueOf(n2), n3, c2);
    }

    public TextStringBuilder appendFixedWidthPadLeft(Object object, int n2, char c2) {
        if (n2 > 0) {
            int n3;
            TextStringBuilder textStringBuilder = this;
            textStringBuilder.ensureCapacity(textStringBuilder.g + n2);
            if ((object = object == null ? this.getNullText() : object.toString()) == null) {
                object = "";
            }
            if ((n3 = ((String)object).length()) >= n2) {
                ((String)object).getChars(n3 - n2, n3, this.c, this.g);
            } else {
                int n4 = n2 - n3;
                for (int i2 = 0; i2 < n4; ++i2) {
                    this.c[this.g + i2] = c2;
                }
                ((String)object).getChars(0, n3, this.c, this.g + n4);
            }
            this.g += n2;
        }
        return this;
    }

    public TextStringBuilder appendFixedWidthPadRight(int n2, int n3, char c2) {
        return this.appendFixedWidthPadRight(String.valueOf(n2), n3, c2);
    }

    public TextStringBuilder appendFixedWidthPadRight(Object object, int n2, char c2) {
        if (n2 > 0) {
            int n3;
            TextStringBuilder textStringBuilder = this;
            textStringBuilder.ensureCapacity(textStringBuilder.g + n2);
            if ((object = object == null ? this.getNullText() : object.toString()) == null) {
                object = "";
            }
            if ((n3 = ((String)object).length()) >= n2) {
                ((String)object).getChars(0, n2, this.c, this.g);
            } else {
                int n4 = n2 - n3;
                ((String)object).getChars(0, n3, this.c, this.g);
                for (int i2 = 0; i2 < n4; ++i2) {
                    this.c[this.g + n3 + i2] = c2;
                }
            }
            this.g += n2;
        }
        return this;
    }

    public TextStringBuilder appendln(boolean bl2) {
        return this.append(bl2).appendNewLine();
    }

    public TextStringBuilder appendln(char c2) {
        return this.append(c2).appendNewLine();
    }

    public TextStringBuilder appendln(char[] cArray) {
        return this.append(cArray).appendNewLine();
    }

    public TextStringBuilder appendln(char[] cArray, int n2, int n3) {
        return this.append(cArray, n2, n3).appendNewLine();
    }

    public TextStringBuilder appendln(double d2) {
        return this.append(d2).appendNewLine();
    }

    public TextStringBuilder appendln(float f2) {
        return this.append(f2).appendNewLine();
    }

    public TextStringBuilder appendln(int n2) {
        return this.append(n2).appendNewLine();
    }

    public TextStringBuilder appendln(long l2) {
        return this.append(l2).appendNewLine();
    }

    public TextStringBuilder appendln(Object object) {
        return this.append(object).appendNewLine();
    }

    public TextStringBuilder appendln(String string) {
        return this.append(string).appendNewLine();
    }

    public TextStringBuilder appendln(String string, int n2, int n3) {
        return this.append(string, n2, n3).appendNewLine();
    }

    public TextStringBuilder appendln(String string, Object ... objectArray) {
        return this.append(string, objectArray).appendNewLine();
    }

    public TextStringBuilder appendln(StringBuffer stringBuffer) {
        return this.append(stringBuffer).appendNewLine();
    }

    public TextStringBuilder appendln(StringBuffer stringBuffer, int n2, int n3) {
        return this.append(stringBuffer, n2, n3).appendNewLine();
    }

    public TextStringBuilder appendln(StringBuilder stringBuilder) {
        return this.append(stringBuilder).appendNewLine();
    }

    public TextStringBuilder appendln(StringBuilder stringBuilder, int n2, int n3) {
        return this.append(stringBuilder, n2, n3).appendNewLine();
    }

    public TextStringBuilder appendln(TextStringBuilder textStringBuilder) {
        return this.append(textStringBuilder).appendNewLine();
    }

    public TextStringBuilder appendln(TextStringBuilder textStringBuilder, int n2, int n3) {
        return this.append(textStringBuilder, n2, n3).appendNewLine();
    }

    public TextStringBuilder appendNewLine() {
        if (this.d == null) {
            this.append(System.lineSeparator());
            return this;
        }
        TextStringBuilder textStringBuilder = this;
        return textStringBuilder.append(textStringBuilder.d);
    }

    public TextStringBuilder appendNull() {
        if (this.e == null) {
            return this;
        }
        TextStringBuilder textStringBuilder = this;
        return textStringBuilder.append(textStringBuilder.e);
    }

    public TextStringBuilder appendPadding(int n2, char c2) {
        if (n2 >= 0) {
            TextStringBuilder textStringBuilder = this;
            textStringBuilder.ensureCapacity(textStringBuilder.g + n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.c[this.g++] = c2;
            }
        }
        return this;
    }

    public TextStringBuilder appendSeparator(char c2) {
        if (this.isNotEmpty()) {
            this.append(c2);
        }
        return this;
    }

    public TextStringBuilder appendSeparator(char c2, char c3) {
        if (this.isEmpty()) {
            this.append(c3);
        } else {
            this.append(c2);
        }
        return this;
    }

    public TextStringBuilder appendSeparator(char c2, int n2) {
        if (n2 > 0) {
            this.append(c2);
        }
        return this;
    }

    public TextStringBuilder appendSeparator(String string) {
        return this.appendSeparator(string, null);
    }

    public TextStringBuilder appendSeparator(String string, int n2) {
        if (string != null && n2 > 0) {
            this.append(string);
        }
        return this;
    }

    public TextStringBuilder appendSeparator(String string, String string2) {
        string = this.isEmpty() ? string2 : string;
        if (string != null) {
            this.append(string);
        }
        return this;
    }

    public void appendTo(Appendable appendable) {
        if (appendable instanceof Writer) {
            ((Writer)appendable).write(this.c, 0, this.g);
            return;
        }
        if (appendable instanceof StringBuilder) {
            ((StringBuilder)appendable).append(this.c, 0, this.g);
            return;
        }
        if (appendable instanceof StringBuffer) {
            ((StringBuffer)appendable).append(this.c, 0, this.g);
            return;
        }
        if (appendable instanceof CharBuffer) {
            ((CharBuffer)appendable).put(this.c, 0, this.g);
            return;
        }
        appendable.append(this);
    }

    private void b(int n2) {
        this.c[n2++] = 116;
        this.c[n2++] = 114;
        this.c[n2++] = 117;
        this.c[n2] = 101;
        this.g += b;
    }

    public TextStringBuilder appendWithSeparators(Iterable<?> iterable, String string) {
        if (iterable != null) {
            this.appendWithSeparators(iterable.iterator(), string);
        }
        return this;
    }

    public TextStringBuilder appendWithSeparators(Iterator<?> iterator, String string) {
        if (iterator != null) {
            string = Objects.toString(string, "");
            while (iterator.hasNext()) {
                this.append(iterator.next());
                if (!iterator.hasNext()) continue;
                this.append(string);
            }
        }
        return this;
    }

    public TextStringBuilder appendWithSeparators(Object[] objectArray, String string) {
        if (objectArray != null && objectArray.length > 0) {
            string = Objects.toString(string, "");
            this.append(objectArray[0]);
            for (int i2 = 1; i2 < objectArray.length; ++i2) {
                this.append(string);
                this.append(objectArray[i2]);
            }
        }
        return this;
    }

    public Reader asReader() {
        return new a(this);
    }

    public StringTokenizer asTokenizer() {
        return new b(this);
    }

    public Writer asWriter() {
        return new c(this);
    }

    @Override
    public String build() {
        return this.toString();
    }

    public int capacity() {
        return this.c.length;
    }

    @Override
    public char charAt(int n2) {
        this.validateIndex(n2);
        return this.c[n2];
    }

    public TextStringBuilder clear() {
        this.g = 0;
        return this;
    }

    public boolean contains(char c2) {
        char[] cArray = this.c;
        for (int i2 = 0; i2 < this.g; ++i2) {
            if (cArray[i2] != c2) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String string) {
        return this.indexOf(string, 0) >= 0;
    }

    public boolean contains(StringMatcher stringMatcher) {
        return this.indexOf(stringMatcher, 0) >= 0;
    }

    public TextStringBuilder delete(int n2, int n3) {
        int n4 = (n3 = this.validateRange(n2, n3)) - n2;
        if (n4 > 0) {
            this.a(n2, n3, n4);
        }
        return this;
    }

    public TextStringBuilder deleteAll(char c2) {
        for (int i2 = 0; i2 < this.g; ++i2) {
            if (this.c[i2] != c2) continue;
            int n2 = i2;
            while (++i2 < this.g && this.c[i2] == c2) {
            }
            int n3 = i2 - n2;
            this.a(n2, i2, n3);
            i2 -= n3;
        }
        return this;
    }

    public TextStringBuilder deleteAll(String string) {
        int n2 = string == null ? 0 : string.length();
        if (n2 > 0) {
            int n3 = this.indexOf(string, 0);
            while (n3 >= 0) {
                int n4 = n3;
                this.a(n4, n4 + n2, n2);
                n3 = this.indexOf(string, n3);
            }
        }
        return this;
    }

    public TextStringBuilder deleteAll(StringMatcher stringMatcher) {
        return this.replace(stringMatcher, null, 0, this.g, -1);
    }

    public TextStringBuilder deleteCharAt(int n2) {
        this.validateIndex(n2);
        int n3 = n2;
        this.a(n3, n3 + 1, 1);
        return this;
    }

    public TextStringBuilder deleteFirst(char c2) {
        for (int i2 = 0; i2 < this.g; ++i2) {
            if (this.c[i2] != c2) continue;
            int n2 = i2;
            this.a(n2, n2 + 1, 1);
            break;
        }
        return this;
    }

    public TextStringBuilder deleteFirst(String string) {
        int n2;
        int n3 = string == null ? 0 : string.length();
        if (n3 > 0 && (n2 = this.indexOf(string, 0)) >= 0) {
            int n4 = n2;
            this.a(n4, n4 + n3, n3);
        }
        return this;
    }

    public TextStringBuilder deleteFirst(StringMatcher stringMatcher) {
        return this.replace(stringMatcher, null, 0, this.g, 1);
    }

    private void a(int n2, int n3, int n4) {
        System.arraycopy(this.c, n3, this.c, n2, this.g - n3);
        this.g -= n4;
    }

    public char drainChar(int n2) {
        this.validateIndex(n2);
        char c2 = this.c[n2];
        this.deleteCharAt(n2);
        return c2;
    }

    public int drainChars(int n2, int n3, char[] cArray, int n4) {
        if (this.isEmpty() || (n3 -= n2) == 0 || cArray.length == 0) {
            return 0;
        }
        n3 = Math.min(Math.min(this.g, n3), cArray.length - n4);
        this.getChars(n2, n3, cArray, n4);
        this.delete(n2, n3);
        return n3;
    }

    public boolean endsWith(String string) {
        if (string == null) {
            return false;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return true;
        }
        if (n2 > this.g) {
            return false;
        }
        int n3 = this.g - n2;
        int n4 = 0;
        while (n4 < n2) {
            if (this.c[n3] != string.charAt(n4)) {
                return false;
            }
            ++n4;
            ++n3;
        }
        return true;
    }

    public TextStringBuilder ensureCapacity(int n2) {
        if (n2 > 0 && n2 - this.c.length > 0) {
            this.c(n2);
        }
        return this;
    }

    public boolean equals(Object object) {
        return object instanceof TextStringBuilder && this.equals((TextStringBuilder)object);
    }

    public boolean equals(TextStringBuilder object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.g != ((TextStringBuilder)object).g) {
            return false;
        }
        char[] cArray = this.c;
        object = ((TextStringBuilder)object).c;
        for (int i2 = this.g - 1; i2 >= 0; --i2) {
            if (cArray[i2] == object[i2]) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(TextStringBuilder object) {
        if (this == object) {
            return true;
        }
        if (this.g != ((TextStringBuilder)object).g) {
            return false;
        }
        char[] cArray = this.c;
        object = ((TextStringBuilder)object).c;
        for (int i2 = this.g - 1; i2 >= 0; --i2) {
            char c2 = cArray[i2];
            Object object2 = object[i2];
            if (c2 == object2 || Character.toUpperCase(c2) == Character.toUpperCase((char)object2)) continue;
            return false;
        }
        return true;
    }

    final char[] a() {
        return this.c;
    }

    public char[] getChars(char[] cArray) {
        int n2 = this.length();
        if (cArray == null || cArray.length < n2) {
            cArray = new char[n2];
        }
        System.arraycopy(this.c, 0, cArray, 0, n2);
        return cArray;
    }

    public void getChars(int n2, int n3, char[] cArray, int n4) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 < 0 || n3 > this.length()) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n2 > n3) {
            throw new StringIndexOutOfBoundsException("end < start");
        }
        System.arraycopy(this.c, n2, cArray, n4, n3 - n2);
    }

    public String getNewLineText() {
        return this.d;
    }

    public String getNullText() {
        return this.e;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int indexOf(char c2) {
        return this.indexOf(c2, 0);
    }

    public int indexOf(char c2, int n2) {
        if ((n2 = Math.max(0, n2)) >= this.g) {
            return -1;
        }
        char[] cArray = this.c;
        while (n2 < this.g) {
            if (cArray[n2] == c2) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n2) {
        n2 = Math.max(0, n2);
        if (string == null || n2 >= this.g) {
            return -1;
        }
        int n3 = string.length();
        if (n3 == 1) {
            return this.indexOf(string.charAt(0), n2);
        }
        if (n3 == 0) {
            return n2;
        }
        if (n3 > this.g) {
            return -1;
        }
        char[] cArray = this.c;
        int n4 = this.g - n3 + 1;
        while (n2 < n4) {
            block7: {
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (string.charAt(i2) == cArray[n2 + i2]) {
                        continue;
                    }
                    break block7;
                }
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int indexOf(StringMatcher stringMatcher) {
        return this.indexOf(stringMatcher, 0);
    }

    public int indexOf(StringMatcher stringMatcher, int n2) {
        n2 = Math.max(0, n2);
        if (stringMatcher == null || n2 >= this.g) {
            return -1;
        }
        int n3 = this.g;
        char[] cArray = this.c;
        for (int i2 = n2; i2 < n3; ++i2) {
            if (stringMatcher.isMatch(cArray, i2, n2, n3) <= 0) continue;
            return i2;
        }
        return -1;
    }

    public TextStringBuilder insert(int n2, boolean bl2) {
        this.validateIndex(n2);
        if (bl2) {
            TextStringBuilder textStringBuilder = this;
            textStringBuilder.ensureCapacity(textStringBuilder.g + b);
            System.arraycopy(this.c, n2, this.c, n2 + b, this.g - n2);
            this.b(n2);
        } else {
            TextStringBuilder textStringBuilder = this;
            textStringBuilder.ensureCapacity(textStringBuilder.g + a);
            System.arraycopy(this.c, n2, this.c, n2 + a, this.g - n2);
            this.a(n2);
        }
        return this;
    }

    public TextStringBuilder insert(int n2, char c2) {
        this.validateIndex(n2);
        TextStringBuilder textStringBuilder = this;
        textStringBuilder.ensureCapacity(textStringBuilder.g + 1);
        System.arraycopy(this.c, n2, this.c, n2 + 1, this.g - n2);
        this.c[n2] = c2;
        ++this.g;
        return this;
    }

    public TextStringBuilder insert(int n2, char[] cArray) {
        this.validateIndex(n2);
        if (cArray == null) {
            return this.insert(n2, this.e);
        }
        int n3 = cArray.length;
        if (n3 > 0) {
            TextStringBuilder textStringBuilder = this;
            textStringBuilder.ensureCapacity(textStringBuilder.g + n3);
            System.arraycopy(this.c, n2, this.c, n2 + n3, this.g - n2);
            System.arraycopy(cArray, 0, this.c, n2, n3);
            this.g += n3;
        }
        return this;
    }

    public TextStringBuilder insert(int n2, char[] cArray, int n3, int n4) {
        this.validateIndex(n2);
        if (cArray == null) {
            return this.insert(n2, this.e);
        }
        if (n3 < 0 || n3 > cArray.length) {
            throw new StringIndexOutOfBoundsException("Invalid offset: " + n3);
        }
        if (n4 < 0 || n3 + n4 > cArray.length) {
            throw new StringIndexOutOfBoundsException("Invalid length: " + n4);
        }
        if (n4 > 0) {
            TextStringBuilder textStringBuilder = this;
            textStringBuilder.ensureCapacity(textStringBuilder.g + n4);
            System.arraycopy(this.c, n2, this.c, n2 + n4, this.g - n2);
            System.arraycopy(cArray, n3, this.c, n2, n4);
            this.g += n4;
        }
        return this;
    }

    public TextStringBuilder insert(int n2, double d2) {
        return this.insert(n2, String.valueOf(d2));
    }

    public TextStringBuilder insert(int n2, float f2) {
        return this.insert(n2, String.valueOf(f2));
    }

    public TextStringBuilder insert(int n2, int n3) {
        return this.insert(n2, String.valueOf(n3));
    }

    public TextStringBuilder insert(int n2, long l2) {
        return this.insert(n2, String.valueOf(l2));
    }

    public TextStringBuilder insert(int n2, Object object) {
        if (object == null) {
            return this.insert(n2, this.e);
        }
        return this.insert(n2, object.toString());
    }

    public TextStringBuilder insert(int n2, String string) {
        int n3;
        this.validateIndex(n2);
        if (string == null) {
            string = this.e;
        }
        if (string != null && (n3 = string.length()) > 0) {
            int n4 = this.g + n3;
            this.ensureCapacity(n4);
            System.arraycopy(this.c, n2, this.c, n2 + n3, this.g - n2);
            this.g = n4;
            string.getChars(0, n3, this.c, n2);
        }
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.g == 0;
    }

    public boolean isNotEmpty() {
        return this.g != 0;
    }

    public boolean isReallocated() {
        return this.f > 0;
    }

    public int lastIndexOf(char c2) {
        return this.lastIndexOf(c2, this.g - 1);
    }

    public int lastIndexOf(char c2, int n2) {
        if ((n2 = n2 >= this.g ? this.g - 1 : n2) < 0) {
            return -1;
        }
        while (n2 >= 0) {
            if (this.c[n2] == c2) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.g - 1);
    }

    public int lastIndexOf(String string, int n2) {
        int n3 = n2 = n2 >= this.g ? this.g - 1 : n2;
        if (string == null || n2 < 0) {
            return -1;
        }
        int n4 = string.length();
        if (n4 > 0 && n4 <= this.g) {
            if (n4 == 1) {
                return this.lastIndexOf(string.charAt(0), n2);
            }
            block0: for (n2 = n2 - n4 + 1; n2 >= 0; --n2) {
                for (int i2 = 0; i2 < n4; ++i2) {
                    if (string.charAt(i2) != this.c[n2 + i2]) continue block0;
                }
                return n2;
            }
        } else if (n4 == 0) {
            return n2;
        }
        return -1;
    }

    public int lastIndexOf(StringMatcher stringMatcher) {
        return this.lastIndexOf(stringMatcher, this.g);
    }

    public int lastIndexOf(StringMatcher stringMatcher, int n2) {
        int n3 = n2 = n2 >= this.g ? this.g - 1 : n2;
        if (stringMatcher == null || n2 < 0) {
            return -1;
        }
        char[] cArray = this.c;
        int n4 = n2 + 1;
        while (n2 >= 0) {
            if (stringMatcher.isMatch(cArray, n2, 0, n4) > 0) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public String leftString(int n2) {
        if (n2 <= 0) {
            return "";
        }
        if (n2 >= this.g) {
            return new String(this.c, 0, this.g);
        }
        return new String(this.c, 0, n2);
    }

    @Override
    public int length() {
        return this.g;
    }

    public String midString(int n2, int n3) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 <= 0 || n2 >= this.g) {
            return "";
        }
        if (this.g <= n2 + n3) {
            return new String(this.c, n2, this.g - n2);
        }
        return new String(this.c, n2, n3);
    }

    public TextStringBuilder minimizeCapacity() {
        if (this.c.length > this.g) {
            TextStringBuilder textStringBuilder = this;
            textStringBuilder.c(textStringBuilder.g);
        }
        return this;
    }

    public int readFrom(CharBuffer charBuffer) {
        int n2 = this.g;
        int n3 = charBuffer.remaining();
        TextStringBuilder textStringBuilder = this;
        textStringBuilder.ensureCapacity(textStringBuilder.g + n3);
        charBuffer.get(this.c, this.g, n3);
        this.g += n3;
        return this.g - n2;
    }

    public int readFrom(Readable readable) {
        if (readable instanceof Reader) {
            return this.readFrom((Reader)readable);
        }
        if (readable instanceof CharBuffer) {
            return this.readFrom((CharBuffer)readable);
        }
        int n2 = this.g;
        while (true) {
            TextStringBuilder textStringBuilder = this;
            textStringBuilder.ensureCapacity(textStringBuilder.g + 1);
            CharBuffer charBuffer = CharBuffer.wrap(this.c, this.g, this.c.length - this.g);
            int n3 = readable.read(charBuffer);
            if (n3 == -1) break;
            this.g += n3;
        }
        return this.g - n2;
    }

    public int readFrom(Reader reader) {
        int n2 = this.g;
        TextStringBuilder textStringBuilder = this;
        textStringBuilder.ensureCapacity(textStringBuilder.g + 1);
        int n3 = reader.read(this.c, this.g, this.c.length - this.g);
        if (n3 == -1) {
            return -1;
        }
        do {
            this.g += n3;
            TextStringBuilder textStringBuilder2 = this;
            textStringBuilder2.ensureCapacity(textStringBuilder2.g + 1);
        } while ((n3 = reader.read(this.c, this.g, this.c.length - this.g)) != -1);
        return this.g - n2;
    }

    public int readFrom(Reader reader, int n2) {
        if (n2 <= 0) {
            return 0;
        }
        int n3 = this.g;
        TextStringBuilder textStringBuilder = this;
        textStringBuilder.ensureCapacity(textStringBuilder.g + n2);
        int n4 = n2;
        n2 = reader.read(this.c, this.g, n2);
        if (n2 == -1) {
            return -1;
        }
        do {
            this.g += n2;
            n2 = reader.read(this.c, this.g, n4 -= n2);
        } while (n4 > 0 && n2 != -1);
        return this.g - n3;
    }

    private void c(int n2) {
        this.c = Arrays.copyOf(this.c, n2);
        ++this.f;
    }

    public TextStringBuilder replace(int n2, int n3, String string) {
        n3 = this.validateRange(n2, n3);
        int n4 = string == null ? 0 : string.length();
        int n5 = n3;
        this.a(n2, n5, n5 - n2, string, n4);
        return this;
    }

    public TextStringBuilder replace(StringMatcher object, String object2, int n2, int n3, int n4) {
        n3 = this.validateRange(n2, n3);
        int n5 = n4;
        n4 = n3;
        n3 = n2;
        String string = object2;
        object2 = object;
        object = this;
        if (object2 == null || ((TextStringBuilder)object).g == 0) {
            return object;
        }
        int n6 = string == null ? 0 : string.length();
        for (int i2 = n3; i2 < n4 && n5 != 0; ++i2) {
            char[] cArray = ((TextStringBuilder)object).c;
            int n7 = object2.isMatch(cArray, i2, n3, n4);
            if (n7 <= 0) continue;
            int n8 = i2;
            super.a(n8, n8 + n7, n7, string, n6);
            n4 = n4 - n7 + n6;
            i2 = i2 + n6 - 1;
            if (n5 <= 0) continue;
            --n5;
        }
        return object;
    }

    public TextStringBuilder replaceAll(char c2, char c3) {
        if (c2 != c3) {
            for (int i2 = 0; i2 < this.g; ++i2) {
                if (this.c[i2] != c2) continue;
                this.c[i2] = c3;
            }
        }
        return this;
    }

    public TextStringBuilder replaceAll(String string, String string2) {
        int n2 = string == null ? 0 : string.length();
        if (n2 > 0) {
            int n3 = string2 == null ? 0 : string2.length();
            int n4 = this.indexOf(string, 0);
            while (n4 >= 0) {
                int n5 = n4;
                this.a(n5, n5 + n2, n2, string2, n3);
                n4 = this.indexOf(string, n4 + n3);
            }
        }
        return this;
    }

    public TextStringBuilder replaceAll(StringMatcher stringMatcher, String string) {
        return this.replace(stringMatcher, string, 0, this.g, -1);
    }

    public TextStringBuilder replaceFirst(char c2, char c3) {
        if (c2 != c3) {
            for (int i2 = 0; i2 < this.g; ++i2) {
                if (this.c[i2] != c2) continue;
                this.c[i2] = c3;
                break;
            }
        }
        return this;
    }

    public TextStringBuilder replaceFirst(String string, String string2) {
        int n2;
        int n3 = string == null ? 0 : string.length();
        if (n3 > 0 && (n2 = this.indexOf(string, 0)) >= 0) {
            int n4 = string2 == null ? 0 : string2.length();
            int n5 = n2;
            this.a(n5, n5 + n3, n3, string2, n4);
        }
        return this;
    }

    public TextStringBuilder replaceFirst(StringMatcher stringMatcher, String string) {
        return this.replace(stringMatcher, string, 0, this.g, 1);
    }

    private void a(int n2, int n3, int n4, String string, int n5) {
        int n6 = this.g - n4 + n5;
        if (n5 != n4) {
            this.ensureCapacity(n6);
            System.arraycopy(this.c, n3, this.c, n2 + n5, this.g - n3);
            this.g = n6;
        }
        if (n5 > 0) {
            string.getChars(0, n5, this.c, n2);
        }
    }

    public TextStringBuilder reverse() {
        if (this.g == 0) {
            return this;
        }
        int n2 = this.g / 2;
        char[] cArray = this.c;
        int n3 = 0;
        int n4 = this.g - 1;
        while (n3 < n2) {
            char c2 = cArray[n3];
            cArray[n3] = cArray[n4];
            cArray[n4] = c2;
            ++n3;
            --n4;
        }
        return this;
    }

    public String rightString(int n2) {
        if (n2 <= 0) {
            return "";
        }
        if (n2 >= this.g) {
            return new String(this.c, 0, this.g);
        }
        return new String(this.c, this.g - n2, n2);
    }

    public TextStringBuilder set(CharSequence charSequence) {
        this.clear();
        this.append(charSequence);
        return this;
    }

    public TextStringBuilder setCharAt(int n2, char c2) {
        this.validateIndex(n2);
        this.c[n2] = c2;
        return this;
    }

    public TextStringBuilder setLength(int n2) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n2 < this.g) {
            this.g = n2;
        } else if (n2 > this.g) {
            this.ensureCapacity(n2);
            int n3 = this.g;
            this.g = n2;
            Arrays.fill(this.c, n3, n2, '\u0000');
        }
        return this;
    }

    public TextStringBuilder setNewLineText(String string) {
        this.d = string;
        return this;
    }

    public TextStringBuilder setNullText(String string) {
        if (string != null && string.isEmpty()) {
            string = null;
        }
        this.e = string;
        return this;
    }

    public int size() {
        return this.g;
    }

    public boolean startsWith(String string) {
        if (string == null) {
            return false;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return true;
        }
        if (n2 > this.g) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.c[i2] == string.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public CharSequence subSequence(int n2, int n3) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 > this.g) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n2 > n3) {
            throw new StringIndexOutOfBoundsException(n3 - n2);
        }
        return this.substring(n2, n3);
    }

    public String substring(int n2) {
        return this.substring(n2, this.g);
    }

    public String substring(int n2, int n3) {
        n3 = this.validateRange(n2, n3);
        return new String(this.c, n2, n3 - n2);
    }

    public char[] toCharArray() {
        if (this.g == 0) {
            return ArrayUtils.EMPTY_CHAR_ARRAY;
        }
        return Arrays.copyOf(this.c, this.g);
    }

    public char[] toCharArray(int n2, int n3) {
        int n4 = (n3 = this.validateRange(n2, n3)) - n2;
        if (n4 == 0) {
            return ArrayUtils.EMPTY_CHAR_ARRAY;
        }
        return Arrays.copyOfRange(this.c, n2, n3);
    }

    @Override
    public String toString() {
        return new String(this.c, 0, this.g);
    }

    public StringBuffer toStringBuffer() {
        return new StringBuffer(this.g).append(this.c, 0, this.g);
    }

    public StringBuilder toStringBuilder() {
        return new StringBuilder(this.g).append(this.c, 0, this.g);
    }

    public TextStringBuilder trim() {
        int n2;
        if (this.g == 0) {
            return this;
        }
        int n3 = this.g;
        char[] cArray = this.c;
        for (n2 = 0; n2 < n3 && cArray[n2] <= ' '; ++n2) {
        }
        while (n2 < n3 && cArray[n3 - 1] <= ' ') {
            --n3;
        }
        if (n3 < this.g) {
            this.delete(n3, this.g);
        }
        if (n2 > 0) {
            this.delete(0, n2);
        }
        return this;
    }

    protected void validateIndex(int n2) {
        if (n2 < 0 || n2 >= this.g) {
            throw new StringIndexOutOfBoundsException(n2);
        }
    }

    protected int validateRange(int n2, int n3) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 > this.g) {
            n3 = this.g;
        }
        if (n2 > n3) {
            throw new StringIndexOutOfBoundsException("end < start");
        }
        return n3;
    }

    final class c
    extends Writer {
        private /* synthetic */ TextStringBuilder a;

        c(TextStringBuilder textStringBuilder) {
            this.a = textStringBuilder;
        }

        @Override
        public final void close() {
        }

        @Override
        public final void flush() {
        }

        @Override
        public final void write(char[] cArray) {
            this.a.append(cArray);
        }

        @Override
        public final void write(char[] cArray, int n2, int n3) {
            this.a.append(cArray, n2, n3);
        }

        @Override
        public final void write(int n2) {
            this.a.append((char)n2);
        }

        @Override
        public final void write(String string) {
            this.a.append(string);
        }

        @Override
        public final void write(String string, int n2, int n3) {
            this.a.append(string, n2, n3);
        }
    }

    final class b
    extends StringTokenizer {
        private /* synthetic */ TextStringBuilder a;

        b(TextStringBuilder textStringBuilder) {
            this.a = textStringBuilder;
        }

        @Override
        public final String getContent() {
            String string = super.getContent();
            if (string == null) {
                return this.a.toString();
            }
            return string;
        }

        @Override
        protected final List<String> tokenize(char[] cArray, int n2, int n3) {
            if (cArray == null) {
                b b2 = this;
                return super.tokenize(b2.a.a(), 0, this.a.size());
            }
            return super.tokenize(cArray, n2, n3);
        }
    }

    final class a
    extends Reader {
        private int a;
        private int b;
        private /* synthetic */ TextStringBuilder c;

        a(TextStringBuilder textStringBuilder) {
            this.c = textStringBuilder;
        }

        @Override
        public final void close() {
        }

        @Override
        public final void mark(int n2) {
            this.a = this.b;
        }

        @Override
        public final boolean markSupported() {
            return true;
        }

        @Override
        public final int read() {
            if (!this.ready()) {
                return -1;
            }
            return this.c.charAt(this.b++);
        }

        @Override
        public final int read(char[] cArray, int n2, int n3) {
            if (n2 < 0 || n3 < 0 || n2 > cArray.length || n2 + n3 > cArray.length || n2 + n3 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n3 == 0) {
                return 0;
            }
            if (this.b >= this.c.size()) {
                return -1;
            }
            if (this.b + n3 > this.c.size()) {
                n3 = this.c.size() - this.b;
            }
            this.c.getChars(this.b, this.b + n3, cArray, n2);
            this.b += n3;
            return n3;
        }

        @Override
        public final boolean ready() {
            return this.b < this.c.size();
        }

        @Override
        public final void reset() {
            this.b = this.a;
        }

        @Override
        public final long skip(long l2) {
            if ((long)this.b + l2 > (long)this.c.size()) {
                l2 = this.c.size() - this.b;
            }
            if (l2 < 0L) {
                return 0L;
            }
            this.b = Math.addExact(this.b, Math.toIntExact(l2));
            return l2;
        }
    }
}

