/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal.text;

import com.github.jknack.handlebars.internal.lang3.ArrayUtils;
import com.github.jknack.handlebars.internal.lang3.StringUtils;
import com.github.jknack.handlebars.internal.lang3.Validate;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WordUtils {
    public static String abbreviate(String string, int n2, int n3, String string2) {
        Validate.isTrue(n3 >= -1, "upper value cannot be less than -1", new Object[0]);
        Validate.isTrue(n3 >= n2 || n3 == -1, "upper value is less than lower value", new Object[0]);
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        if (n2 > string.length()) {
            n2 = string.length();
        }
        if (n3 == -1 || n3 > string.length()) {
            n3 = string.length();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if ((n2 = StringUtils.indexOf((CharSequence)string, " ", n2)) == -1) {
            stringBuilder.append(string, 0, n3);
            if (n3 != string.length()) {
                stringBuilder.append(StringUtils.defaultString(string2));
            }
        } else {
            stringBuilder.append(string, 0, Math.min(n2, n3));
            stringBuilder.append(StringUtils.defaultString(string2));
        }
        return stringBuilder.toString();
    }

    public static String capitalize(String string) {
        return WordUtils.capitalize(string, null);
    }

    public static String capitalize(String string, char ... object) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        object = WordUtils.a((char[])object);
        int n2 = string.length();
        int[] nArray = new int[n2];
        int n3 = 0;
        int n4 = 1;
        int n5 = 0;
        while (n5 < n2) {
            int n6 = string.codePointAt(n5);
            if (object.contains(n6)) {
                n4 = 1;
            } else if (n4 != 0) {
                n4 = Character.toTitleCase(n6);
                nArray[n3++] = n4;
                n5 += Character.charCount(n4);
                n4 = 0;
                continue;
            }
            nArray[n3++] = n6;
            n5 += Character.charCount(n6);
        }
        return new String(nArray, 0, n3);
    }

    public static String capitalizeFully(String string) {
        return WordUtils.capitalizeFully(string, null);
    }

    public static String capitalizeFully(String string, char ... cArray) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        string = string.toLowerCase();
        return WordUtils.capitalize(string, cArray);
    }

    public static boolean containsAllWords(CharSequence charSequence, CharSequence ... charSequenceArray) {
        if (StringUtils.isEmpty(charSequence) || ArrayUtils.isEmpty(charSequenceArray)) {
            return false;
        }
        for (CharSequence charSequence2 : charSequenceArray) {
            if (StringUtils.isBlank(charSequence2)) {
                return false;
            }
            Pattern object = Pattern.compile(".*\\b" + charSequence2 + "\\b.*");
            if (object.matcher(charSequence).matches()) continue;
            return false;
        }
        return true;
    }

    private static Set<Integer> a(char[] cArray) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (cArray == null || cArray.length == 0) {
            if (cArray == null) {
                hashSet.add(Character.codePointAt(new char[]{' '}, 0));
            }
            return hashSet;
        }
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            hashSet.add(Character.codePointAt(cArray, i2));
        }
        return hashSet;
    }

    public static String initials(String string) {
        return WordUtils.initials(string, null);
    }

    public static String initials(String string, char ... cArray) {
        int n2;
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        if (cArray != null && cArray.length == 0) {
            return "";
        }
        Set<Integer> set = WordUtils.a(cArray);
        int n3 = string.length();
        int[] nArray = new int[n3 / 2 + 1];
        int n4 = 0;
        boolean bl2 = true;
        for (int i2 = 0; i2 < n3; i2 += Character.charCount(n2)) {
            n2 = string.codePointAt(i2);
            if (set.contains(n2) || cArray == null && Character.isWhitespace(n2)) {
                bl2 = true;
                continue;
            }
            if (!bl2) continue;
            nArray[n4++] = n2;
            bl2 = false;
        }
        return new String(nArray, 0, n4);
    }

    @Deprecated
    public static boolean isDelimiter(char c2, char[] cArray) {
        if (cArray == null) {
            return Character.isWhitespace(c2);
        }
        for (char c3 : cArray) {
            if (c2 != c3) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isDelimiter(int n2, char[] cArray) {
        if (cArray == null) {
            return Character.isWhitespace(n2);
        }
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            int n3 = Character.codePointAt(cArray, i2);
            if (n3 != n2) continue;
            return true;
        }
        return false;
    }

    public static String swapCase(String string) {
        int n2;
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        int n3 = string.length();
        int[] nArray = new int[n3];
        int n4 = 0;
        boolean bl2 = true;
        for (int i2 = 0; i2 < n3; i2 += Character.charCount(n2)) {
            n2 = string.codePointAt(i2);
            if (Character.isUpperCase(n2) || Character.isTitleCase(n2)) {
                n2 = Character.toLowerCase(n2);
                bl2 = false;
            } else if (Character.isLowerCase(n2)) {
                if (bl2) {
                    n2 = Character.toTitleCase(n2);
                    bl2 = false;
                } else {
                    n2 = Character.toUpperCase(n2);
                }
            } else {
                bl2 = Character.isWhitespace(n2);
            }
            nArray[n4++] = n2;
        }
        return new String(nArray, 0, n4);
    }

    public static String uncapitalize(String string) {
        return WordUtils.uncapitalize(string, null);
    }

    public static String uncapitalize(String string, char ... object) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        object = WordUtils.a((char[])object);
        int n2 = string.length();
        int[] nArray = new int[n2];
        int n3 = 0;
        int n4 = 1;
        int n5 = 0;
        while (n5 < n2) {
            int n6 = string.codePointAt(n5);
            if (object.contains(n6)) {
                n4 = 1;
            } else if (n4 != 0) {
                n4 = Character.toLowerCase(n6);
                nArray[n3++] = n4;
                n5 += Character.charCount(n4);
                n4 = 0;
                continue;
            }
            nArray[n3++] = n6;
            n5 += Character.charCount(n6);
        }
        return new String(nArray, 0, n3);
    }

    public static String wrap(String string, int n2) {
        return WordUtils.wrap(string, n2, null, false);
    }

    public static String wrap(String string, int n2, String string2, boolean bl2) {
        return WordUtils.wrap(string, n2, string2, bl2, " ");
    }

    public static String wrap(String string, int n2, String string2, boolean bl2, String object) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = System.lineSeparator();
        }
        if (n2 <= 0) {
            n2 = 1;
        }
        if (StringUtils.isBlank((CharSequence)object)) {
            object = " ";
        }
        object = Pattern.compile((String)object);
        int n3 = string.length();
        int n4 = 0;
        StringBuilder stringBuilder = new StringBuilder(n3 + 32);
        int n5 = -1;
        while (n4 < n3) {
            int n6 = -1;
            Matcher matcher = ((Pattern)object).matcher(string.substring(n4, Math.min((int)Math.min(Integer.MAX_VALUE, (long)(n4 + n2) + 1L), n3)));
            if (matcher.find()) {
                if (matcher.start() == 0) {
                    n5 = matcher.end();
                    if (n5 != 0) {
                        n4 += matcher.end();
                        continue;
                    }
                    ++n4;
                }
                n6 = matcher.start() + n4;
            }
            if (n3 - n4 <= n2) break;
            while (matcher.find()) {
                n6 = matcher.start() + n4;
            }
            if (n6 >= n4) {
                stringBuilder.append(string, n4, n6);
                stringBuilder.append(string2);
                n4 = n6 + 1;
                continue;
            }
            if (bl2) {
                if (n5 == 0) {
                    --n4;
                }
                stringBuilder.append(string, n4, n2 + n4);
                stringBuilder.append(string2);
                n4 += n2;
                n5 = -1;
                continue;
            }
            matcher = ((Pattern)object).matcher(string.substring(n4 + n2));
            if (matcher.find()) {
                n5 = matcher.end() - matcher.start();
                n6 = matcher.start() + n4 + n2;
            }
            if (n6 >= 0) {
                if (n5 == 0 && n4 != 0) {
                    --n4;
                }
                stringBuilder.append(string, n4, n6);
                stringBuilder.append(string2);
                n4 = n6 + 1;
                continue;
            }
            if (n5 == 0 && n4 != 0) {
                --n4;
            }
            stringBuilder.append(string, n4, string.length());
            n4 = n3;
            n5 = -1;
        }
        if (n5 == 0 && n4 < n3) {
            --n4;
        }
        stringBuilder.append(string, n4, string.length());
        return stringBuilder.toString();
    }
}

