/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal.text.translate;

import com.github.jknack.handlebars.internal.lang3.Range;
import com.github.jknack.handlebars.internal.text.translate.CodePointTranslator;
import java.io.Writer;

public class NumericEntityEscaper
extends CodePointTranslator {
    private final boolean b;
    private final Range<Integer> c;

    public static NumericEntityEscaper above(int n2) {
        return NumericEntityEscaper.outsideOf(0, n2);
    }

    public static NumericEntityEscaper below(int n2) {
        return NumericEntityEscaper.outsideOf(n2, Integer.MAX_VALUE);
    }

    public static NumericEntityEscaper between(int n2, int n3) {
        return new NumericEntityEscaper(n2, n3, true);
    }

    public static NumericEntityEscaper outsideOf(int n2, int n3) {
        return new NumericEntityEscaper(n2, n3, false);
    }

    public NumericEntityEscaper() {
        this(0, Integer.MAX_VALUE, true);
    }

    private NumericEntityEscaper(int n2, int n3, boolean bl2) {
        this.c = Range.between(n2, n3);
        this.b = bl2;
    }

    @Override
    public boolean translate(int n2, Writer writer) {
        if (this.b != this.c.contains(n2)) {
            return false;
        }
        writer.write("&#");
        writer.write(Integer.toString(n2, 10));
        writer.write(59);
        return true;
    }
}

