/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal.text.translate;

import com.github.jknack.handlebars.internal.text.translate.CodePointTranslator;
import java.io.Writer;

public class UnicodeEscaper
extends CodePointTranslator {
    private final int b;
    private final int c;
    private final boolean d;

    public static UnicodeEscaper above(int n2) {
        return UnicodeEscaper.outsideOf(0, n2);
    }

    public static UnicodeEscaper below(int n2) {
        return UnicodeEscaper.outsideOf(n2, Integer.MAX_VALUE);
    }

    public static UnicodeEscaper between(int n2, int n3) {
        return new UnicodeEscaper(n2, n3, true);
    }

    public static UnicodeEscaper outsideOf(int n2, int n3) {
        return new UnicodeEscaper(n2, n3, false);
    }

    public UnicodeEscaper() {
        this(0, Integer.MAX_VALUE, true);
    }

    protected UnicodeEscaper(int n2, int n3, boolean bl2) {
        this.b = n2;
        this.c = n3;
        this.d = bl2;
    }

    protected String toUtf16Escape(int n2) {
        return "\\u" + UnicodeEscaper.hex(n2);
    }

    @Override
    public boolean translate(int n2, Writer writer) {
        if (this.d ? n2 < this.b || n2 > this.c : n2 >= this.b && n2 <= this.c) {
            return false;
        }
        if (n2 > 65535) {
            writer.write(this.toUtf16Escape(n2));
        } else {
            writer.write("\\u");
            writer.write(a[n2 >> 12 & 0xF]);
            writer.write(a[n2 >> 8 & 0xF]);
            writer.write(a[n2 >> 4 & 0xF]);
            writer.write(a[n2 & 0xF]);
        }
        return true;
    }
}

