/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.io;

import com.github.jknack.handlebars.internal.lang3.Validate;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeTemplateLoader
implements TemplateLoader {
    private static final Logger a = LoggerFactory.getLogger(CompositeTemplateLoader.class);
    private final TemplateLoader[] b;

    public CompositeTemplateLoader(TemplateLoader ... templateLoaderArray) {
        Validate.isTrue(templateLoaderArray.length > 1, "At least two loaders are required.", new Object[0]);
        this.b = templateLoaderArray;
    }

    @Override
    public TemplateSource sourceAt(String string) {
        TemplateLoader[] templateLoaderArray = this.b;
        int n2 = this.b.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            TemplateLoader templateLoader = templateLoaderArray[i2];
            try {
                return templateLoader.sourceAt(string);
            }
            catch (IOException iOException) {
                a.trace("Unable to resolve: {}, trying next loader in the chain.", (Object)string);
                continue;
            }
        }
        throw new FileNotFoundException(string);
    }

    @Override
    public String resolve(String string) {
        TemplateLoader[] templateLoaderArray = this.b;
        int n2 = this.b.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            TemplateLoader templateLoader = templateLoaderArray[i2];
            try {
                templateLoader.sourceAt(string);
                return templateLoader.resolve(string);
            }
            catch (IOException iOException) {
                a.trace("Unable to resolve: {}, trying next loader in the chain.", (Object)string);
                continue;
            }
        }
        throw new IllegalStateException("Can't resolve: '" + string + "'");
    }

    @Override
    public String getPrefix() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSuffix() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPrefix(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSuffix(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharset(Charset charset) {
        TemplateLoader[] templateLoaderArray = this.b;
        int n2 = this.b.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            TemplateLoader templateLoader = templateLoaderArray[i2];
            templateLoader.setCharset(charset);
        }
    }

    @Override
    public Charset getCharset() {
        throw new UnsupportedOperationException();
    }

    public Iterable<TemplateLoader> getDelegates() {
        return Arrays.asList(this.b);
    }
}

