/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jsign.pkcs11;

import com.github.kwart.jsign.pkcs11.C;
import com.github.kwart.jsign.pkcs11.G;
import com.github.kwart.jsign.pkcs11.n;
import com.github.kwart.jsign.pkcs11.x;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import sun.security.internal.spec.TlsKeyMaterialParameterSpec;
import sun.security.internal.spec.TlsKeyMaterialSpec;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_SSL3_KEY_MAT_OUT;
import sun.security.pkcs11.wrapper.CK_SSL3_KEY_MAT_PARAMS;
import sun.security.pkcs11.wrapper.CK_SSL3_RANDOM_DATA;
import sun.security.pkcs11.wrapper.CK_TLS12_KEY_MAT_PARAMS;
import sun.security.pkcs11.wrapper.Functions;

public final class P11TlsKeyMaterialGenerator
extends KeyGeneratorSpi {
    private final G a;
    private final String b;
    private long c;
    private TlsKeyMaterialParameterSpec d;
    private n e;
    private int f;

    P11TlsKeyMaterialGenerator(G g2, String string, long l2) {
        this.a = g2;
        this.b = string;
        this.c = l2;
    }

    @Override
    protected final void engineInit(SecureRandom secureRandom) {
        throw new InvalidParameterException("TlsKeyMaterialGenerator must be initialized using a TlsKeyMaterialParameterSpec");
    }

    @Override
    protected final void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
        if (!(algorithmParameterSpec instanceof TlsKeyMaterialParameterSpec)) {
            throw new InvalidAlgorithmParameterException("TlsKeyMaterialGenerator must be initialized using a TlsKeyMaterialParameterSpec");
        }
        this.d = (TlsKeyMaterialParameterSpec)algorithmParameterSpec;
        try {
            this.e = x.a(this.a, this.d.getMasterSecret(), "TlsMasterSecret");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidAlgorithmParameterException("init() failed", invalidKeyException);
        }
        this.f = this.d.getMajorVersion() << 8 | this.d.getMinorVersion();
        if (this.f < 768 && this.f > 771) {
            throw new InvalidAlgorithmParameterException("Only SSL 3.0, TLS 1.0, TLS 1.1, and TLS 1.2 are supported");
        }
    }

    @Override
    protected final void engineInit(int n2, SecureRandom secureRandom) {
        throw new InvalidParameterException("TlsKeyMaterialGenerator must be initialized using a TlsKeyMaterialParameterSpec");
    }

    @Override
    protected final SecretKey engineGenerateKey() {
        SecretKey secretKey;
        boolean bl2;
        if (this.d == null) {
            throw new IllegalStateException("TlsKeyMaterialGenerator must be initialized");
        }
        if (this.f == 768) {
            this.c = 882L;
        } else if (this.f == 769 || this.f == 770) {
            this.c = 886L;
        }
        int n2 = this.d.getMacKeyLength() << 3;
        int n3 = this.d.getIvLength() << 3;
        int n4 = this.d.getExpandedCipherKeyLength() << 3;
        int n5 = this.d.getCipherKeyLength() << 3;
        if (n4 != 0) {
            bl2 = true;
        } else {
            bl2 = false;
            n4 = n5;
        }
        Object object = new CK_SSL3_RANDOM_DATA(this.d.getClientRandom(), this.d.getServerRandom());
        Object object2 = null;
        Object object3 = null;
        if (this.f < 771) {
            object2 = new CK_SSL3_KEY_MAT_PARAMS(n2, n5, n3, bl2, (CK_SSL3_RANDOM_DATA)object);
            object3 = new CK_MECHANISM(this.c, (CK_SSL3_KEY_MAT_PARAMS)object2);
        } else if (this.f == 771) {
            object2 = new CK_TLS12_KEY_MAT_PARAMS(n2, n5, n3, bl2, (CK_SSL3_RANDOM_DATA)object, Functions.getHashMechId(this.d.getPRFHashAlg()));
            object3 = new CK_MECHANISM(this.c, (CK_TLS12_KEY_MAT_PARAMS)object2);
        }
        Object object4 = this.d.getCipherAlgorithm();
        long l2 = x.a((String)object4);
        if (l2 < 0L) {
            if (n5 != 0) {
                throw new ProviderException("Unknown algorithm: " + this.d.getCipherAlgorithm());
            }
            l2 = 16L;
        }
        C c2 = null;
        try {
            n.k k2;
            object = this.a;
            c2 = object.e.b();
            object = n5 != 0 ? new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(256L, l2), new CK_ATTRIBUTE(353L, n4 >> 3)} : new CK_ATTRIBUTE[]{};
            object = this.a.a("generate", 4L, l2, (CK_ATTRIBUTE[])object);
            long l3 = this.e.a();
            try {
                this.a.b.C_DeriveKey(c2.a(), (CK_MECHANISM)object3, l3, (CK_ATTRIBUTE[])object);
            }
            finally {
                this.e.b();
            }
            object3 = null;
            if (object2 instanceof CK_SSL3_KEY_MAT_PARAMS) {
                object3 = ((CK_SSL3_KEY_MAT_PARAMS)object2).pReturnedKeyMaterial;
            } else if (object2 instanceof CK_TLS12_KEY_MAT_PARAMS) {
                object3 = ((CK_TLS12_KEY_MAT_PARAMS)object2).pReturnedKeyMaterial;
            }
            if (n2 != 0) {
                object2 = n.a(c2, ((CK_SSL3_KEY_MAT_OUT)object3).hClientMacSecret, "MAC", n2, object);
                secretKey = n.a(c2, ((CK_SSL3_KEY_MAT_OUT)object3).hServerMacSecret, "MAC", n2, object);
            } else {
                object2 = null;
                secretKey = null;
            }
            if (n5 != 0) {
                k2 = n.a(c2, ((CK_SSL3_KEY_MAT_OUT)object3).hClientKey, (String)object4, n4, object);
                object4 = n.a(c2, ((CK_SSL3_KEY_MAT_OUT)object3).hServerKey, (String)object4, n4, object);
            } else {
                k2 = null;
                object4 = null;
            }
            IvParameterSpec ivParameterSpec = ((CK_SSL3_KEY_MAT_OUT)object3).pIVClient == null ? null : new IvParameterSpec(((CK_SSL3_KEY_MAT_OUT)object3).pIVClient);
            object = ((CK_SSL3_KEY_MAT_OUT)object3).pIVServer == null ? null : new IvParameterSpec(((CK_SSL3_KEY_MAT_OUT)object3).pIVServer);
            secretKey = new TlsKeyMaterialSpec((SecretKey)object2, secretKey, k2, ivParameterSpec, (SecretKey)object4, (IvParameterSpec)object);
            this.a.b(c2);
        }
        catch (Exception exception) {
            try {
                throw new ProviderException("Could not generate key", exception);
            }
            catch (Throwable throwable) {
                this.a.b(c2);
                throw throwable;
            }
        }
        return secretKey;
    }
}

