/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jsign.pkcs11;

import com.github.kwart.jsign.pkcs11.C;
import com.github.kwart.jsign.pkcs11.G;
import com.github.kwart.jsign.pkcs11.n;
import com.github.kwart.jsign.pkcs11.x;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import sun.security.internal.spec.TlsMasterSecretParameterSpec;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_SSL3_MASTER_KEY_DERIVE_PARAMS;
import sun.security.pkcs11.wrapper.CK_SSL3_RANDOM_DATA;
import sun.security.pkcs11.wrapper.CK_TLS12_MASTER_KEY_DERIVE_PARAMS;
import sun.security.pkcs11.wrapper.CK_VERSION;
import sun.security.pkcs11.wrapper.Functions;

public final class P11TlsMasterSecretGenerator
extends KeyGeneratorSpi {
    private final G a;
    private final String b;
    private long c;
    private TlsMasterSecretParameterSpec d;
    private n e;
    private int f;

    P11TlsMasterSecretGenerator(G g2, String string, long l2) {
        this.a = g2;
        this.b = string;
        this.c = l2;
    }

    @Override
    protected final void engineInit(SecureRandom secureRandom) {
        throw new InvalidParameterException("TlsMasterSecretGenerator must be initialized using a TlsMasterSecretParameterSpec");
    }

    @Override
    protected final void engineInit(AlgorithmParameterSpec object, SecureRandom secureRandom) {
        if (!(object instanceof TlsMasterSecretParameterSpec)) {
            throw new InvalidAlgorithmParameterException("TlsMasterSecretGenerator must be initialized using a TlsMasterSecretParameterSpec");
        }
        this.d = (TlsMasterSecretParameterSpec)object;
        object = this.d.getPremasterSecret();
        try {
            this.e = x.a(this.a, (Key)object, null);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidAlgorithmParameterException("init() failed", invalidKeyException);
        }
        this.f = this.d.getMajorVersion() << 8 | this.d.getMinorVersion();
        if (this.f < 768 && this.f > 771) {
            throw new InvalidAlgorithmParameterException("Only SSL 3.0, TLS 1.0, TLS 1.1, and TLS 1.2 are supported");
        }
    }

    @Override
    protected final void engineInit(int n2, SecureRandom secureRandom) {
        throw new InvalidParameterException("TlsMasterSecretGenerator must be initialized using a TlsMasterSecretParameterSpec");
    }

    @Override
    protected final SecretKey engineGenerateKey() {
        if (this.d == null) {
            throw new IllegalStateException("TlsMasterSecretGenerator must be initialized");
        }
        boolean bl2 = this.e.getAlgorithm().equals("TlsRsaPremasterSecret");
        if (this.f == 768) {
            this.c = bl2 ? 881L : 883L;
        } else if (this.f == 769 || this.f == 770) {
            this.c = bl2 ? 885L : 887L;
        } else if (this.f == 771) {
            this.c = bl2 ? 992L : 994L;
        }
        CK_VERSION cK_VERSION = bl2 ? new CK_VERSION(0, 0) : null;
        Object object = this.d.getClientRandom();
        Object object2 = this.d.getServerRandom();
        object = new CK_SSL3_RANDOM_DATA((byte[])object, (byte[])object2);
        object2 = null;
        if (this.f < 771) {
            object = new CK_SSL3_MASTER_KEY_DERIVE_PARAMS((CK_SSL3_RANDOM_DATA)object, cK_VERSION);
            object2 = new CK_MECHANISM(this.c, (CK_SSL3_MASTER_KEY_DERIVE_PARAMS)object);
        } else if (this.f == 771) {
            object = new CK_TLS12_MASTER_KEY_DERIVE_PARAMS((CK_SSL3_RANDOM_DATA)object, cK_VERSION, Functions.getHashMechId(this.d.getPRFHashAlg()));
            object2 = new CK_MECHANISM(this.c, (CK_TLS12_MASTER_KEY_DERIVE_PARAMS)object);
        }
        object = null;
        long l2 = this.e.a();
        try {
            int n2;
            int n3;
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = this.a;
            object = this.a.e.b();
            cK_ATTRIBUTEArray = this.a.a("generate", 4L, 16L, new CK_ATTRIBUTE[0]);
            long l3 = this.a.b.C_DeriveKey(((C)object).a(), (CK_MECHANISM)object2, l2, cK_ATTRIBUTEArray);
            if (cK_VERSION == null) {
                n3 = -1;
                n2 = -1;
            } else {
                n3 = cK_VERSION.major;
                n2 = cK_VERSION.minor;
            }
            n.l l4 = n.a((C)object, l3, "TlsMasterSecret", 384, cK_ATTRIBUTEArray, n3, n2);
            return l4;
        }
        catch (Exception exception) {
            throw new ProviderException("Could not generate key", exception);
        }
        finally {
            this.e.b();
            this.a.b((C)object);
        }
    }
}

