/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jsign.pkcs11;

import com.github.kwart.jsign.pkcs11.C;
import com.github.kwart.jsign.pkcs11.G;
import com.github.kwart.jsign.pkcs11.l;
import com.github.kwart.jsign.pkcs11.n;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_MECHANISM_INFO;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.provider.ParameterCache;
import sun.security.rsa.RSAKeyFactory;
import sun.security.util.SecurityProviderConstants;

final class r
extends KeyPairGeneratorSpi {
    private final G a;
    private final String b;
    private final long c;
    private int d;
    private AlgorithmParameterSpec e;
    private BigInteger f = RSAKeyGenParameterSpec.F4;
    private final int g;
    private final int h;
    private SecureRandom i;

    r(G g2, String string, long l2) {
        int n2 = -1;
        int n3 = -1;
        try {
            CK_MECHANISM_INFO cK_MECHANISM_INFO = g2.b(l2);
            if (cK_MECHANISM_INFO != null) {
                n2 = (int)cK_MECHANISM_INFO.ulMinKeySize;
                n3 = (int)cK_MECHANISM_INFO.ulMaxKeySize;
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("Unexpected error while getting mechanism info", pKCS11Exception);
        }
        if (string.equals("EC")) {
            this.d = SecurityProviderConstants.DEF_EC_KEY_SIZE;
            if (n2 == -1 || n2 < 112) {
                n2 = 112;
            }
            if (n3 == -1 || n3 > 2048) {
                n3 = 2048;
            }
        } else {
            this.d = string.equals("DSA") ? SecurityProviderConstants.DEF_DSA_KEY_SIZE : (string.equals("RSA") ? SecurityProviderConstants.DEF_RSA_KEY_SIZE : SecurityProviderConstants.DEF_DH_KEY_SIZE);
            if (n2 == -1 || n2 < 512) {
                n2 = 512;
            }
            if (string.equals("RSA") && (n3 == -1 || n3 > 65536)) {
                n3 = 65536;
            }
        }
        if (n2 != -1 && this.d < n2) {
            this.d = n2;
        }
        if (n3 != -1 && this.d > n3) {
            this.d = n3;
        }
        this.a = g2;
        this.b = string;
        this.c = l2;
        this.g = n2;
        this.h = n3;
        r r2 = this;
        r2.initialize(r2.d, null);
    }

    @Override
    public final void initialize(int n2, SecureRandom secureRandom) {
        this.a.d();
        try {
            this.a(n2, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidParameterException(invalidAlgorithmParameterException.getMessage());
        }
        this.e = null;
        if (this.b.equals("EC")) {
            this.e = l.a(n2);
            if (this.e == null) {
                throw new InvalidParameterException("No EC parameters available for key size " + n2 + " bits");
            }
        }
        this.d = n2;
        this.i = secureRandom;
    }

    @Override
    public final void initialize(AlgorithmParameterSpec object, SecureRandom secureRandom) {
        int n2;
        this.a.d();
        if (this.b.equals("DH")) {
            if (!(object instanceof DHParameterSpec)) {
                throw new InvalidAlgorithmParameterException("DHParameterSpec required for Diffie-Hellman");
            }
            DHParameterSpec dHParameterSpec = (DHParameterSpec)object;
            n2 = dHParameterSpec.getP().bitLength();
            this.a(n2, dHParameterSpec);
        } else if (this.b.equals("RSA")) {
            if (!(object instanceof RSAKeyGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException("RSAKeyGenParameterSpec required for RSA");
            }
            RSAKeyGenParameterSpec rSAKeyGenParameterSpec = (RSAKeyGenParameterSpec)object;
            n2 = rSAKeyGenParameterSpec.getKeysize();
            this.a(n2, rSAKeyGenParameterSpec);
            object = null;
            this.f = rSAKeyGenParameterSpec.getPublicExponent();
        } else if (this.b.equals("DSA")) {
            if (!(object instanceof DSAParameterSpec)) {
                throw new InvalidAlgorithmParameterException("DSAParameterSpec required for DSA");
            }
            DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)object;
            n2 = dSAParameterSpec.getP().bitLength();
            this.a(n2, dSAParameterSpec);
        } else if (this.b.equals("EC")) {
            ECParameterSpec eCParameterSpec;
            if (object instanceof ECParameterSpec) {
                eCParameterSpec = l.a((ECParameterSpec)object);
                if (eCParameterSpec == null) {
                    throw new InvalidAlgorithmParameterException("Unsupported curve: " + object);
                }
            } else if (object instanceof ECGenParameterSpec) {
                eCParameterSpec = l.a((String)(object = ((ECGenParameterSpec)object).getName()));
                if (eCParameterSpec == null) {
                    throw new InvalidAlgorithmParameterException("Unknown curve name: " + (String)object);
                }
                object = eCParameterSpec;
            } else {
                throw new InvalidAlgorithmParameterException("ECParameterSpec or ECGenParameterSpec required for EC");
            }
            n2 = eCParameterSpec.getCurve().getField().getFieldSize();
            this.a(n2, eCParameterSpec);
        } else {
            throw new ProviderException("Unknown algorithm: " + this.b);
        }
        this.d = n2;
        this.e = object;
        this.i = secureRandom;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void a(int n2, AlgorithmParameterSpec algorithmParameterSpec) {
        if (this.g != -1 && n2 < this.g) {
            throw new InvalidAlgorithmParameterException(this.b + " key must be at least " + this.g + " bits. The specific key size " + n2 + " is not supported");
        }
        if (this.h != -1 && n2 > this.h) {
            throw new InvalidAlgorithmParameterException(this.b + " key must be at most " + this.h + " bits. The specific key size " + n2 + " is not supported");
        }
        if (this.b.equals("EC")) {
            if (n2 < 112) {
                throw new InvalidAlgorithmParameterException("EC key size must be at least 112 bit. The specific key size " + n2 + " is not supported");
            }
            if (n2 <= 2048) return;
            throw new InvalidAlgorithmParameterException("EC key size must be at most 2048 bit. The specific key size " + n2 + " is not supported");
        }
        if (n2 < 512) {
            throw new InvalidAlgorithmParameterException(this.b + " key size must be at least 512 bit. The specific key size " + n2 + " is not supported");
        }
        if (this.b.equals("RSA")) {
            BigInteger bigInteger = this.f;
            if (algorithmParameterSpec != null) {
                bigInteger = ((RSAKeyGenParameterSpec)algorithmParameterSpec).getPublicExponent();
            }
            try {
                RSAKeyFactory.checkKeyLengths(n2, bigInteger, this.g, this.h == -1 ? Integer.MAX_VALUE : this.h);
                return;
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidAlgorithmParameterException(invalidKeyException);
            }
        } else {
            if (this.b.equals("DH")) {
                if (algorithmParameterSpec != null) {
                    if (n2 <= 65536) return;
                    throw new InvalidAlgorithmParameterException("DH key size must be at most 65536 bit. The specific key size " + n2 + " is not supported");
                }
                if (n2 > 8192 || n2 < 512 || (n2 & 0x3F) != 0) {
                    throw new InvalidAlgorithmParameterException("DH key size must be multiple of 64, and can only range from 512 to 8192 (inclusive). The specific key size " + n2 + " is not supported");
                }
                DHParameterSpec dHParameterSpec = ParameterCache.getCachedDHParameterSpec(n2);
                if (dHParameterSpec != null || n2 <= 1024) return;
                throw new InvalidAlgorithmParameterException("Unsupported " + n2 + "-bit DH parameter generation");
            }
            if (n2 == 3072 || n2 == 2048 || n2 <= 1024 && (n2 & 0x3F) == 0) return;
            throw new InvalidAlgorithmParameterException("DSA key must be multiples of 64 if less than 1024 bits, or 2048, 3072 bits. The specific key size " + n2 + " is not supported");
        }
    }

    @Override
    public final KeyPair generateKeyPair() {
        Object object;
        Object object2;
        Object object3;
        long l2;
        this.a.d();
        if (this.b.equals("RSA")) {
            l2 = 0L;
            object3 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(289L, this.d), new CK_ATTRIBUTE(290L, this.f)};
            object2 = new CK_ATTRIBUTE[]{};
        } else if (this.b.equals("DSA")) {
            l2 = 1L;
            if (this.e == null) {
                try {
                    object = ParameterCache.getDSAParameterSpec(this.d, this.i);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new ProviderException("Could not generate DSA parameters", generalSecurityException);
                }
            } else {
                object = (DSAParameterSpec)this.e;
            }
            object3 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(304L, ((DSAParameterSpec)object).getP()), new CK_ATTRIBUTE(305L, ((DSAParameterSpec)object).getQ()), new CK_ATTRIBUTE(306L, ((DSAParameterSpec)object).getG())};
            object2 = new CK_ATTRIBUTE[]{};
        } else if (this.b.equals("DH")) {
            int n2;
            l2 = 2L;
            if (this.e == null) {
                try {
                    object = ParameterCache.getDHParameterSpec(this.d, this.i);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new ProviderException("Could not generate DH parameters", generalSecurityException);
                }
                n2 = 0;
            } else {
                object = (DHParameterSpec)this.e;
                n2 = ((DHParameterSpec)object).getL();
            }
            if (n2 <= 0) {
                n2 = this.d >= 1024 ? 768 : 512;
            }
            object3 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(304L, ((DHParameterSpec)object).getP()), new CK_ATTRIBUTE(306L, ((DHParameterSpec)object).getG())};
            object2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(352L, n2)};
        } else if (this.b.equals("EC")) {
            l2 = 3L;
            object = l.b((ECParameterSpec)this.e);
            object3 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(384L, object)};
            object2 = new CK_ATTRIBUTE[]{};
        } else {
            throw new ProviderException("Unknown algorithm: " + this.b);
        }
        object = null;
        try {
            Object object4 = this.a;
            object = ((G)object4).e.b();
            object3 = this.a.a("generate", 2L, l2, (CK_ATTRIBUTE[])object3);
            object2 = this.a.a("generate", 3L, l2, (CK_ATTRIBUTE[])object2);
            object4 = this.a.b.C_GenerateKeyPair(((C)object).a(), new CK_MECHANISM(this.c), (CK_ATTRIBUTE[])object3, (CK_ATTRIBUTE[])object2);
            object3 = n.b((C)object, (long)object4[0], this.b, this.d, object3);
            object2 = n.c((C)object, (long)object4[1], this.b, this.d, object2);
            object3 = new KeyPair((PublicKey)object3, (PrivateKey)object2);
            return object3;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException(pKCS11Exception);
        }
        finally {
            this.a.b((C)object);
        }
    }
}

