/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jsign.pkcs11;

import com.github.kwart.jsign.pkcs11.C;
import com.github.kwart.jsign.pkcs11.G;
import com.github.kwart.jsign.pkcs11.P11Util;
import com.github.kwart.jsign.pkcs11.n;
import com.github.kwart.jsign.pkcs11.p;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.DSAKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.security.auth.login.LoginException;
import sun.nio.ch.DirectBuffer;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_MECHANISM_INFO;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.rsa.RSAPadding;
import sun.security.rsa.RSASignature;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.KeyUtil;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

final class z
extends SignatureSpi {
    private final G a;
    private final String b;
    private final String c;
    private final long d;
    private final ObjectIdentifier e;
    private final int f;
    private n g;
    private final MessageDigest h;
    private C i;
    private int j;
    private boolean k;
    private final byte[] l;
    private int m;

    z(G object, String string, long l2) {
        this.a = object;
        this.b = string;
        this.d = l2;
        object = null;
        ObjectIdentifier objectIdentifier = null;
        MessageDigest messageDigest = null;
        switch ((int)l2) {
            case 4: 
            case 5: 
            case 6: 
            case 64: 
            case 65: 
            case 66: 
            case 70: {
                this.c = "RSA";
                this.f = 2;
                object = new byte[1];
                break;
            }
            case 18: {
                this.c = "DSA";
                this.f = 2;
                object = new byte[1];
                break;
            }
            case 4162: {
                this.c = "EC";
                this.f = 2;
                object = new byte[1];
                break;
            }
            case 17: {
                this.c = "DSA";
                if (string.equals("DSA")) {
                    this.f = 1;
                    messageDigest = MessageDigest.getInstance("SHA-1");
                    break;
                }
                if (string.equals("RawDSA")) {
                    this.f = 3;
                    object = new byte[20];
                    break;
                }
                throw new ProviderException(string);
            }
            case 4161: {
                this.c = "EC";
                if (string.equals("NONEwithECDSA")) {
                    this.f = 3;
                    object = new byte[128];
                    break;
                }
                if (string.equals("SHA1withECDSA")) {
                    string = "SHA-1";
                } else if (string.equals("SHA224withECDSA")) {
                    string = "SHA-224";
                } else if (string.equals("SHA256withECDSA")) {
                    string = "SHA-256";
                } else if (string.equals("SHA384withECDSA")) {
                    string = "SHA-384";
                } else if (string.equals("SHA512withECDSA")) {
                    string = "SHA-512";
                } else {
                    throw new ProviderException(string);
                }
                this.f = 1;
                messageDigest = MessageDigest.getInstance(string);
                break;
            }
            case 1: 
            case 3: {
                this.c = "RSA";
                this.f = 1;
                if (string.equals("MD5withRSA")) {
                    messageDigest = MessageDigest.getInstance("MD5");
                    objectIdentifier = AlgorithmId.MD5_oid;
                    break;
                }
                if (string.equals("SHA1withRSA")) {
                    messageDigest = MessageDigest.getInstance("SHA-1");
                    objectIdentifier = AlgorithmId.SHA_oid;
                    break;
                }
                if (string.equals("MD2withRSA")) {
                    messageDigest = MessageDigest.getInstance("MD2");
                    objectIdentifier = AlgorithmId.MD2_oid;
                    break;
                }
                if (string.equals("SHA224withRSA")) {
                    messageDigest = MessageDigest.getInstance("SHA-224");
                    objectIdentifier = AlgorithmId.SHA224_oid;
                    break;
                }
                if (string.equals("SHA256withRSA")) {
                    messageDigest = MessageDigest.getInstance("SHA-256");
                    objectIdentifier = AlgorithmId.SHA256_oid;
                    break;
                }
                if (string.equals("SHA384withRSA")) {
                    messageDigest = MessageDigest.getInstance("SHA-384");
                    objectIdentifier = AlgorithmId.SHA384_oid;
                    break;
                }
                if (string.equals("SHA512withRSA")) {
                    messageDigest = MessageDigest.getInstance("SHA-512");
                    objectIdentifier = AlgorithmId.SHA512_oid;
                    break;
                }
                throw new ProviderException("Unknown signature: " + string);
            }
            default: {
                throw new ProviderException("Unknown mechanism: " + l2);
            }
        }
        this.l = (byte[])object;
        this.e = objectIdentifier;
        this.h = messageDigest;
    }

    private void a(boolean bl2) {
        if (!this.k) {
            return;
        }
        this.k = false;
        try {
            block17: {
                if (this.i == null) {
                    return;
                }
                if (bl2 && this.a.f) {
                    z z2 = this;
                    z2.a.d();
                    try {
                        if (z2.j == 1) {
                            if (z2.f == 2) {
                                z2.a.b.C_SignFinal(z2.i.a(), 0);
                            } else {
                                byte[] byArray = z2.f == 1 ? z2.h.digest() : z2.l;
                                z2.a.b.C_Sign(z2.i.a(), byArray);
                            }
                        } else {
                            byte[] byArray = z2.c.equals("DSA") ? new byte[40] : new byte[z2.g.length() + 7 >> 3];
                            if (z2.f == 2) {
                                z2.a.b.C_VerifyFinal(z2.i.a(), byArray);
                            } else {
                                byte[] byArray2 = z2.f == 1 ? z2.h.digest() : z2.l;
                                z2.a.b.C_Verify(z2.i.a(), byArray2, byArray);
                            }
                        }
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        PKCS11Exception pKCS11Exception2 = pKCS11Exception;
                        if (pKCS11Exception.getErrorCode() == 145L) break block17;
                        if (z2.j == 2) {
                            long l2 = pKCS11Exception2.getErrorCode();
                            if (l2 == 192L) break block17;
                            if (l2 == 193L) {
                            }
                        }
                        throw new ProviderException("cancel failed", pKCS11Exception2);
                    }
                }
            }
            return;
        }
        finally {
            this.g.b();
            this.i = this.a.b(this.i);
        }
    }

    private void a() {
        if (!this.k) {
            this.b();
        }
    }

    private void b() {
        if (this.g == null) {
            throw new ProviderException("Operation cannot be performed without calling engineInit first");
        }
        long l2 = this.g.a();
        try {
            this.a.d();
            if (this.i == null) {
                G g2 = this.a;
                this.i = g2.e.c();
            }
            if (this.j == 1) {
                this.a.b.C_SignInit(this.i.a(), new CK_MECHANISM(this.d), l2);
            } else {
                this.a.b.C_VerifyInit(this.i.a(), new CK_MECHANISM(this.d), l2);
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.g.b();
            this.i = this.a.b(this.i);
            throw new ProviderException("Initialization failed", pKCS11Exception);
        }
        if (this.m != 0) {
            this.m = 0;
            if (this.h != null) {
                this.h.reset();
            }
        }
        this.k = true;
    }

    private void a(String object, Key key) {
        int n2;
        int n3;
        int n4;
        block29: {
            CK_MECHANISM_INFO cK_MECHANISM_INFO = null;
            try {
                cK_MECHANISM_INFO = this.a.b(this.d);
            }
            catch (PKCS11Exception pKCS11Exception) {}
            if (cK_MECHANISM_INFO == null) {
                return;
            }
            n4 = (int)cK_MECHANISM_INFO.ulMinKeySize;
            n3 = (int)cK_MECHANISM_INFO.ulMaxKeySize;
            if (this.h != null && this.d == 17L && n3 > 1024) {
                n3 = 1024;
            }
            if (key instanceof n) {
                n2 = ((n)key).length();
            } else {
                try {
                    if (((String)object).equals("RSA")) {
                        n2 = ((RSAKey)((Object)key)).getModulus().bitLength();
                        break block29;
                    }
                    if (((String)object).equals("DSA")) {
                        n2 = ((DSAKey)((Object)key)).getParams().getP().bitLength();
                        break block29;
                    }
                    if (((String)object).equals("EC")) {
                        n2 = ((ECKey)((Object)key)).getParams().getCurve().getField().getFieldSize();
                        break block29;
                    }
                    throw new ProviderException("Error: unsupported algo " + (String)object);
                }
                catch (ClassCastException classCastException) {
                    throw new InvalidKeyException((String)object + " key must be the right type", classCastException);
                }
            }
        }
        if (n4 != -1 && n2 < n4) {
            throw new InvalidKeyException((String)object + " key must be at least " + n4 + " bits");
        }
        if (n3 != -1 && n2 > n3) {
            throw new InvalidKeyException((String)object + " key must be at most " + n3 + " bits");
        }
        if (((String)object).equals("RSA")) {
            int n5;
            RSAPadding rSAPadding;
            object = this;
            try {
                rSAPadding = RSAPadding.getInstance(1, n2 + 7 >> 3);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
            }
            int n6 = rSAPadding.getMaxDataSize();
            if (((z)object).b.equals("MD5withRSA") || ((z)object).b.equals("MD2withRSA")) {
                n5 = 34;
            } else if (((z)object).b.equals("SHA1withRSA")) {
                n5 = 35;
            } else if (((z)object).b.equals("SHA224withRSA")) {
                n5 = 47;
            } else if (((z)object).b.equals("SHA256withRSA")) {
                n5 = 51;
            } else if (((z)object).b.equals("SHA384withRSA")) {
                n5 = 67;
            } else if (((z)object).b.equals("SHA512withRSA")) {
                n5 = 83;
            } else {
                throw new ProviderException("Unknown signature algo: " + ((z)object).b);
            }
            if (n5 > n6) {
                throw new InvalidKeyException("Key is too short for this signature algorithm");
            }
        }
    }

    @Override
    protected final void engineInitVerify(PublicKey publicKey) {
        if (publicKey == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        if (publicKey != this.g) {
            z z2 = this;
            z2.a(z2.c, publicKey);
        }
        this.a(true);
        this.j = 2;
        this.g = p.a(this.a, publicKey, this.c);
        this.b();
    }

    @Override
    protected final void engineInitSign(PrivateKey privateKey) {
        if (privateKey == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        if (privateKey != this.g) {
            z z2 = this;
            z2.a(z2.c, privateKey);
        }
        this.a(true);
        this.j = 1;
        this.g = p.a(this.a, privateKey, this.c);
        this.b();
    }

    @Override
    protected final void engineUpdate(byte by) {
        this.a();
        switch (this.f) {
            case 2: {
                this.l[0] = by;
                z z2 = this;
                z2.engineUpdate(z2.l, 0, 1);
                return;
            }
            case 1: {
                this.h.update(by);
                ++this.m;
                return;
            }
            case 3: {
                if (this.m >= this.l.length) {
                    this.m = this.l.length + 1;
                    return;
                }
                this.l[this.m++] = by;
                return;
            }
        }
        throw new ProviderException("Internal error");
    }

    @Override
    protected final void engineUpdate(byte[] byArray, int n2, int n3) {
        this.a();
        if (n3 == 0) {
            return;
        }
        if (n3 + this.m < 0) {
            throw new ProviderException("Processed bytes limits exceeded.");
        }
        switch (this.f) {
            case 2: {
                try {
                    if (this.j == 1) {
                        this.a.b.C_SignUpdate(this.i.a(), 0L, byArray, n2, n3);
                    } else {
                        this.a.b.C_VerifyUpdate(this.i.a(), 0L, byArray, n2, n3);
                    }
                    this.m += n3;
                    return;
                }
                catch (PKCS11Exception pKCS11Exception) {
                    this.a(false);
                    throw new ProviderException(pKCS11Exception);
                }
            }
            case 1: {
                this.h.update(byArray, n2, n3);
                this.m += n3;
                return;
            }
            case 3: {
                if (this.m + n3 > this.l.length) {
                    this.m = this.l.length + 1;
                    return;
                }
                System.arraycopy(byArray, n2, this.l, this.m, n3);
                this.m += n3;
                return;
            }
        }
        throw new ProviderException("Internal error");
    }

    @Override
    protected final void engineUpdate(ByteBuffer byteBuffer) {
        this.a();
        int n2 = byteBuffer.remaining();
        if (n2 <= 0) {
            return;
        }
        switch (this.f) {
            case 2: {
                if (!(byteBuffer instanceof DirectBuffer)) {
                    super.engineUpdate(byteBuffer);
                    return;
                }
                long l2 = ((DirectBuffer)((Object)byteBuffer)).address();
                int n3 = byteBuffer.position();
                try {
                    if (this.j == 1) {
                        this.a.b.C_SignUpdate(this.i.a(), l2 + (long)n3, null, 0, n2);
                    } else {
                        this.a.b.C_VerifyUpdate(this.i.a(), l2 + (long)n3, null, 0, n2);
                    }
                    this.m += n2;
                    byteBuffer.position(n3 + n2);
                    return;
                }
                catch (PKCS11Exception pKCS11Exception) {
                    this.a(false);
                    throw new ProviderException("Update failed", pKCS11Exception);
                }
            }
            case 1: {
                this.h.update(byteBuffer);
                this.m += n2;
                return;
            }
            case 3: {
                if (this.m + n2 > this.l.length) {
                    this.m = this.l.length + 1;
                    return;
                }
                byteBuffer.get(this.l, this.m, n2);
                this.m += n2;
                return;
            }
        }
        this.a(false);
        throw new ProviderException("Internal error");
    }

    @Override
    protected final byte[] engineSign() {
        this.a();
        try {
            this.a.a.a(this.i.a());
        }
        catch (LoginException loginException) {
            LoginException loginException2 = loginException;
            loginException.printStackTrace();
        }
        boolean bl2 = true;
        try {
            byte[] byArray;
            if (this.f == 2) {
                int n2 = this.c.equals("DSA") ? 40 : 0;
                byArray = this.a.b.C_SignFinal(this.i.a(), n2);
            } else {
                if (this.f == 1) {
                    byArray = this.h.digest();
                } else if (this.d == 17L) {
                    if (this.m != this.l.length) {
                        throw new SignatureException("Data for RawDSA must be exactly 20 bytes long");
                    }
                    byArray = this.l;
                } else {
                    if (this.m > this.l.length) {
                        throw new SignatureException("Data for NONEwithECDSA must be at most 128 bytes long");
                    }
                    byArray = new byte[this.m];
                    System.arraycopy(this.l, 0, byArray, 0, this.m);
                }
                if (!this.c.equals("RSA")) {
                    byArray = this.a.b.C_Sign(this.i.a(), byArray);
                } else {
                    byArray = this.b(byArray);
                    if (this.d == 3L) {
                        byArray = this.a(byArray);
                    }
                    byArray = this.a.b.C_Sign(this.i.a(), byArray);
                }
            }
            bl2 = false;
            if (!this.c.equals("RSA")) {
                byArray = z.c(byArray);
                this.a(false);
                return byArray;
            }
            this.a(false);
            return byArray;
        }
        catch (PKCS11Exception pKCS11Exception) {
            try {
                bl2 = false;
                throw new ProviderException(pKCS11Exception);
            }
            catch (Throwable throwable) {
                this.a(bl2);
                throw throwable;
            }
        }
    }

    @Override
    protected final boolean engineVerify(byte[] byArray) {
        this.a();
        boolean bl2 = true;
        try {
            if (this.c.equals("DSA")) {
                byArray = z.d(byArray);
            } else if (this.c.equals("EC")) {
                byArray = z.e(byArray);
            }
            if (this.f == 2) {
                this.a.b.C_VerifyFinal(this.i.a(), byArray);
            } else {
                byte[] byArray2;
                if (this.f == 1) {
                    byArray2 = this.h.digest();
                } else if (this.d == 17L) {
                    if (this.m != this.l.length) {
                        throw new SignatureException("Data for RawDSA must be exactly 20 bytes long");
                    }
                    byArray2 = this.l;
                } else {
                    if (this.m > this.l.length) {
                        throw new SignatureException("Data for NONEwithECDSA must be at most 128 bytes long");
                    }
                    byArray2 = new byte[this.m];
                    System.arraycopy(this.l, 0, byArray2, 0, this.m);
                }
                if (!this.c.equals("RSA")) {
                    this.a.b.C_Verify(this.i.a(), byArray2, byArray);
                } else {
                    byte[] byArray3 = this.b(byArray2);
                    if (this.d == 3L) {
                        byArray3 = this.a(byArray3);
                    }
                    this.a.b.C_Verify(this.i.a(), byArray3, byArray);
                }
            }
            bl2 = false;
            this.a(false);
            return true;
        }
        catch (PKCS11Exception pKCS11Exception) {
            block21: {
                try {
                    bl2 = false;
                    long l2 = pKCS11Exception.getErrorCode();
                    if (l2 == 192L) {
                        this.a(false);
                        return false;
                    }
                    if (l2 == 193L) {
                        this.a(false);
                        return false;
                    }
                    if (l2 != 33L) break block21;
                    this.a(false);
                    return false;
                }
                catch (Throwable throwable) {
                    this.a(bl2);
                    throw throwable;
                }
            }
            throw new ProviderException(pKCS11Exception);
        }
    }

    private byte[] a(byte[] byArray) {
        try {
            int n2 = this.g.length() + 7 >> 3;
            RSAPadding rSAPadding = RSAPadding.getInstance(1, n2);
            byArray = rSAPadding.pad(byArray);
            return byArray;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ProviderException(generalSecurityException);
        }
    }

    private byte[] b(byte[] byArray) {
        try {
            return RSASignature.encodeSignature((ObjectIdentifier)this.e, (byte[])byArray);
        }
        catch (IOException iOException) {
            throw new SignatureException("Invalid encoding", iOException);
        }
    }

    private static byte[] c(byte[] object) {
        int n2 = ((byte[])object).length >> 1;
        BigInteger bigInteger = new BigInteger(1, P11Util.b(object, 0, n2));
        int n3 = n2;
        object = new BigInteger(1, P11Util.b(object, n3, n3));
        try {
            DerOutputStream derOutputStream = new DerOutputStream(100);
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger((BigInteger)object);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            object = derValue;
            return derValue.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Internal error", iOException);
        }
    }

    private static byte[] d(byte[] object) {
        try {
            DerInputStream derInputStream = new DerInputStream((byte[])object, 0, ((byte[])object).length, false);
            object = derInputStream;
            Object object2 = derInputStream.getSequence(2);
            if (((DerValue[])object2).length != 2 || object.available() != 0) {
                throw new IOException("Invalid encoding for signature");
            }
            object = object2[0].getPositiveBigInteger();
            object2 = object2[1].getPositiveBigInteger();
            object = z.a((BigInteger)object, 20);
            object2 = z.a((BigInteger)object2, 20);
            if (object == null || object2 == null) {
                throw new SignatureException("Out of range value for R or S");
            }
            return P11Util.a(object, (byte[])object2);
        }
        catch (SignatureException signatureException) {
            object = signatureException;
            throw signatureException;
        }
        catch (Exception exception) {
            throw new SignatureException("Invalid encoding for signature", exception);
        }
    }

    private static byte[] e(byte[] object) {
        try {
            DerInputStream derInputStream = new DerInputStream((byte[])object, 0, ((byte[])object).length, false);
            object = derInputStream;
            Object object2 = derInputStream.getSequence(2);
            if (((DerValue[])object2).length != 2 || object.available() != 0) {
                throw new IOException("Invalid encoding for signature");
            }
            object = object2[0].getPositiveBigInteger();
            object2 = object2[1].getPositiveBigInteger();
            object = KeyUtil.trimZeroes(object.toByteArray());
            object2 = KeyUtil.trimZeroes(object2.toByteArray());
            int n2 = Math.max(((byte[])object).length, ((DerValue[])object2).length);
            byte[] byArray = new byte[n2 << 1];
            System.arraycopy(object, 0, byArray, n2 - ((byte[])object).length, ((byte[])object).length);
            System.arraycopy(object2, 0, byArray, byArray.length - ((DerValue[])object2).length, ((DerValue[])object2).length);
            return byArray;
        }
        catch (Exception exception) {
            throw new SignatureException("Invalid encoding for signature", exception);
        }
    }

    private static byte[] a(BigInteger object, int n2) {
        byte[] byArray = ((BigInteger)object).toByteArray();
        object = byArray;
        n2 = byArray.length;
        if (n2 == 20) {
            return object;
        }
        if (n2 == 21 && object[0] == false) {
            byte[] byArray2 = new byte[20];
            System.arraycopy(object, 1, byArray2, 0, 20);
            return byArray2;
        }
        if (n2 > 20) {
            return null;
        }
        byte[] byArray3 = new byte[20];
        System.arraycopy(object, 0, byArray3, 20 - n2, n2);
        return byArray3;
    }

    @Override
    protected final void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    @Override
    protected final void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("No parameter accepted");
        }
    }

    @Override
    protected final Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("getParameter() not supported");
    }

    @Override
    protected final AlgorithmParameters engineGetParameters() {
        return null;
    }
}

