/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import a.a.a.g;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonSyntaxException;
import com.google.gson.LongSerializationPolicy;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.Excluder;
import com.google.gson.internal.Primitives;
import com.google.gson.internal.Streams;
import com.google.gson.internal.bind.ArrayTypeAdapter;
import com.google.gson.internal.bind.CollectionTypeAdapterFactory;
import com.google.gson.internal.bind.DateTypeAdapter;
import com.google.gson.internal.bind.JsonAdapterAnnotationTypeAdapterFactory;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.internal.bind.JsonTreeWriter;
import com.google.gson.internal.bind.MapTypeAdapterFactory;
import com.google.gson.internal.bind.NumberTypeAdapter;
import com.google.gson.internal.bind.ObjectTypeAdapter;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.internal.sql.SqlTypesSupport;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.gson.stream.MalformedJsonException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public class Gson {
    public static final boolean DEFAULT_JSON_NON_EXECUTABLE = false;
    public static final boolean DEFAULT_LENIENT = false;
    public static final boolean DEFAULT_PRETTY_PRINT = false;
    public static final boolean DEFAULT_ESCAPE_HTML = true;
    public static final boolean DEFAULT_SERIALIZE_NULLS = false;
    public static final boolean DEFAULT_COMPLEX_MAP_KEYS = false;
    public static final boolean DEFAULT_SPECIALIZE_FLOAT_VALUES = false;
    public static final TypeToken<?> NULL_KEY_SURROGATE = TypeToken.get(Object.class);
    public static final String JSON_NON_EXECUTABLE_PREFIX = ")]}'\n";
    public final ThreadLocal<Map<TypeToken<?>, FutureTypeAdapter<?>>> calls;
    public final Map<TypeToken<?>, TypeAdapter<?>> typeTokenCache;
    public final ConstructorConstructor constructorConstructor;
    public final JsonAdapterAnnotationTypeAdapterFactory jsonAdapterFactory;
    public final List<TypeAdapterFactory> factories;
    public final Excluder excluder;
    public final FieldNamingStrategy fieldNamingStrategy;
    public final Map<Type, InstanceCreator<?>> instanceCreators;
    public final boolean serializeNulls;
    public final boolean complexMapKeySerialization;
    public final boolean generateNonExecutableJson;
    public final boolean htmlSafe;
    public final boolean prettyPrinting;
    public final boolean lenient;
    public final boolean serializeSpecialFloatingPointValues;
    public final String datePattern;
    public final int dateStyle;
    public final int timeStyle;
    public final LongSerializationPolicy longSerializationPolicy;
    public final List<TypeAdapterFactory> builderFactories;
    public final List<TypeAdapterFactory> builderHierarchyFactories;
    public final ToNumberStrategy objectToNumberStrategy;
    public final ToNumberStrategy numberToNumberStrategy;

    public Gson() {
        this(Excluder.DEFAULT, FieldNamingPolicy.IDENTITY, Collections.emptyMap(), false, false, false, true, false, false, false, LongSerializationPolicy.DEFAULT, null, 2, 2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), ToNumberPolicy.DOUBLE, ToNumberPolicy.LAZILY_PARSED_NUMBER);
    }

    Gson(Excluder excluder, FieldNamingStrategy fieldNamingStrategy, Map<Type, InstanceCreator<?>> object, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, LongSerializationPolicy longSerializationPolicy, String string, int n2, int n3, List<TypeAdapterFactory> list, List<TypeAdapterFactory> list2, List<TypeAdapterFactory> list3, ToNumberStrategy toNumberStrategy, ToNumberStrategy toNumberStrategy2) {
        list3 = new ArrayList<TypeAdapterFactory>(list3);
        list3.add(new g());
        this.calls = new ThreadLocal();
        this.typeTokenCache = new ConcurrentHashMap();
        this.excluder = excluder;
        this.fieldNamingStrategy = fieldNamingStrategy;
        this.instanceCreators = object;
        this.constructorConstructor = new ConstructorConstructor((Map<Type, InstanceCreator<?>>)object);
        this.serializeNulls = bl2;
        this.complexMapKeySerialization = bl3;
        this.generateNonExecutableJson = bl4;
        this.htmlSafe = bl5;
        this.prettyPrinting = bl6;
        this.lenient = bl7;
        this.serializeSpecialFloatingPointValues = bl8;
        this.longSerializationPolicy = longSerializationPolicy;
        this.datePattern = string;
        this.dateStyle = n2;
        this.timeStyle = n3;
        this.builderFactories = list;
        this.builderHierarchyFactories = list2;
        this.objectToNumberStrategy = toNumberStrategy;
        this.numberToNumberStrategy = toNumberStrategy2;
        object = new ArrayList<TypeAdapterFactory>();
        object.add(TypeAdapters.JSON_ELEMENT_FACTORY);
        object.add(ObjectTypeAdapter.getFactory(toNumberStrategy));
        object.add(excluder);
        object.addAll(list3);
        object.add(TypeAdapters.STRING_FACTORY);
        object.add(TypeAdapters.INTEGER_FACTORY);
        object.add(TypeAdapters.BOOLEAN_FACTORY);
        object.add(TypeAdapters.BYTE_FACTORY);
        object.add(TypeAdapters.SHORT_FACTORY);
        TypeAdapter<Number> typeAdapter = Gson.longAdapter(longSerializationPolicy);
        object.add(TypeAdapters.newFactory(Long.TYPE, Long.class, typeAdapter));
        object.add(TypeAdapters.newFactory(Double.TYPE, Double.class, this.doubleAdapter(bl8)));
        object.add(TypeAdapters.newFactory(Float.TYPE, Float.class, this.floatAdapter(bl8)));
        object.add(NumberTypeAdapter.getFactory(toNumberStrategy2));
        object.add(TypeAdapters.ATOMIC_INTEGER_FACTORY);
        object.add(TypeAdapters.ATOMIC_BOOLEAN_FACTORY);
        object.add(TypeAdapters.newFactory(AtomicLong.class, Gson.atomicLongAdapter(typeAdapter)));
        object.add(TypeAdapters.newFactory(AtomicLongArray.class, Gson.atomicLongArrayAdapter(typeAdapter)));
        object.add(TypeAdapters.ATOMIC_INTEGER_ARRAY_FACTORY);
        object.add(TypeAdapters.CHARACTER_FACTORY);
        object.add(TypeAdapters.STRING_BUILDER_FACTORY);
        object.add(TypeAdapters.STRING_BUFFER_FACTORY);
        object.add(TypeAdapters.newFactory(BigDecimal.class, TypeAdapters.BIG_DECIMAL));
        object.add(TypeAdapters.newFactory(BigInteger.class, TypeAdapters.BIG_INTEGER));
        object.add(TypeAdapters.URL_FACTORY);
        object.add(TypeAdapters.URI_FACTORY);
        object.add(TypeAdapters.UUID_FACTORY);
        object.add(TypeAdapters.CURRENCY_FACTORY);
        object.add(TypeAdapters.LOCALE_FACTORY);
        object.add(TypeAdapters.INET_ADDRESS_FACTORY);
        object.add(TypeAdapters.BIT_SET_FACTORY);
        object.add(DateTypeAdapter.FACTORY);
        object.add(TypeAdapters.CALENDAR_FACTORY);
        if (SqlTypesSupport.SUPPORTS_SQL_TYPES) {
            object.add(SqlTypesSupport.TIME_FACTORY);
            object.add(SqlTypesSupport.DATE_FACTORY);
            object.add(SqlTypesSupport.TIMESTAMP_FACTORY);
        }
        object.add(ArrayTypeAdapter.FACTORY);
        object.add(TypeAdapters.CLASS_FACTORY);
        object.add(new CollectionTypeAdapterFactory(this.constructorConstructor));
        object.add(new MapTypeAdapterFactory(this.constructorConstructor, bl3));
        this.jsonAdapterFactory = new JsonAdapterAnnotationTypeAdapterFactory(this.constructorConstructor);
        object.add(this.jsonAdapterFactory);
        object.add(TypeAdapters.ENUM_FACTORY);
        object.add(new ReflectiveTypeAdapterFactory(this.constructorConstructor, fieldNamingStrategy, excluder, this.jsonAdapterFactory));
        this.factories = Collections.unmodifiableList(object);
    }

    public GsonBuilder newBuilder() {
        return new GsonBuilder(this);
    }

    @Deprecated
    public Excluder excluder() {
        return this.excluder;
    }

    public FieldNamingStrategy fieldNamingStrategy() {
        return this.fieldNamingStrategy;
    }

    public boolean serializeNulls() {
        return this.serializeNulls;
    }

    public boolean htmlSafe() {
        return this.htmlSafe;
    }

    private TypeAdapter<Number> doubleAdapter(boolean bl2) {
        if (bl2) {
            return TypeAdapters.DOUBLE;
        }
        return new TypeAdapter<Number>(){

            @Override
            public Double read(JsonReader jsonReader) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return jsonReader.nextDouble();
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) {
                if (number == null) {
                    jsonWriter.nullValue();
                    return;
                }
                double d2 = number.doubleValue();
                Gson.checkValidFloatingPoint(d2);
                jsonWriter.value(number);
            }
        };
    }

    private TypeAdapter<Number> floatAdapter(boolean bl2) {
        if (bl2) {
            return TypeAdapters.FLOAT;
        }
        return new TypeAdapter<Number>(){

            @Override
            public Float read(JsonReader jsonReader) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return Float.valueOf((float)jsonReader.nextDouble());
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) {
                if (number == null) {
                    jsonWriter.nullValue();
                    return;
                }
                float f2 = number.floatValue();
                Gson.checkValidFloatingPoint(f2);
                jsonWriter.value(number);
            }
        };
    }

    static void checkValidFloatingPoint(double d2) {
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            throw new IllegalArgumentException(d2 + " is not a valid double value as per JSON specification. To override this behavior, use GsonBuilder.serializeSpecialFloatingPointValues() method.");
        }
    }

    private static TypeAdapter<Number> longAdapter(LongSerializationPolicy longSerializationPolicy) {
        if (longSerializationPolicy == LongSerializationPolicy.DEFAULT) {
            return TypeAdapters.LONG;
        }
        return new TypeAdapter<Number>(){

            @Override
            public Number read(JsonReader jsonReader) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return jsonReader.nextLong();
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) {
                if (number == null) {
                    jsonWriter.nullValue();
                    return;
                }
                jsonWriter.value(number.toString());
            }
        };
    }

    private static TypeAdapter<AtomicLong> atomicLongAdapter(final TypeAdapter<Number> typeAdapter) {
        return new TypeAdapter<AtomicLong>(){

            @Override
            public void write(JsonWriter jsonWriter, AtomicLong atomicLong) {
                typeAdapter.write(jsonWriter, atomicLong.get());
            }

            @Override
            public AtomicLong read(JsonReader object) {
                object = (Number)typeAdapter.read((JsonReader)object);
                return new AtomicLong(((Number)object).longValue());
            }
        }.nullSafe();
    }

    private static TypeAdapter<AtomicLongArray> atomicLongArrayAdapter(final TypeAdapter<Number> typeAdapter) {
        return new TypeAdapter<AtomicLongArray>(){

            @Override
            public void write(JsonWriter jsonWriter, AtomicLongArray atomicLongArray) {
                jsonWriter.beginArray();
                int n2 = atomicLongArray.length();
                for (int i2 = 0; i2 < n2; ++i2) {
                    typeAdapter.write(jsonWriter, atomicLongArray.get(i2));
                }
                jsonWriter.endArray();
            }

            @Override
            public AtomicLongArray read(JsonReader jsonReader) {
                ArrayList<Long> arrayList = new ArrayList<Long>();
                jsonReader.beginArray();
                while (jsonReader.hasNext()) {
                    long l2 = ((Number)typeAdapter.read(jsonReader)).longValue();
                    arrayList.add(l2);
                }
                jsonReader.endArray();
                int n2 = arrayList.size();
                AtomicLongArray atomicLongArray = new AtomicLongArray(n2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    atomicLongArray.set(i2, (Long)arrayList.get(i2));
                }
                return atomicLongArray;
            }
        }.nullSafe();
    }

    public <T> TypeAdapter<T> getAdapter(TypeToken<T> typeToken) {
        TypeAdapter object;
        Object object2 = this.typeTokenCache.get(typeToken == null ? NULL_KEY_SURROGATE : typeToken);
        if (object2 != null) {
            return object2;
        }
        object2 = this.calls.get();
        boolean bl2 = false;
        if (object2 == null) {
            object2 = new HashMap();
            this.calls.set((Map<TypeToken<?>, FutureTypeAdapter<?>>)object2);
            bl2 = true;
        }
        if ((object = (FutureTypeAdapter<T>)object2.get(typeToken)) != null) {
            return object;
        }
        try {
            object = new FutureTypeAdapter<T>();
            object2.put(typeToken, object);
            for (TypeAdapterFactory typeAdapterFactory : this.factories) {
                TypeAdapter<T> object3 = typeAdapterFactory.create(this, typeToken);
                if (object3 == null) continue;
                object.setDelegate(object3);
                this.typeTokenCache.put(typeToken, object3);
                object = object3;
                return object;
            }
            throw new IllegalArgumentException("GSON (2.8.9) cannot handle " + typeToken);
        }
        finally {
            object2.remove(typeToken);
            if (bl2) {
                this.calls.remove();
            }
        }
    }

    public <T> TypeAdapter<T> getDelegateAdapter(TypeAdapterFactory typeAdapterFactory, TypeToken<T> typeToken) {
        if (!this.factories.contains(typeAdapterFactory)) {
            typeAdapterFactory = this.jsonAdapterFactory;
        }
        boolean bl2 = false;
        for (TypeAdapterFactory typeAdapterFactory2 : this.factories) {
            if (!bl2) {
                if (typeAdapterFactory2 != typeAdapterFactory) continue;
                bl2 = true;
                continue;
            }
            TypeAdapter<T> typeAdapter = typeAdapterFactory2.create(this, typeToken);
            if (typeAdapter == null) continue;
            return typeAdapter;
        }
        throw new IllegalArgumentException("GSON cannot serialize " + typeToken);
    }

    public <T> TypeAdapter<T> getAdapter(Class<T> clazz) {
        return this.getAdapter(TypeToken.get(clazz));
    }

    public JsonElement toJsonTree(Object object) {
        if (object == null) {
            return JsonNull.INSTANCE;
        }
        Object object2 = object;
        return this.toJsonTree(object2, object2.getClass());
    }

    public JsonElement toJsonTree(Object object, Type type) {
        JsonTreeWriter jsonTreeWriter = new JsonTreeWriter();
        this.toJson(object, type, jsonTreeWriter);
        return jsonTreeWriter.get();
    }

    public String toJson(Object object) {
        if (object == null) {
            return this.toJson(JsonNull.INSTANCE);
        }
        Object object2 = object;
        return this.toJson(object2, object2.getClass());
    }

    public String toJson(Object object, Type type) {
        StringWriter stringWriter = new StringWriter();
        this.toJson(object, type, stringWriter);
        return stringWriter.toString();
    }

    public void toJson(Object object, Appendable appendable) {
        if (object != null) {
            Object object2 = object;
            this.toJson(object2, object2.getClass(), appendable);
            return;
        }
        this.toJson((JsonElement)JsonNull.INSTANCE, appendable);
    }

    public void toJson(Object object, Type type, Appendable object2) {
        try {
            object2 = this.newJsonWriter(Streams.writerForAppendable((Appendable)object2));
            this.toJson(object, type, (JsonWriter)object2);
            return;
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
    }

    public void toJson(Object object, Type object2, JsonWriter jsonWriter) {
        object2 = this.getAdapter(TypeToken.get((Type)object2));
        boolean bl2 = jsonWriter.isLenient();
        jsonWriter.setLenient(true);
        boolean bl3 = jsonWriter.isHtmlSafe();
        jsonWriter.setHtmlSafe(this.htmlSafe);
        boolean bl4 = jsonWriter.getSerializeNulls();
        jsonWriter.setSerializeNulls(this.serializeNulls);
        try {
            ((TypeAdapter)object2).write(jsonWriter, object);
            return;
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        catch (AssertionError assertionError) {
            object2 = new AssertionError((Object)("AssertionError (GSON 2.8.9): " + ((Throwable)((Object)assertionError)).getMessage()));
            ((Throwable)object2).initCause((Throwable)((Object)assertionError));
            throw object2;
        }
        finally {
            jsonWriter.setLenient(bl2);
            jsonWriter.setHtmlSafe(bl3);
            jsonWriter.setSerializeNulls(bl4);
        }
    }

    public String toJson(JsonElement jsonElement) {
        StringWriter stringWriter = new StringWriter();
        this.toJson(jsonElement, (Appendable)stringWriter);
        return stringWriter.toString();
    }

    public void toJson(JsonElement jsonElement, Appendable object) {
        try {
            object = this.newJsonWriter(Streams.writerForAppendable((Appendable)object));
            this.toJson(jsonElement, (JsonWriter)object);
            return;
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
    }

    public JsonWriter newJsonWriter(Writer closeable) {
        if (this.generateNonExecutableJson) {
            ((Writer)closeable).write(JSON_NON_EXECUTABLE_PREFIX);
        }
        closeable = new JsonWriter((Writer)closeable);
        if (this.prettyPrinting) {
            ((JsonWriter)closeable).setIndent("  ");
        }
        ((JsonWriter)closeable).setSerializeNulls(this.serializeNulls);
        return closeable;
    }

    public JsonReader newJsonReader(Reader closeable) {
        closeable = new JsonReader((Reader)closeable);
        ((JsonReader)closeable).setLenient(this.lenient);
        return closeable;
    }

    public void toJson(JsonElement jsonElement, JsonWriter jsonWriter) {
        boolean bl2 = jsonWriter.isLenient();
        jsonWriter.setLenient(true);
        boolean bl3 = jsonWriter.isHtmlSafe();
        jsonWriter.setHtmlSafe(this.htmlSafe);
        boolean bl4 = jsonWriter.getSerializeNulls();
        jsonWriter.setSerializeNulls(this.serializeNulls);
        try {
            Streams.write(jsonElement, jsonWriter);
            return;
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        catch (AssertionError assertionError) {
            AssertionError assertionError2 = new AssertionError((Object)("AssertionError (GSON 2.8.9): " + ((Throwable)((Object)assertionError)).getMessage()));
            ((Throwable)((Object)assertionError2)).initCause((Throwable)((Object)assertionError));
            throw assertionError2;
        }
        finally {
            jsonWriter.setLenient(bl2);
            jsonWriter.setHtmlSafe(bl3);
            jsonWriter.setSerializeNulls(bl4);
        }
    }

    public <T> T fromJson(String string, Class<T> clazz) {
        string = this.fromJson(string, (Type)clazz);
        return Primitives.wrap(clazz).cast(string);
    }

    public <T> T fromJson(String object, Type type) {
        if (object == null) {
            return null;
        }
        object = new StringReader((String)object);
        object = this.fromJson((Reader)object, type);
        return (T)object;
    }

    public <T> T fromJson(Reader closeable, Class<T> clazz) {
        closeable = this.newJsonReader((Reader)closeable);
        T t2 = this.fromJson((JsonReader)closeable, clazz);
        Gson.assertFullConsumption(t2, (JsonReader)closeable);
        return Primitives.wrap(clazz).cast(t2);
    }

    public <T> T fromJson(Reader closeable, Type type) {
        closeable = this.newJsonReader((Reader)closeable);
        type = this.fromJson((JsonReader)closeable, type);
        Gson.assertFullConsumption(type, (JsonReader)closeable);
        return (T)type;
    }

    private static void assertFullConsumption(Object object, JsonReader jsonReader) {
        try {
            if (object != null && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonIOException("JSON document was not fully consumed.");
            }
            return;
        }
        catch (MalformedJsonException malformedJsonException) {
            throw new JsonSyntaxException(malformedJsonException);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
    }

    public <T> T fromJson(JsonReader jsonReader, Type object) {
        boolean bl2 = true;
        boolean bl3 = jsonReader.isLenient();
        jsonReader.setLenient(true);
        try {
            jsonReader.peek();
            bl2 = false;
            object = TypeToken.get((Type)object);
            TypeAdapter<T> typeAdapter = this.getAdapter((TypeToken<T>)object);
            object = typeAdapter.read(jsonReader);
            return (T)object;
        }
        catch (EOFException eOFException) {
            if (bl2) {
                return null;
            }
            throw new JsonSyntaxException(eOFException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new JsonSyntaxException(illegalStateException);
        }
        catch (IOException iOException) {
            throw new JsonSyntaxException(iOException);
        }
        catch (AssertionError assertionError) {
            AssertionError assertionError2 = new AssertionError((Object)("AssertionError (GSON 2.8.9): " + ((Throwable)((Object)assertionError)).getMessage()));
            ((Throwable)((Object)assertionError2)).initCause((Throwable)((Object)assertionError));
            throw assertionError2;
        }
        finally {
            jsonReader.setLenient(bl3);
        }
    }

    public <T> T fromJson(JsonElement jsonElement, Class<T> clazz) {
        jsonElement = this.fromJson(jsonElement, (Type)clazz);
        return Primitives.wrap(clazz).cast(jsonElement);
    }

    public <T> T fromJson(JsonElement jsonElement, Type type) {
        if (jsonElement == null) {
            return null;
        }
        return this.fromJson(new JsonTreeReader(jsonElement), type);
    }

    public String toString() {
        return "{serializeNulls:" + this.serializeNulls + ",factories:" + this.factories + ",instanceCreators:" + this.constructorConstructor + "}";
    }

    static class FutureTypeAdapter<T>
    extends TypeAdapter<T> {
        private TypeAdapter<T> delegate;

        FutureTypeAdapter() {
        }

        public void setDelegate(TypeAdapter<T> typeAdapter) {
            if (this.delegate != null) {
                throw new AssertionError();
            }
            this.delegate = typeAdapter;
        }

        @Override
        public T read(JsonReader jsonReader) {
            if (this.delegate == null) {
                throw new IllegalStateException();
            }
            return this.delegate.read(jsonReader);
        }

        @Override
        public void write(JsonWriter jsonWriter, T t2) {
            if (this.delegate == null) {
                throw new IllegalStateException();
            }
            this.delegate.write(jsonWriter, t2);
        }
    }
}

