/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.$Gson$Types;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.Excluder;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.Primitives;
import com.google.gson.internal.bind.JsonAdapterAnnotationTypeAdapterFactory;
import com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.google.gson.internal.reflect.ReflectionAccessor;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ReflectiveTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;
    private final FieldNamingStrategy fieldNamingPolicy;
    private final Excluder excluder;
    private final JsonAdapterAnnotationTypeAdapterFactory jsonAdapterFactory;
    private final ReflectionAccessor accessor = ReflectionAccessor.getInstance();

    public ReflectiveTypeAdapterFactory(ConstructorConstructor constructorConstructor, FieldNamingStrategy fieldNamingStrategy, Excluder excluder, JsonAdapterAnnotationTypeAdapterFactory jsonAdapterAnnotationTypeAdapterFactory) {
        this.constructorConstructor = constructorConstructor;
        this.fieldNamingPolicy = fieldNamingStrategy;
        this.excluder = excluder;
        this.jsonAdapterFactory = jsonAdapterAnnotationTypeAdapterFactory;
    }

    public final boolean excludeField(Field field, boolean bl2) {
        return ReflectiveTypeAdapterFactory.excludeField(field, bl2, this.excluder);
    }

    static boolean excludeField(Field field, boolean bl2, Excluder excluder) {
        return !excluder.excludeClass(field.getType(), bl2) && !excluder.excludeField(field, bl2);
    }

    private List<String> getFieldNames(Field stringArray) {
        String[] stringArray2 = stringArray.getAnnotation(SerializedName.class);
        if (stringArray2 == null) {
            stringArray = this.fieldNamingPolicy.translateName((Field)stringArray);
            return Collections.singletonList(stringArray);
        }
        stringArray = stringArray2.value();
        if ((stringArray2 = stringArray2.alternate()).length == 0) {
            return Collections.singletonList(stringArray);
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray2.length + 1);
        arrayList.add((String)stringArray);
        stringArray = stringArray2;
        int n2 = stringArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            arrayList.add(string);
        }
        return arrayList;
    }

    @Override
    public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Class<T> clazz = typeToken.getRawType();
        if (!Object.class.isAssignableFrom(clazz)) {
            return null;
        }
        ObjectConstructor<T> objectConstructor = this.constructorConstructor.get(typeToken);
        return new Adapter<T>(objectConstructor, this.getBoundFields(gson, typeToken, clazz));
    }

    private BoundField createBoundField(final Gson gson, final Field field, String string, final TypeToken<?> typeToken, boolean bl2, boolean bl3) {
        boolean bl4;
        final boolean bl5 = Primitives.isPrimitive(typeToken.getRawType());
        JsonAdapter jsonAdapter = field.getAnnotation(JsonAdapter.class);
        final TypeAdapter<?> typeAdapter = null;
        if (jsonAdapter != null) {
            typeAdapter = this.jsonAdapterFactory.getTypeAdapter(this.constructorConstructor, gson, typeToken, jsonAdapter);
        }
        boolean bl6 = bl4 = typeAdapter != null;
        if (typeAdapter == null) {
            typeAdapter = gson.getAdapter(typeToken);
        }
        return new BoundField(string, bl2, bl3){

            @Override
            void write(JsonWriter jsonWriter, Object object) {
                object = field.get(object);
                TypeAdapter typeAdapter2 = bl4 ? typeAdapter : new TypeAdapterRuntimeTypeWrapper(gson, typeAdapter, typeToken.getType());
                typeAdapter2.write(jsonWriter, object);
            }

            @Override
            void read(JsonReader jsonReader, Object object) {
                if ((jsonReader = typeAdapter.read(jsonReader)) != null || !bl5) {
                    field.set(object, jsonReader);
                }
            }

            @Override
            public boolean writeField(Object object) {
                if (!this.serialized) {
                    return false;
                }
                Object object2 = field.get(object);
                return object2 != object;
            }
        };
    }

    private Map<String, BoundField> getBoundFields(Gson gson, TypeToken<?> typeToken, Class<?> clazz) {
        LinkedHashMap<String, BoundField> linkedHashMap = new LinkedHashMap<String, BoundField>();
        if (clazz.isInterface()) {
            return linkedHashMap;
        }
        Type type = typeToken.getType();
        while (clazz != Object.class) {
            Field[] fieldArray = clazz.getDeclaredFields();
            Field[] fieldArray2 = fieldArray;
            fieldArray2 = fieldArray;
            int n2 = fieldArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Field field = fieldArray2[i2];
                boolean bl2 = this.excludeField(field, true);
                boolean bl3 = this.excludeField(field, false);
                if (!bl2 && !bl3) continue;
                this.accessor.makeAccessible(field);
                Type type2 = $Gson$Types.resolve(typeToken.getType(), clazz, field.getGenericType());
                List<String> list = this.getFieldNames(field);
                Object object = null;
                int n3 = list.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    Object object2 = list.get(i3);
                    if (i3 != 0) {
                        bl2 = false;
                    }
                    BoundField boundField = this.createBoundField(gson, field, (String)object2, TypeToken.get(type2), bl2, bl3);
                    object2 = linkedHashMap.put((String)object2, boundField);
                    if (object != null) continue;
                    object = object2;
                }
                if (object == null) continue;
                throw new IllegalArgumentException(type + " declares multiple JSON fields named " + ((BoundField)object).name);
            }
            Class<?> clazz2 = clazz;
            typeToken = TypeToken.get($Gson$Types.resolve(typeToken.getType(), clazz2, clazz2.getGenericSuperclass()));
            clazz = typeToken.getRawType();
        }
        return linkedHashMap;
    }

    public static final class Adapter<T>
    extends TypeAdapter<T> {
        private final ObjectConstructor<T> constructor;
        private final Map<String, BoundField> boundFields;

        Adapter(ObjectConstructor<T> objectConstructor, Map<String, BoundField> map) {
            this.constructor = objectConstructor;
            this.boundFields = map;
        }

        @Override
        public final T read(JsonReader jsonReader) {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            T t2 = this.constructor.construct();
            try {
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    Object object = jsonReader.nextName();
                    if ((object = this.boundFields.get(object)) == null || !((BoundField)object).deserialized) {
                        jsonReader.skipValue();
                        continue;
                    }
                    ((BoundField)object).read(jsonReader, t2);
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw new JsonSyntaxException(illegalStateException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
            jsonReader.endObject();
            return t2;
        }

        @Override
        public final void write(JsonWriter jsonWriter, T t2) {
            if (t2 == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.beginObject();
            try {
                for (BoundField boundField : this.boundFields.values()) {
                    if (!boundField.writeField(t2)) continue;
                    jsonWriter.name(boundField.name);
                    boundField.write(jsonWriter, t2);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
            jsonWriter.endObject();
        }
    }

    static abstract class BoundField {
        final String name;
        final boolean serialized;
        final boolean deserialized;

        protected BoundField(String string, boolean bl2, boolean bl3) {
            this.name = string;
            this.serialized = bl2;
            this.deserialized = bl3;
        }

        abstract boolean writeField(Object var1);

        abstract void write(JsonWriter var1, Object var2);

        abstract void read(JsonReader var1, Object var2);
    }
}

