/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.aztec.AztecReader;
import com.google.zxing.datamatrix.DataMatrixReader;
import com.google.zxing.maxicode.MaxiCodeReader;
import com.google.zxing.oned.MultiFormatOneDReader;
import com.google.zxing.pdf417.PDF417Reader;
import com.google.zxing.qrcode.QRCodeReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public final class MultiFormatReader
implements Reader {
    private Map<DecodeHintType, ?> a;
    private Reader[] b;

    @Override
    public final Result decode(BinaryBitmap binaryBitmap) {
        this.setHints(null);
        return this.a(binaryBitmap);
    }

    @Override
    public final Result decode(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> map) {
        this.setHints(map);
        return this.a(binaryBitmap);
    }

    public final Result decodeWithState(BinaryBitmap binaryBitmap) {
        if (this.b == null) {
            this.setHints(null);
        }
        return this.a(binaryBitmap);
    }

    public final void setHints(Map<DecodeHintType, ?> map) {
        this.a = map;
        boolean bl2 = map != null && map.containsKey((Object)DecodeHintType.TRY_HARDER);
        Collection collection = map == null ? null : (Collection)map.get((Object)DecodeHintType.POSSIBLE_FORMATS);
        ArrayList<Reader> arrayList = new ArrayList<Reader>();
        if (collection != null) {
            boolean bl3 = collection.contains((Object)BarcodeFormat.UPC_A) || collection.contains((Object)BarcodeFormat.UPC_E) || collection.contains((Object)BarcodeFormat.EAN_13) || collection.contains((Object)BarcodeFormat.EAN_8) || collection.contains((Object)BarcodeFormat.CODABAR) || collection.contains((Object)BarcodeFormat.CODE_39) || collection.contains((Object)BarcodeFormat.CODE_93) || collection.contains((Object)BarcodeFormat.CODE_128) || collection.contains((Object)BarcodeFormat.ITF) || collection.contains((Object)BarcodeFormat.RSS_14) || collection.contains((Object)BarcodeFormat.RSS_EXPANDED);
            if (bl3 && !bl2) {
                arrayList.add(new MultiFormatOneDReader(map));
            }
            if (collection.contains((Object)BarcodeFormat.QR_CODE)) {
                arrayList.add(new QRCodeReader());
            }
            if (collection.contains((Object)BarcodeFormat.DATA_MATRIX)) {
                arrayList.add(new DataMatrixReader());
            }
            if (collection.contains((Object)BarcodeFormat.AZTEC)) {
                arrayList.add(new AztecReader());
            }
            if (collection.contains((Object)BarcodeFormat.PDF_417)) {
                arrayList.add(new PDF417Reader());
            }
            if (collection.contains((Object)BarcodeFormat.MAXICODE)) {
                arrayList.add(new MaxiCodeReader());
            }
            if (bl3 && bl2) {
                arrayList.add(new MultiFormatOneDReader(map));
            }
        }
        if (arrayList.isEmpty()) {
            if (!bl2) {
                arrayList.add(new MultiFormatOneDReader(map));
            }
            arrayList.add(new QRCodeReader());
            arrayList.add(new DataMatrixReader());
            arrayList.add(new AztecReader());
            arrayList.add(new PDF417Reader());
            arrayList.add(new MaxiCodeReader());
            if (bl2) {
                arrayList.add(new MultiFormatOneDReader(map));
            }
        }
        ArrayList<Reader> arrayList2 = arrayList;
        this.b = arrayList2.toArray(new Reader[arrayList2.size()]);
    }

    @Override
    public final void reset() {
        if (this.b != null) {
            Reader[] readerArray = this.b;
            int n2 = this.b.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Reader reader = readerArray[i2];
                reader.reset();
            }
        }
    }

    private Result a(BinaryBitmap binaryBitmap) {
        if (this.b != null) {
            Reader[] readerArray = this.b;
            int n2 = this.b.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Reader reader = readerArray[i2];
                try {
                    return reader.decode(binaryBitmap, this.a);
                }
                catch (ReaderException readerException) {
                    continue;
                }
            }
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

