/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import com.google.zxing.LuminanceSource;

public final class RGBLuminanceSource
extends LuminanceSource {
    private final byte[] a;
    private final int b;
    private final int c;
    private final int d;
    private final int e;

    public RGBLuminanceSource(int n2, int n3, int[] nArray) {
        super(n2, n3);
        this.b = n2;
        this.c = n3;
        this.d = 0;
        this.e = 0;
        this.a = new byte[n2 * n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = i2 * n2;
            for (int i3 = 0; i3 < n2; ++i3) {
                int n5 = nArray[n4 + i3];
                int n6 = n5 >> 16 & 0xFF;
                int n7 = n5 >> 8 & 0xFF;
                this.a[n4 + i3] = n6 == n7 && n7 == n5 ? (byte)n6 : (byte)((n6 + 2 * n7 + (n5 &= 0xFF)) / 4);
            }
        }
    }

    private RGBLuminanceSource(byte[] byArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n6, n7);
        if (n4 + n6 > n2 || n5 + n7 > n3) {
            throw new IllegalArgumentException("Crop rectangle does not fit within image data.");
        }
        this.a = byArray;
        this.b = n2;
        this.c = n3;
        this.d = n4;
        this.e = n5;
    }

    @Override
    public final byte[] getRow(int n2, byte[] byArray) {
        if (n2 < 0 || n2 >= this.getHeight()) {
            throw new IllegalArgumentException("Requested row is outside the image: " + n2);
        }
        int n3 = this.getWidth();
        if (byArray == null || byArray.length < n3) {
            byArray = new byte[n3];
        }
        n2 = (n2 + this.e) * this.b + this.d;
        System.arraycopy(this.a, n2, byArray, 0, n3);
        return byArray;
    }

    @Override
    public final byte[] getMatrix() {
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        if (n2 == this.b && n3 == this.c) {
            return this.a;
        }
        int n4 = n2 * n3;
        byte[] byArray = new byte[n4];
        int n5 = this.e * this.b + this.d;
        if (n2 == this.b) {
            System.arraycopy(this.a, n5, byArray, 0, n4);
            return byArray;
        }
        byte[] byArray2 = this.a;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n6 = i2 * n2;
            System.arraycopy(byArray2, n5, byArray, n6, n2);
            n5 += this.b;
        }
        return byArray;
    }

    @Override
    public final boolean isCropSupported() {
        return true;
    }

    @Override
    public final LuminanceSource crop(int n2, int n3, int n4, int n5) {
        return new RGBLuminanceSource(this.a, this.b, this.c, this.d + n2, this.e + n3, n4, n5);
    }
}

