/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.aztec.encoder.AztecCode;
import com.google.zxing.aztec.encoder.Encoder;
import com.google.zxing.common.BitMatrix;
import java.nio.charset.Charset;
import java.util.Map;

public final class AztecWriter
implements Writer {
    private static final Charset a = Charset.forName("ISO-8859-1");

    @Override
    public final BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n2, int n3) {
        return this.encode(string, barcodeFormat, n2, n3, null);
    }

    @Override
    public final BitMatrix encode(String object, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> object2) {
        String string = object2 == null ? null : (String)object2.get((Object)EncodeHintType.CHARACTER_SET);
        Number number = object2 == null ? (Number)null : (Number)((Number)object2.get((Object)EncodeHintType.ERROR_CORRECTION));
        object2 = object2 == null ? (Number)null : (Number)((Number)object2.get((Object)EncodeHintType.AZTEC_LAYERS));
        int n4 = object2 == null ? 0 : ((Number)object2).intValue();
        int n5 = number == null ? 33 : number.intValue();
        object2 = string == null ? a : Charset.forName(string);
        if (barcodeFormat != BarcodeFormat.AZTEC) {
            throw new IllegalArgumentException("Can only encode AZTEC, but got " + (Object)((Object)barcodeFormat));
        }
        AztecCode aztecCode = Encoder.encode(((String)object).getBytes((Charset)object2), n5, n4);
        object = aztecCode;
        int n6 = n2;
        n2 = n3;
        int n7 = n6;
        object = aztecCode;
        object = aztecCode.getMatrix();
        if (object == null) {
            throw new IllegalStateException();
        }
        n3 = ((BitMatrix)object).getWidth();
        int n8 = ((BitMatrix)object).getHeight();
        n7 = Math.max(n7, n3);
        n2 = Math.max(n2, n8);
        n5 = Math.min(n7 / n3, n2 / n8);
        n4 = (n7 - n3 * n5) / 2;
        int n9 = (n2 - n8 * n5) / 2;
        BitMatrix bitMatrix = new BitMatrix(n7, n2);
        n2 = 0;
        while (n2 < n8) {
            int n10 = 0;
            int n11 = n4;
            while (n10 < n3) {
                if (((BitMatrix)object).get(n10, n2)) {
                    int n12 = n5;
                    bitMatrix.setRegion(n11, n9, n12, n12);
                }
                ++n10;
                n11 += n5;
            }
            ++n2;
            n9 += n5;
        }
        return bitMatrix;
    }
}

