/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec.encoder;

import com.google.zxing.aztec.encoder.AztecCode;
import com.google.zxing.aztec.encoder.HighLevelEncoder;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonEncoder;

public final class Encoder {
    public static final int DEFAULT_EC_PERCENT = 33;
    public static final int DEFAULT_AZTEC_LAYERS = 0;
    private static final int[] a = new int[]{4, 6, 6, 8, 8, 8, 8, 8, 8, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};

    private Encoder() {
    }

    public static AztecCode encode(byte[] byArray) {
        return Encoder.encode(byArray, 33, 0);
    }

    public static AztecCode encode(byte[] object, int n2, int n3) {
        int n4;
        int n5;
        BitArray bitArray;
        int n6;
        int n7;
        int n8;
        int n9;
        BitArray bitArray2 = new HighLevelEncoder((byte[])object).encode();
        object = bitArray2;
        n2 = bitArray2.getSize() * n2 / 100 + 11;
        int n10 = ((BitArray)object).getSize() + n2;
        if (n3 != 0) {
            n9 = n3 < 0 ? 1 : 0;
            n8 = Math.abs(n3);
            if (n8 > (n9 != 0 ? 4 : 32)) {
                throw new IllegalArgumentException(String.format("Illegal value %s for layers", n3));
            }
            n3 = Encoder.a(n8, n9 != 0);
            n7 = a[n8];
            int n11 = n3;
            n6 = n11 - n11 % n7;
            bitArray = Encoder.a((BitArray)object, n7);
            if (bitArray.getSize() + n2 > n6) {
                throw new IllegalArgumentException("Data to large for user specified layer");
            }
            if (n9 != 0 && bitArray.getSize() > n7 << 6) {
                throw new IllegalArgumentException("Data to large for user specified layer");
            }
        } else {
            n7 = 0;
            bitArray = null;
            n6 = 0;
            while (true) {
                if (n6 > 32) {
                    throw new IllegalArgumentException("Data too large for an Aztec code");
                }
                n9 = n6 <= 3 ? 1 : 0;
                n8 = n9 != 0 ? n6 + 1 : n6;
                n3 = Encoder.a(n8, n9 != 0);
                if (n10 <= n3) {
                    if (n7 != a[n8]) {
                        n7 = a[n8];
                        bitArray = Encoder.a((BitArray)object, n7);
                    }
                    int n12 = n3;
                    n5 = n12 - n12 % n7;
                    if ((n9 == 0 || bitArray.getSize() <= n7 << 6) && bitArray.getSize() + n2 <= n5) break;
                }
                ++n6;
            }
        }
        BitArray bitArray3 = Encoder.a(bitArray, n3, n7);
        int n13 = n5 = bitArray.getSize() / n7;
        n3 = n8;
        int n14 = n9;
        BitArray bitArray4 = new BitArray();
        if (n14 != 0) {
            bitArray4.appendBits(n3 - 1, 2);
            bitArray4.appendBits(n13 - 1, 6);
            bitArray4 = Encoder.a(bitArray4, 28, 4);
        } else {
            bitArray4.appendBits(n3 - 1, 5);
            bitArray4.appendBits(n13 - 1, 11);
            bitArray4 = Encoder.a(bitArray4, 40, 4);
        }
        Cloneable cloneable = bitArray4;
        n2 = n9 != 0 ? 11 + (n8 << 2) : 14 + (n8 << 2);
        int[] nArray = new int[n2];
        if (n9 != 0) {
            n10 = n2;
            n7 = 0;
            while (n7 < nArray.length) {
                int n15 = n7++;
                nArray[n15] = n15;
            }
        } else {
            n10 = n2 + 1 + 2 * ((n2 / 2 - 1) / 15);
            n7 = n2 / 2;
            n13 = n10 / 2;
            for (int i2 = 0; i2 < n7; ++i2) {
                int n16 = i2;
                n4 = n16 + n16 / 15;
                nArray[n7 - i2 - 1] = n13 - n4 - 1;
                nArray[n7 + i2] = n13 + n4 + 1;
            }
        }
        BitMatrix bitMatrix = new BitMatrix(n10);
        int n17 = 0;
        for (n13 = 0; n13 < n8; ++n13) {
            n4 = n9 != 0 ? (n8 - n13 << 2) + 9 : (n8 - n13 << 2) + 12;
            for (int i3 = 0; i3 < n4; ++i3) {
                int n18 = i3 << 1;
                for (int i4 = 0; i4 < 2; ++i4) {
                    if (bitArray3.get(n17 + n18 + i4)) {
                        bitMatrix.set(nArray[(n13 << 1) + i4], nArray[(n13 << 1) + i3]);
                    }
                    if (bitArray3.get(n17 + (n4 << 1) + n18 + i4)) {
                        bitMatrix.set(nArray[(n13 << 1) + i3], nArray[n2 - 1 - (n13 << 1) - i4]);
                    }
                    if (bitArray3.get(n17 + (n4 << 2) + n18 + i4)) {
                        bitMatrix.set(nArray[n2 - 1 - (n13 << 1) - i4], nArray[n2 - 1 - (n13 << 1) - i3]);
                    }
                    if (!bitArray3.get(n17 + n4 * 6 + n18 + i4)) continue;
                    bitMatrix.set(nArray[n2 - 1 - (n13 << 1) - i3], nArray[(n13 << 1) + i4]);
                }
            }
            n17 += n4 << 3;
        }
        BitArray bitArray5 = cloneable;
        n13 = n10;
        int n19 = n9;
        cloneable = bitMatrix;
        n13 /= 2;
        if (n19 != 0) {
            for (n19 = 0; n19 < 7; ++n19) {
                int n20 = n13 - 3 + n19;
                if (bitArray5.get(n19)) {
                    ((BitMatrix)cloneable).set(n20, n13 - 5);
                }
                if (bitArray5.get(n19 + 7)) {
                    ((BitMatrix)cloneable).set(n13 + 5, n20);
                }
                if (bitArray5.get(20 - n19)) {
                    ((BitMatrix)cloneable).set(n20, n13 + 5);
                }
                if (!bitArray5.get(27 - n19)) continue;
                ((BitMatrix)cloneable).set(n13 - 5, n20);
            }
        } else {
            for (n19 = 0; n19 < 10; ++n19) {
                int n21 = n13 - 5 + n19 + n19 / 5;
                if (bitArray5.get(n19)) {
                    ((BitMatrix)cloneable).set(n21, n13 - 7);
                }
                if (bitArray5.get(n19 + 10)) {
                    ((BitMatrix)cloneable).set(n13 + 7, n21);
                }
                if (bitArray5.get(29 - n19)) {
                    ((BitMatrix)cloneable).set(n21, n13 + 7);
                }
                if (!bitArray5.get(39 - n19)) continue;
                ((BitMatrix)cloneable).set(n13 - 7, n21);
            }
        }
        if (n9 != 0) {
            Encoder.a(bitMatrix, n10 / 2, 5);
        } else {
            Encoder.a(bitMatrix, n10 / 2, 7);
            n13 = 0;
            int n22 = 0;
            while (n13 < n2 / 2 - 1) {
                for (n4 = n10 / 2 & 1; n4 < n10; n4 += 2) {
                    bitMatrix.set(n10 / 2 - n22, n4);
                    bitMatrix.set(n10 / 2 + n22, n4);
                    bitMatrix.set(n4, n10 / 2 - n22);
                    bitMatrix.set(n4, n10 / 2 + n22);
                }
                n13 += 15;
                n22 += 16;
            }
        }
        AztecCode aztecCode = new AztecCode();
        aztecCode.setCompact(n9 != 0);
        aztecCode.setSize(n10);
        aztecCode.setLayers(n8);
        aztecCode.setCodeWords(n5);
        aztecCode.setMatrix(bitMatrix);
        return aztecCode;
    }

    private static void a(BitMatrix bitMatrix, int n2, int n3) {
        for (int i2 = 0; i2 < n3; i2 += 2) {
            for (int i3 = n2 - i2; i3 <= n2 + i2; ++i3) {
                bitMatrix.set(i3, n2 - i2);
                bitMatrix.set(i3, n2 + i2);
                bitMatrix.set(n2 - i2, i3);
                bitMatrix.set(n2 + i2, i3);
            }
        }
        bitMatrix.set(n2 - n3, n2 - n3);
        bitMatrix.set(n2 - n3 + 1, n2 - n3);
        bitMatrix.set(n2 - n3, n2 - n3 + 1);
        bitMatrix.set(n2 + n3, n2 - n3);
        bitMatrix.set(n2 + n3, n2 - n3 + 1);
        bitMatrix.set(n2 + n3, n2 + n3 - 1);
    }

    private static BitArray a(BitArray object, int n2, int n3) {
        int n4 = ((BitArray)object).getSize() / n3;
        ReedSolomonEncoder reedSolomonEncoder = new ReedSolomonEncoder(Encoder.a(n3));
        Object object2 = n2 / n3;
        object = Encoder.b((BitArray)object, n3, object2);
        reedSolomonEncoder.encode((int[])object, object2 - n4);
        BitArray bitArray = new BitArray();
        bitArray.appendBits(0, n2 %= n3);
        n2 = ((Object)object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            object2 = object[i2];
            bitArray.appendBits((int)object2, n3);
        }
        return bitArray;
    }

    private static int[] b(BitArray bitArray, int n2, int n3) {
        int[] nArray = new int[n3];
        int n4 = bitArray.getSize() / n2;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = 0;
            for (int i3 = 0; i3 < n2; ++i3) {
                n5 |= bitArray.get(i2 * n2 + i3) ? 1 << n2 - i3 - 1 : 0;
            }
            nArray[i2] = n5;
        }
        return nArray;
    }

    private static GenericGF a(int n2) {
        switch (n2) {
            case 4: {
                return GenericGF.AZTEC_PARAM;
            }
            case 6: {
                return GenericGF.AZTEC_DATA_6;
            }
            case 8: {
                return GenericGF.AZTEC_DATA_8;
            }
            case 10: {
                return GenericGF.AZTEC_DATA_10;
            }
            case 12: {
                return GenericGF.AZTEC_DATA_12;
            }
        }
        throw new IllegalArgumentException("Unsupported word size " + n2);
    }

    private static BitArray a(BitArray bitArray, int n2) {
        BitArray bitArray2 = new BitArray();
        int n3 = bitArray.getSize();
        int n4 = (1 << n2) - 2;
        for (int i2 = 0; i2 < n3; i2 += n2) {
            int n5 = 0;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (i2 + i3 < n3 && !bitArray.get(i2 + i3)) continue;
                n5 |= 1 << n2 - 1 - i3;
            }
            if ((n5 & n4) == n4) {
                bitArray2.appendBits(n5 & n4, n2);
                --i2;
                continue;
            }
            if ((n5 & n4) == 0) {
                bitArray2.appendBits(n5 | 1, n2);
                --i2;
                continue;
            }
            bitArray2.appendBits(n5, n2);
        }
        return bitArray2;
    }

    private static int a(int n2, boolean bl2) {
        return ((bl2 ? 88 : 112) + n2 * 16) * n2;
    }
}

