/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import javax.imageio.ImageIO;
import javax.xml.bind.DatatypeConverter;

public final class ImageReader {
    private ImageReader() {
    }

    public static BufferedImage readImage(URI uRI) {
        BufferedImage bufferedImage;
        if ("data".equals(uRI.getScheme())) {
            return ImageReader.readDataURIImage(uRI);
        }
        try {
            bufferedImage = ImageIO.read(uRI.toURL());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("Resource not found: " + uRI, illegalArgumentException);
        }
        if (bufferedImage == null) {
            throw new IOException("Could not load " + uRI);
        }
        return bufferedImage;
    }

    public static BufferedImage readDataURIImage(URI object) {
        if (!((String)(object = ((URI)object).toString())).startsWith("data:image/")) {
            throw new IOException("Unsupported data URI MIME type");
        }
        int n2 = ((String)object).indexOf("base64,");
        if (n2 < 0) {
            throw new IOException("Unsupported data URI encoding");
        }
        object = ((String)object).substring(n2 + 7);
        object = URLDecoder.decode((String)object, "UTF-8");
        object = DatatypeConverter.parseBase64Binary((String)object);
        return ImageIO.read(new ByteArrayInputStream((byte[])object));
    }

    public static BufferedImage readImage(File file) {
        return ImageReader.readImage(file.toURI());
    }
}

