/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.common.BitMatrix;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public final class MatrixToImageWriter {
    private static final MatrixToImageConfig a = new MatrixToImageConfig();

    private MatrixToImageWriter() {
    }

    public static BufferedImage toBufferedImage(BitMatrix bitMatrix) {
        return MatrixToImageWriter.toBufferedImage(bitMatrix, a);
    }

    public static BufferedImage toBufferedImage(BitMatrix bitMatrix, MatrixToImageConfig matrixToImageConfig) {
        int n2 = bitMatrix.getWidth();
        int n3 = bitMatrix.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n2, n3, matrixToImageConfig.a());
        int n4 = matrixToImageConfig.getPixelOnColor();
        int n5 = matrixToImageConfig.getPixelOffColor();
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                bufferedImage.setRGB(i2, i3, bitMatrix.get(i2, i3) ? n4 : n5);
            }
        }
        return bufferedImage;
    }

    public static void writeToFile(BitMatrix bitMatrix, String string, File file) {
        MatrixToImageWriter.writeToFile(bitMatrix, string, file, a);
    }

    public static void writeToFile(BitMatrix object, String string, File file, MatrixToImageConfig matrixToImageConfig) {
        if (!ImageIO.write((RenderedImage)(object = MatrixToImageWriter.toBufferedImage((BitMatrix)object, matrixToImageConfig)), string, file)) {
            throw new IOException("Could not write an image of format " + string + " to " + file);
        }
    }

    public static void writeToStream(BitMatrix bitMatrix, String string, OutputStream outputStream) {
        MatrixToImageWriter.writeToStream(bitMatrix, string, outputStream, a);
    }

    public static void writeToStream(BitMatrix object, String string, OutputStream outputStream, MatrixToImageConfig matrixToImageConfig) {
        if (!ImageIO.write((RenderedImage)(object = MatrixToImageWriter.toBufferedImage((BitMatrix)object, matrixToImageConfig)), string, outputStream)) {
            throw new IOException("Could not write an image of format " + string);
        }
    }
}

