/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import java.util.Arrays;

public final class BitArray
implements Cloneable {
    private int[] a;
    private int b;

    public BitArray() {
        this.b = 0;
        this.a = new int[1];
    }

    public BitArray(int n2) {
        this.b = n2;
        this.a = BitArray.b(n2);
    }

    private BitArray(int[] nArray, int n2) {
        this.a = nArray;
        this.b = n2;
    }

    public final int getSize() {
        return this.b;
    }

    public final int getSizeInBytes() {
        return (this.b + 7) / 8;
    }

    private void a(int n2) {
        if (n2 > this.a.length << 5) {
            int[] nArray = BitArray.b(n2);
            System.arraycopy(this.a, 0, nArray, 0, this.a.length);
            this.a = nArray;
        }
    }

    public final boolean get(int n2) {
        return (this.a[n2 / 32] & 1 << (n2 & 0x1F)) != 0;
    }

    public final void set(int n2) {
        int n3 = n2 / 32;
        this.a[n3] = this.a[n3] | 1 << (n2 & 0x1F);
    }

    public final void flip(int n2) {
        int n3 = n2 / 32;
        this.a[n3] = this.a[n3] ^ 1 << (n2 & 0x1F);
    }

    public final int getNextSet(int n2) {
        if (n2 >= this.b) {
            return this.b;
        }
        int n3 = n2 / 32;
        int n4 = this.a[n3];
        n4 &= ~((1 << (n2 & 0x1F)) - 1);
        while (n4 == 0) {
            if (++n3 == this.a.length) {
                return this.b;
            }
            n4 = this.a[n3];
        }
        n2 = (n3 << 5) + Integer.numberOfTrailingZeros(n4);
        if (n2 > this.b) {
            return this.b;
        }
        return n2;
    }

    public final int getNextUnset(int n2) {
        if (n2 >= this.b) {
            return this.b;
        }
        int n3 = n2 / 32;
        int n4 = ~this.a[n3];
        n4 &= ~((1 << (n2 & 0x1F)) - 1);
        while (n4 == 0) {
            if (++n3 == this.a.length) {
                return this.b;
            }
            n4 = ~this.a[n3];
        }
        n2 = (n3 << 5) + Integer.numberOfTrailingZeros(n4);
        if (n2 > this.b) {
            return this.b;
        }
        return n2;
    }

    public final void setBulk(int n2, int n3) {
        this.a[n2 / 32] = n3;
    }

    public final void setRange(int n2, int n3) {
        if (n3 < n2) {
            throw new IllegalArgumentException();
        }
        if (n3 == n2) {
            return;
        }
        int n4 = n2 / 32;
        int n5 = --n3 / 32;
        int n6 = n4;
        while (n6 <= n5) {
            int n7;
            int n8;
            int n9 = n6 > n4 ? 0 : n2 & 0x1F;
            int n10 = n8 = n6 < n5 ? 31 : n3 & 0x1F;
            if (n9 == 0 && n8 == 31) {
                n7 = -1;
            } else {
                n7 = 0;
                while (n9 <= n8) {
                    n7 |= 1 << n9;
                    ++n9;
                }
            }
            int n11 = n6++;
            this.a[n11] = this.a[n11] | n7;
        }
    }

    public final void clear() {
        int n2 = this.a.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.a[i2] = 0;
        }
    }

    public final boolean isRange(int n2, int n3, boolean bl2) {
        if (n3 < n2) {
            throw new IllegalArgumentException();
        }
        if (n3 == n2) {
            return true;
        }
        int n4 = n2 / 32;
        int n5 = --n3 / 32;
        for (int i2 = n4; i2 <= n5; ++i2) {
            int n6;
            int n7;
            int n8 = i2 > n4 ? 0 : n2 & 0x1F;
            int n9 = n7 = i2 < n5 ? 31 : n3 & 0x1F;
            if (n8 == 0 && n7 == 31) {
                n6 = -1;
            } else {
                n6 = 0;
                while (n8 <= n7) {
                    n6 |= 1 << n8;
                    ++n8;
                }
            }
            if ((this.a[i2] & n6) == (bl2 ? n6 : 0)) continue;
            return false;
        }
        return true;
    }

    public final void appendBit(boolean bl2) {
        BitArray bitArray = this;
        bitArray.a(bitArray.b + 1);
        if (bl2) {
            int n2 = this.b / 32;
            this.a[n2] = this.a[n2] | 1 << (this.b & 0x1F);
        }
        ++this.b;
    }

    public final void appendBits(int n2, int n3) {
        if (n3 < 0 || n3 > 32) {
            throw new IllegalArgumentException("Num bits must be between 0 and 32");
        }
        BitArray bitArray = this;
        bitArray.a(bitArray.b + n3);
        while (n3 > 0) {
            this.appendBit((n2 >> n3 - 1 & 1) == 1);
            --n3;
        }
    }

    public final void appendBitArray(BitArray bitArray) {
        int n2 = bitArray.b;
        BitArray bitArray2 = this;
        bitArray2.a(bitArray2.b + n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.appendBit(bitArray.get(i2));
        }
    }

    public final void xor(BitArray bitArray) {
        if (this.a.length != bitArray.a.length) {
            throw new IllegalArgumentException("Sizes don't match");
        }
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            int n2 = i2;
            this.a[n2] = this.a[n2] ^ bitArray.a[i2];
        }
    }

    public final void toBytes(int n2, byte[] byArray, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = 0;
            for (int i3 = 0; i3 < 8; ++i3) {
                if (this.get(n2)) {
                    n5 |= 1 << 7 - i3;
                }
                ++n2;
            }
            byArray[n3 + i2] = (byte)n5;
        }
    }

    public final int[] getBitArray() {
        return this.a;
    }

    public final void reverse() {
        int n2;
        int[] nArray = new int[this.a.length];
        int n3 = (this.b - 1) / 32;
        int n4 = n3 + 1;
        for (n2 = 0; n2 < n4; ++n2) {
            long l2 = this.a[n2];
            l2 = l2 >> 1 & 0x55555555L | (l2 & 0x55555555L) << 1;
            l2 = l2 >> 2 & 0x33333333L | (l2 & 0x33333333L) << 2;
            l2 = l2 >> 4 & 0xF0F0F0FL | (l2 & 0xF0F0F0FL) << 4;
            l2 = l2 >> 8 & 0xFF00FFL | (l2 & 0xFF00FFL) << 8;
            l2 = l2 >> 16 & 0xFFFFL | (l2 & 0xFFFFL) << 16;
            nArray[n3 - n2] = (int)l2;
        }
        if (this.b != n4 << 5) {
            int n5;
            n2 = (n4 << 5) - this.b;
            int n6 = 1;
            for (n5 = 0; n5 < 31 - n2; ++n5) {
                n6 = n6 << 1 | 1;
            }
            n5 = nArray[0] >> n2 & n6;
            for (n3 = 1; n3 < n4; ++n3) {
                int n7 = nArray[n3];
                nArray[n3 - 1] = n5 |= n7 << 32 - n2;
                n5 = n7 >> n2 & n6;
            }
            nArray[n4 - 1] = n5;
        }
        this.a = nArray;
    }

    private static int[] b(int n2) {
        return new int[(n2 + 31) / 32];
    }

    public final boolean equals(Object object) {
        if (!(object instanceof BitArray)) {
            return false;
        }
        object = (BitArray)object;
        return this.b == ((BitArray)object).b && Arrays.equals(this.a, ((BitArray)object).a);
    }

    public final int hashCode() {
        return 31 * this.b + Arrays.hashCode(this.a);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.b);
        for (int i2 = 0; i2 < this.b; ++i2) {
            if ((i2 & 7) == 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.get(i2) ? (char)'X' : '.');
        }
        return stringBuilder.toString();
    }

    public final BitArray clone() {
        return new BitArray((int[])this.a.clone(), this.b);
    }
}

