/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.common.BitArray;
import java.util.Arrays;

public final class BitMatrix
implements Cloneable {
    private final int a;
    private final int b;
    private final int c;
    private final int[] d;

    public BitMatrix(int n2) {
        int n3 = n2;
        this(n3, n3);
    }

    public BitMatrix(int n2, int n3) {
        if (n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException("Both dimensions must be greater than 0");
        }
        this.a = n2;
        this.b = n3;
        this.c = (n2 + 31) / 32;
        this.d = new int[this.c * n3];
    }

    private BitMatrix(int n2, int n3, int n4, int[] nArray) {
        this.a = n2;
        this.b = n3;
        this.c = n4;
        this.d = nArray;
    }

    public static BitMatrix parse(String object, String string, String string2) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        boolean[] blArray = new boolean[((String)object).length()];
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        while (n6 < ((String)object).length()) {
            if (((String)object).charAt(n6) == '\n' || ((String)object).charAt(n6) == '\r') {
                if (n2 > n3) {
                    if (n4 == -1) {
                        n4 = n2 - n3;
                    } else if (n2 - n3 != n4) {
                        throw new IllegalArgumentException("row lengths do not match");
                    }
                    n3 = n2;
                    ++n5;
                }
                ++n6;
                continue;
            }
            int n7 = n6;
            if (((String)object).substring(n7, n7 + string.length()).equals(string)) {
                n6 += string.length();
                blArray[n2] = true;
                ++n2;
                continue;
            }
            int n8 = n6;
            if (((String)object).substring(n8, n8 + string2.length()).equals(string2)) {
                n6 += string2.length();
                blArray[n2] = false;
                ++n2;
                continue;
            }
            throw new IllegalArgumentException("illegal character encountered: " + ((String)object).substring(n6));
        }
        if (n2 > n3) {
            if (n4 == -1) {
                n4 = n2 - n3;
            } else if (n2 - n3 != n4) {
                throw new IllegalArgumentException("row lengths do not match");
            }
            ++n5;
        }
        object = new BitMatrix(n4, n5);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!blArray[i2]) continue;
            ((BitMatrix)object).set(i2 % n4, i2 / n4);
        }
        return object;
    }

    public final boolean get(int n2, int n3) {
        return (this.d[n3 = n3 * this.c + n2 / 32] >>> (n2 & 0x1F) & 1) != 0;
    }

    public final void set(int n2, int n3) {
        int n4 = n3 = n3 * this.c + n2 / 32;
        this.d[n4] = this.d[n4] | 1 << (n2 & 0x1F);
    }

    public final void unset(int n2, int n3) {
        int n4 = n3 = n3 * this.c + n2 / 32;
        this.d[n4] = this.d[n4] & ~(1 << (n2 & 0x1F));
    }

    public final void flip(int n2, int n3) {
        int n4 = n3 = n3 * this.c + n2 / 32;
        this.d[n4] = this.d[n4] ^ 1 << (n2 & 0x1F);
    }

    public final void xor(BitMatrix bitMatrix) {
        if (this.a != bitMatrix.getWidth() || this.b != bitMatrix.getHeight() || this.c != bitMatrix.getRowSize()) {
            throw new IllegalArgumentException("input matrix dimensions do not match");
        }
        BitArray bitArray = new BitArray(this.a / 32 + 1);
        for (int i2 = 0; i2 < this.b; ++i2) {
            int n2 = i2 * this.c;
            int[] nArray = bitMatrix.getRow(i2, bitArray).getBitArray();
            for (int i3 = 0; i3 < this.c; ++i3) {
                int n3 = n2 + i3;
                this.d[n3] = this.d[n3] ^ nArray[i3];
            }
        }
    }

    public final void clear() {
        int n2 = this.d.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.d[i2] = 0;
        }
    }

    public final void setRegion(int n2, int n3, int n4, int n5) {
        if (n3 < 0 || n2 < 0) {
            throw new IllegalArgumentException("Left and top must be nonnegative");
        }
        if (n5 <= 0 || n4 <= 0) {
            throw new IllegalArgumentException("Height and width must be at least 1");
        }
        n4 = n2 + n4;
        if ((n5 = n3 + n5) > this.b || n4 > this.a) {
            throw new IllegalArgumentException("The region must fit inside the matrix");
        }
        while (n3 < n5) {
            int n6 = n3 * this.c;
            for (int i2 = n2; i2 < n4; ++i2) {
                int n7 = n6 + i2 / 32;
                this.d[n7] = this.d[n7] | 1 << (i2 & 0x1F);
            }
            ++n3;
        }
    }

    public final BitArray getRow(int n2, BitArray bitArray) {
        if (bitArray == null || bitArray.getSize() < this.a) {
            bitArray = new BitArray(this.a);
        } else {
            bitArray.clear();
        }
        n2 *= this.c;
        for (int i2 = 0; i2 < this.c; ++i2) {
            bitArray.setBulk(i2 << 5, this.d[n2 + i2]);
        }
        return bitArray;
    }

    public final void setRow(int n2, BitArray bitArray) {
        System.arraycopy(bitArray.getBitArray(), 0, this.d, n2 * this.c, this.c);
    }

    public final void rotate180() {
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        BitArray bitArray = new BitArray(n2);
        BitArray bitArray2 = new BitArray(n2);
        for (int i2 = 0; i2 < (n3 + 1) / 2; ++i2) {
            bitArray = this.getRow(i2, bitArray);
            bitArray2 = this.getRow(n3 - 1 - i2, bitArray2);
            bitArray.reverse();
            bitArray2.reverse();
            this.setRow(i2, bitArray2);
            this.setRow(n3 - 1 - i2, bitArray);
        }
    }

    public final int[] getEnclosingRectangle() {
        int n2;
        int n3;
        int n4 = this.a;
        int n5 = this.b;
        int n6 = -1;
        int n7 = -1;
        for (n3 = 0; n3 < this.b; ++n3) {
            for (n2 = 0; n2 < this.c; ++n2) {
                int n8;
                int n9 = this.d[n3 * this.c + n2];
                if (n9 == 0) continue;
                if (n3 < n5) {
                    n5 = n3;
                }
                if (n3 > n7) {
                    n7 = n3;
                }
                if (n2 << 5 < n4) {
                    n8 = 0;
                    while (n9 << 31 - n8 == 0) {
                        ++n8;
                    }
                    if ((n2 << 5) + n8 < n4) {
                        n4 = (n2 << 5) + n8;
                    }
                }
                if ((n2 << 5) + 31 <= n6) continue;
                n8 = 31;
                while (n9 >>> n8 == 0) {
                    --n8;
                }
                if ((n2 << 5) + n8 <= n6) continue;
                n6 = (n2 << 5) + n8;
            }
        }
        n3 = n6 - n4;
        n2 = n7 - n5;
        if (n3 < 0 || n2 < 0) {
            return null;
        }
        return new int[]{n4, n5, n3, n2};
    }

    public final int[] getTopLeftOnBit() {
        int n2;
        for (n2 = 0; n2 < this.d.length && this.d[n2] == 0; ++n2) {
        }
        if (n2 == this.d.length) {
            return null;
        }
        int n3 = n2 / this.c;
        int n4 = n2 % this.c << 5;
        n2 = this.d[n2];
        int n5 = 0;
        while (n2 << 31 - n5 == 0) {
            ++n5;
        }
        return new int[]{n4 += n5, n3};
    }

    public final int[] getBottomRightOnBit() {
        int n2;
        for (n2 = this.d.length - 1; n2 >= 0 && this.d[n2] == 0; --n2) {
        }
        if (n2 < 0) {
            return null;
        }
        int n3 = n2 / this.c;
        int n4 = n2 % this.c << 5;
        n2 = this.d[n2];
        int n5 = 31;
        while (n2 >>> n5 == 0) {
            --n5;
        }
        return new int[]{n4 += n5, n3};
    }

    public final int getWidth() {
        return this.a;
    }

    public final int getHeight() {
        return this.b;
    }

    public final int getRowSize() {
        return this.c;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof BitMatrix)) {
            return false;
        }
        object = (BitMatrix)object;
        return this.a == ((BitMatrix)object).a && this.b == ((BitMatrix)object).b && this.c == ((BitMatrix)object).c && Arrays.equals(this.d, ((BitMatrix)object).d);
    }

    public final int hashCode() {
        int n2 = this.a;
        n2 = n2 * 31 + this.a;
        n2 = n2 * 31 + this.b;
        n2 = n2 * 31 + this.c;
        n2 = n2 * 31 + Arrays.hashCode(this.d);
        return n2;
    }

    public final String toString() {
        return this.toString("X ", "  ");
    }

    public final String toString(String string, String string2) {
        return this.toString(string, string2, "\n");
    }

    @Deprecated
    public final String toString(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(this.b * (this.a + 1));
        for (int i2 = 0; i2 < this.b; ++i2) {
            for (int i3 = 0; i3 < this.a; ++i3) {
                stringBuilder.append(this.get(i3, i2) ? string : string2);
            }
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    public final BitMatrix clone() {
        return new BitMatrix(this.a, this.b, this.c, (int[])this.d.clone());
    }
}

