/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.maxicode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.maxicode.decoder.Decoder;
import java.util.Map;

public final class MaxiCodeReader
implements Reader {
    private static final ResultPoint[] a = new ResultPoint[0];
    private final Decoder b = new Decoder();

    @Override
    public final Result decode(BinaryBitmap binaryBitmap) {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public final Result decode(BinaryBitmap object, Map<DecodeHintType, ?> object2) {
        ResultPoint[] resultPointArray;
        if (object2 != null && object2.containsKey((Object)DecodeHintType.PURE_BARCODE)) {
            int[] nArray = ((BitMatrix)(object = ((BinaryBitmap)object).getBlackMatrix())).getEnclosingRectangle();
            if (nArray == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            int n2 = nArray[0];
            int n3 = nArray[1];
            int n4 = nArray[2];
            int n5 = nArray[3];
            resultPointArray = new BitMatrix(30, 33);
            for (int i2 = 0; i2 < 33; ++i2) {
                int n6 = n3 + (i2 * n5 + n5 / 2) / 33;
                for (int i3 = 0; i3 < 30; ++i3) {
                    int n7 = n2 + (i3 * n4 + n4 / 2 + (i2 & 1) * n4 / 2) / 30;
                    if (!((BitMatrix)object).get(n7, n6)) continue;
                    resultPointArray.set(i3, i2);
                }
            }
        } else {
            throw NotFoundException.getNotFoundInstance();
        }
        ResultPoint[] resultPointArray2 = resultPointArray;
        object = this.b.decode((BitMatrix)resultPointArray2, (Map<DecodeHintType, ?>)object2);
        resultPointArray2 = a;
        object2 = new Result(((DecoderResult)object).getText(), ((DecoderResult)object).getRawBytes(), resultPointArray2, BarcodeFormat.MAXICODE);
        object = ((DecoderResult)object).getECLevel();
        if (object != null) {
            ((Result)object2).putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, object);
        }
        return object2;
    }

    @Override
    public final void reset() {
    }
}

