/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.EAN13Reader;
import com.google.zxing.oned.UPCEANReader;
import com.google.zxing.oned.UPCEANWriter;
import java.util.Map;

public final class EAN13Writer
extends UPCEANWriter {
    @Override
    public final BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) {
        if (barcodeFormat != BarcodeFormat.EAN_13) {
            throw new IllegalArgumentException("Can only encode EAN_13, but got " + (Object)((Object)barcodeFormat));
        }
        return super.encode(string, barcodeFormat, n2, n3, map);
    }

    @Override
    public final boolean[] encode(String string) {
        int n2;
        int n3;
        if (string.length() != 13) {
            throw new IllegalArgumentException("Requested contents should be 13 digits long, but got " + string.length());
        }
        try {
            if (!UPCEANReader.a(string)) {
                throw new IllegalArgumentException("Contents do not pass checksum");
            }
        }
        catch (FormatException formatException) {
            throw new IllegalArgumentException("Illegal contents");
        }
        int n4 = Integer.parseInt(string.substring(0, 1));
        n4 = EAN13Reader.a[n4];
        boolean[] blArray = new boolean[95];
        int n5 = 0 + EAN13Writer.appendPattern(blArray, 0, UPCEANReader.b, true);
        for (n3 = 1; n3 <= 6; ++n3) {
            int n6 = n3;
            n2 = Integer.parseInt(string.substring(n6, n6 + 1));
            if ((n4 >> 6 - n3 & 1) == 1) {
                n2 += 10;
            }
            n5 += EAN13Writer.appendPattern(blArray, n5, UPCEANReader.e[n2], false);
        }
        n5 += EAN13Writer.appendPattern(blArray, n5, UPCEANReader.c, false);
        n3 = 7;
        while (n3 <= 12) {
            int n7 = n3++;
            n2 = Integer.parseInt(string.substring(n7, n7 + 1));
            n5 += EAN13Writer.appendPattern(blArray, n5, UPCEANReader.d[n2], true);
        }
        EAN13Writer.appendPattern(blArray, n5, UPCEANReader.b, true);
        return blArray;
    }
}

