/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.UPCEANReader;
import com.google.zxing.oned.UPCEANWriter;
import java.util.Map;

public final class EAN8Writer
extends UPCEANWriter {
    @Override
    public final BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) {
        if (barcodeFormat != BarcodeFormat.EAN_8) {
            throw new IllegalArgumentException("Can only encode EAN_8, but got " + (Object)((Object)barcodeFormat));
        }
        return super.encode(string, barcodeFormat, n2, n3, map);
    }

    @Override
    public final boolean[] encode(String string) {
        int n2;
        if (string.length() != 8) {
            throw new IllegalArgumentException("Requested contents should be 8 digits long, but got " + string.length());
        }
        boolean[] blArray = new boolean[67];
        int n3 = 0 + EAN8Writer.appendPattern(blArray, 0, UPCEANReader.b, true);
        int n4 = 0;
        while (n4 <= 3) {
            int n5 = n4++;
            n2 = Integer.parseInt(string.substring(n5, n5 + 1));
            n3 += EAN8Writer.appendPattern(blArray, n3, UPCEANReader.d[n2], false);
        }
        n3 += EAN8Writer.appendPattern(blArray, n3, UPCEANReader.c, false);
        n4 = 4;
        while (n4 <= 7) {
            int n6 = n4++;
            n2 = Integer.parseInt(string.substring(n6, n6 + 1));
            n3 += EAN8Writer.appendPattern(blArray, n3, UPCEANReader.d[n2], true);
        }
        EAN8Writer.appendPattern(blArray, n3, UPCEANReader.b, true);
        return blArray;
    }
}

