/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;

public abstract class OneDReader
implements Reader {
    @Override
    public Result decode(BinaryBitmap binaryBitmap) {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> object) {
        try {
            return this.a(binaryBitmap, (Map<DecodeHintType, ?>)object);
        }
        catch (NotFoundException notFoundException) {
            int n2 = object != null && object.containsKey((Object)DecodeHintType.TRY_HARDER) ? 1 : 0;
            if (n2 != 0 && binaryBitmap.isRotateSupported()) {
                binaryBitmap = binaryBitmap.rotateCounterClockwise();
                object = this.a(binaryBitmap, (Map<DecodeHintType, ?>)object);
                ResultPoint[] resultPointArray = ((Result)object).getResultMetadata();
                n2 = 270;
                if (resultPointArray != null && resultPointArray.containsKey((Object)ResultMetadataType.ORIENTATION)) {
                    n2 = (270 + (Integer)resultPointArray.get((Object)ResultMetadataType.ORIENTATION)) % 360;
                }
                ((Result)object).putMetadata(ResultMetadataType.ORIENTATION, n2);
                resultPointArray = ((Result)object).getResultPoints();
                if (resultPointArray != null) {
                    int n3 = binaryBitmap.getHeight();
                    for (n2 = 0; n2 < resultPointArray.length; ++n2) {
                        resultPointArray[n2] = new ResultPoint((float)n3 - resultPointArray[n2].getY() - 1.0f, resultPointArray[n2].getX());
                    }
                }
                return object;
            }
            throw notFoundException;
        }
    }

    @Override
    public void reset() {
    }

    private Result a(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> object) {
        int n2 = binaryBitmap.getWidth();
        int n3 = binaryBitmap.getHeight();
        BitArray bitArray = new BitArray(n2);
        int n4 = n3 >> 1;
        int n5 = object != null && object.containsKey((Object)DecodeHintType.TRY_HARDER) ? 1 : 0;
        int n6 = Math.max(1, n3 >> (n5 != 0 ? 8 : 5));
        n5 = n5 != 0 ? n3 : 15;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n7 = (i2 + 1) / 2;
            int n8 = (i2 & 1) == 0 ? 1 : 0;
            n7 = n4 + n6 * (n8 != 0 ? n7 : -n7);
            if (n7 < 0 || n7 >= n3) break;
            try {
                bitArray = binaryBitmap.getBlackRow(n7, bitArray);
            }
            catch (NotFoundException notFoundException) {
                continue;
            }
            for (n8 = 0; n8 < 2; ++n8) {
                Object object2;
                if (n8 == 1) {
                    bitArray.reverse();
                    if (object != null && object.containsKey((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK)) {
                        object2 = new EnumMap(DecodeHintType.class);
                        object2.putAll(object);
                        object2.remove((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK);
                        object = object2;
                    }
                }
                try {
                    object2 = this.decodeRow(n7, bitArray, (Map<DecodeHintType, ?>)object);
                    if (n8 == 1) {
                        ((Result)object2).putMetadata(ResultMetadataType.ORIENTATION, 180);
                        ResultPoint[] resultPointArray = ((Result)object2).getResultPoints();
                        if (resultPointArray != null) {
                            resultPointArray[0] = new ResultPoint((float)n2 - resultPointArray[0].getX() - 1.0f, resultPointArray[0].getY());
                            resultPointArray[1] = new ResultPoint((float)n2 - resultPointArray[1].getX() - 1.0f, resultPointArray[1].getY());
                        }
                    }
                    return object2;
                }
                catch (ReaderException readerException) {
                    continue;
                }
            }
        }
        throw NotFoundException.getNotFoundInstance();
    }

    protected static void recordPattern(BitArray bitArray, int n2, int[] nArray) {
        int n3 = nArray.length;
        Arrays.fill(nArray, 0, n3, 0);
        int n4 = bitArray.getSize();
        if (n2 >= n4) {
            throw NotFoundException.getNotFoundInstance();
        }
        boolean bl2 = !bitArray.get(n2);
        int n5 = 0;
        while (n2 < n4) {
            if (bitArray.get(n2) ^ bl2) {
                int n6 = n5;
                nArray[n6] = nArray[n6] + 1;
            } else {
                if (++n5 == n3) break;
                nArray[n5] = 1;
                bl2 = !bl2;
            }
            ++n2;
        }
        if (n5 != n3 && (n5 != n3 - 1 || n2 != n4)) {
            throw NotFoundException.getNotFoundInstance();
        }
    }

    protected static void recordPatternInReverse(BitArray bitArray, int n2, int[] nArray) {
        int n3 = nArray.length;
        boolean bl2 = bitArray.get(n2);
        while (n2 > 0 && n3 >= 0) {
            if (bitArray.get(--n2) == bl2) continue;
            --n3;
            bl2 = !bl2;
        }
        if (n3 >= 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        OneDReader.recordPattern(bitArray, n2 + 1, nArray);
    }

    protected static float patternMatchVariance(int[] nArray, int[] nArray2, float f2) {
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 += nArray[i2];
            n4 += nArray2[i2];
        }
        if (n3 < n4) {
            return Float.POSITIVE_INFINITY;
        }
        float f3 = (float)n3 / (float)n4;
        f2 *= f3;
        float f4 = 0.0f;
        for (int i3 = 0; i3 < n2; ++i3) {
            float f5;
            int n5 = nArray[i3];
            float f6 = (float)nArray2[i3] * f3;
            float f7 = f5 = (float)n5 > f6 ? (float)n5 - f6 : f6 - (float)n5;
            if (f7 > f2) {
                return Float.POSITIVE_INFINITY;
            }
            f4 += f5;
        }
        return f4 / (float)n3;
    }

    public abstract Result decodeRow(int var1, BitArray var2, Map<DecodeHintType, ?> var3);
}

