/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.common.BitMatrix;
import java.util.Map;

public abstract class OneDimensionalCodeWriter
implements Writer {
    @Override
    public final BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n2, int n3) {
        return this.encode(string, barcodeFormat, n2, n3, null);
    }

    @Override
    public BitMatrix encode(String object, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> object2) {
        if (((String)object).isEmpty()) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("Negative size is not allowed. Input: " + n2 + 'x' + n3);
        }
        int n4 = this.getDefaultMargin();
        if (object2 != null && (object2 = (Integer)object2.get((Object)EncodeHintType.MARGIN)) != null) {
            n4 = (Integer)object2;
        }
        boolean[] blArray = this.encode((String)object);
        object2 = blArray;
        int n5 = n2;
        int n6 = n3;
        n3 = n4;
        n2 = n6;
        n4 = n5;
        object = blArray;
        int n7 = blArray.length;
        n3 = n7 + n3;
        n4 = Math.max(n4, n3);
        n2 = Math.max(1, n2);
        n3 = n4 / n3;
        int n8 = (n4 - n7 * n3) / 2;
        BitMatrix bitMatrix = new BitMatrix(n4, n2);
        int n9 = 0;
        while (n9 < n7) {
            if (object[n9] != false) {
                bitMatrix.setRegion(n8, 0, n3, n2);
            }
            ++n9;
            n8 += n3;
        }
        return bitMatrix;
    }

    protected static int appendPattern(boolean[] blArray, int n2, int[] nArray, boolean bl2) {
        int n3 = 0;
        for (int n4 : nArray) {
            for (int i2 = 0; i2 < n4; ++i2) {
                blArray[n2++] = bl2;
            }
            n3 += n4;
            bl2 = !bl2;
        }
        return n3;
    }

    public int getDefaultMargin() {
        return 10;
    }

    public abstract boolean[] encode(String var1);
}

