/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.EAN13Writer;
import com.google.zxing.oned.OneDimensionalCodeWriter;
import java.util.Map;

public final class UPCAWriter
implements Writer {
    private final EAN13Writer a = new EAN13Writer();

    @Override
    public final BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n2, int n3) {
        return this.encode(string, barcodeFormat, n2, n3, null);
    }

    @Override
    public final BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) {
        if (barcodeFormat != BarcodeFormat.UPC_A) {
            throw new IllegalArgumentException("Can only encode UPC-A, but got " + (Object)((Object)barcodeFormat));
        }
        int n4 = string.length();
        if (n4 == 11) {
            n4 = 0;
            for (int i2 = 0; i2 < 11; ++i2) {
                n4 += (string.charAt(i2) - 48) * (i2 % 2 == 0 ? 3 : 1);
            }
            string = string + (1000 - n4) % 10;
        } else if (n4 != 12) {
            throw new IllegalArgumentException("Requested contents should be 11 or 12 digits long, but got " + string.length());
        }
        return ((OneDimensionalCodeWriter)this.a).encode("0" + string, BarcodeFormat.EAN_13, n2, n3, map);
    }
}

