/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.OneDReader;
import com.google.zxing.oned.a;
import com.google.zxing.oned.d;
import java.util.Arrays;
import java.util.Map;

public abstract class UPCEANReader
extends OneDReader {
    static final int[] b = new int[]{1, 1, 1};
    static final int[] c = new int[]{1, 1, 1, 1, 1};
    static final int[][] d = new int[][]{{3, 2, 1, 1}, {2, 2, 2, 1}, {2, 1, 2, 2}, {1, 4, 1, 1}, {1, 1, 3, 2}, {1, 2, 3, 1}, {1, 1, 1, 4}, {1, 3, 1, 2}, {1, 2, 1, 3}, {3, 1, 1, 2}};
    static final int[][] e = new int[20][];
    private final StringBuilder a = new StringBuilder(20);
    private final d f = new d();
    private final a g = new a();

    protected UPCEANReader() {
    }

    static int[] a(BitArray bitArray) {
        boolean bl2 = false;
        int[] nArray = null;
        int n2 = 0;
        int[] nArray2 = new int[b.length];
        while (!bl2) {
            Arrays.fill(nArray2, 0, b.length, 0);
            nArray = UPCEANReader.a(bitArray, n2, false, b, nArray2);
            int n3 = nArray[0];
            int n4 = n3 - ((n2 = nArray[1]) - n3);
            if (n4 < 0) continue;
            bl2 = bitArray.isRange(n4, n3, false);
        }
        return nArray;
    }

    @Override
    public Result decodeRow(int n2, BitArray bitArray, Map<DecodeHintType, ?> map) {
        BitArray bitArray2 = bitArray;
        return this.decodeRow(n2, bitArray2, UPCEANReader.a(bitArray2), map);
    }

    public Result decodeRow(int n2, BitArray bitArray, int[] nArray, Map<DecodeHintType, ?> map) {
        String string;
        int[] nArray2;
        int n3;
        int n4;
        ResultPointCallback resultPointCallback = map == null ? null : (ResultPointCallback)map.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK);
        if (resultPointCallback != null) {
            resultPointCallback.foundPossibleResultPoint(new ResultPoint((float)(nArray[0] + nArray[1]) / 2.0f, n2));
        }
        StringBuilder stringBuilder = this.a;
        stringBuilder.setLength(0);
        int n5 = this.decodeMiddle(bitArray, nArray, stringBuilder);
        if (resultPointCallback != null) {
            resultPointCallback.foundPossibleResultPoint(new ResultPoint(n5, n2));
        }
        int[] nArray3 = this.decodeEnd(bitArray, n5);
        if (resultPointCallback != null) {
            resultPointCallback.foundPossibleResultPoint(new ResultPoint((float)(nArray3[0] + nArray3[1]) / 2.0f, n2));
        }
        if ((n4 = (n3 = nArray3[1]) + (n3 - nArray3[0])) >= bitArray.getSize() || !bitArray.isRange(n3, n4, false)) {
            throw NotFoundException.getNotFoundInstance();
        }
        String string2 = stringBuilder.toString();
        if (string2.length() < 8) {
            throw FormatException.getFormatInstance();
        }
        if (!this.checkChecksum(string2)) {
            throw ChecksumException.getChecksumInstance();
        }
        float f2 = (float)(nArray[1] + nArray[0]) / 2.0f;
        float f3 = (float)(nArray3[1] + nArray3[0]) / 2.0f;
        BarcodeFormat barcodeFormat = this.a();
        Result result = new Result(string2, null, new ResultPoint[]{new ResultPoint(f2, n2), new ResultPoint(f3, n2)}, barcodeFormat);
        int n6 = 0;
        try {
            Result result2 = this.f.a(n2, bitArray, nArray3[1]);
            result.putMetadata(ResultMetadataType.UPC_EAN_EXTENSION, result2.getText());
            result.putAllMetadata(result2.getResultMetadata());
            result.addResultPoints(result2.getResultPoints());
            n6 = result2.getText().length();
        }
        catch (ReaderException readerException) {}
        if ((nArray2 = map == null ? null : (int[])map.get((Object)DecodeHintType.ALLOWED_EAN_EXTENSIONS)) != null) {
            boolean bl2 = false;
            for (int n7 : nArray2) {
                if (n6 != n7) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                throw NotFoundException.getNotFoundInstance();
            }
        }
        if ((barcodeFormat == BarcodeFormat.EAN_13 || barcodeFormat == BarcodeFormat.UPC_A) && (string = this.g.a(string2)) != null) {
            result.putMetadata(ResultMetadataType.POSSIBLE_COUNTRY, string);
        }
        return result;
    }

    boolean checkChecksum(String string) {
        return UPCEANReader.a(string);
    }

    static boolean a(CharSequence charSequence) {
        int n2;
        int n3;
        int n4 = charSequence.length();
        if (n4 == 0) {
            return false;
        }
        int n5 = 0;
        for (n3 = n4 - 2; n3 >= 0; n3 -= 2) {
            n2 = charSequence.charAt(n3) - 48;
            if (n2 < 0 || n2 > 9) {
                throw FormatException.getFormatInstance();
            }
            n5 += n2;
        }
        n5 *= 3;
        for (n3 = n4 - 1; n3 >= 0; n3 -= 2) {
            n2 = charSequence.charAt(n3) - 48;
            if (n2 < 0 || n2 > 9) {
                throw FormatException.getFormatInstance();
            }
            n5 += n2;
        }
        return n5 % 10 == 0;
    }

    int[] decodeEnd(BitArray bitArray, int n2) {
        return UPCEANReader.a(bitArray, n2, false, b);
    }

    static int[] a(BitArray bitArray, int n2, boolean bl2, int[] nArray) {
        return UPCEANReader.a(bitArray, n2, bl2, nArray, new int[nArray.length]);
    }

    private static int[] a(BitArray bitArray, int n2, boolean n3, int[] nArray, int[] nArray2) {
        int n4 = nArray.length;
        int n5 = bitArray.getSize();
        int n6 = n3;
        n2 = n3 != 0 ? bitArray.getNextUnset(n2) : bitArray.getNextSet(n2);
        n3 = 0;
        int n7 = n2;
        while (n2 < n5) {
            if (bitArray.get(n2) ^ n6) {
                int n8 = n3;
                nArray2[n8] = nArray2[n8] + 1;
            } else {
                if (n3 == n4 - 1) {
                    if (UPCEANReader.patternMatchVariance(nArray2, nArray, 0.7f) < 0.48f) {
                        return new int[]{n7, n2};
                    }
                    n7 += nArray2[0] + nArray2[1];
                    System.arraycopy(nArray2, 2, nArray2, 0, n4 - 2);
                    nArray2[n4 - 2] = 0;
                    nArray2[n4 - 1] = 0;
                    --n3;
                } else {
                    ++n3;
                }
                nArray2[n3] = 1;
                n6 = n6 == 0 ? 1 : 0;
            }
            ++n2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    static int a(BitArray bitArray, int[] nArray, int n2, int[][] nArray2) {
        UPCEANReader.recordPattern(bitArray, n2, nArray);
        float f2 = 0.48f;
        n2 = -1;
        int n3 = nArray2.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            float f3;
            int[] nArray3 = nArray2[i2];
            float f4 = UPCEANReader.patternMatchVariance(nArray, nArray3, 0.7f);
            if (!(f3 < f2)) continue;
            f2 = f4;
            n2 = i2;
        }
        if (n2 >= 0) {
            return n2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    abstract BarcodeFormat a();

    protected abstract int decodeMiddle(BitArray var1, int[] var2, StringBuilder var3);

    static {
        System.arraycopy(d, 0, e, 0, 10);
        for (int i2 = 10; i2 < 20; ++i2) {
            int[] nArray = d[i2 - 10];
            int[] nArray2 = new int[nArray.length];
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                nArray2[i3] = nArray[nArray.length - i3 - 1];
            }
            UPCEANReader.e[i2] = nArray2;
        }
    }
}

