/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.detector;

import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.pdf417.detector.PDF417DetectorResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class Detector {
    private static final int[] a = new int[]{0, 4, 1, 5};
    private static final int[] b = new int[]{6, 2, 7, 3};
    private static final int[] c = new int[]{8, 1, 1, 1, 1, 1, 1, 3};
    private static final int[] d = new int[]{7, 1, 1, 3, 1, 1, 1, 2, 1};

    private Detector() {
    }

    public static PDF417DetectorResult detect(BinaryBitmap object, Map<DecodeHintType, ?> list, boolean bl2) {
        list = Detector.a(bl2, (BitMatrix)(object = ((BinaryBitmap)object).getBlackMatrix()));
        if (list.isEmpty()) {
            object = ((BitMatrix)object).clone();
            ((BitMatrix)object).rotate180();
            list = Detector.a(bl2, (BitMatrix)object);
        }
        return new PDF417DetectorResult((BitMatrix)object, list);
    }

    private static List<ResultPoint[]> a(boolean bl2, BitMatrix bitMatrix) {
        ArrayList<ResultPoint[]> arrayList = new ArrayList<ResultPoint[]>();
        int n2 = 0;
        int n3 = 0;
        boolean bl3 = false;
        while (n2 < bitMatrix.getHeight()) {
            ResultPoint[] resultPointArray = Detector.a(bitMatrix, n2, n3);
            if (resultPointArray[0] == null && resultPointArray[3] == null) {
                if (!bl3) break;
                bl3 = false;
                n3 = 0;
                for (ResultPoint[] resultPointArray2 : arrayList) {
                    if (resultPointArray2[1] != null) {
                        n2 = (int)Math.max((float)n2, resultPointArray2[1].getY());
                    }
                    if (resultPointArray2[3] == null) continue;
                    n2 = Math.max(n2, (int)resultPointArray2[3].getY());
                }
                n2 += 5;
                continue;
            }
            bl3 = true;
            arrayList.add(resultPointArray);
            if (!bl2) break;
            if (resultPointArray[2] != null) {
                n3 = (int)((ResultPoint)resultPointArray[2]).getX();
                n2 = (int)((ResultPoint)resultPointArray[2]).getY();
                continue;
            }
            n3 = (int)((ResultPoint)resultPointArray[4]).getX();
            n2 = (int)((ResultPoint)resultPointArray[4]).getY();
        }
        return arrayList;
    }

    private static ResultPoint[] a(BitMatrix bitMatrix, int n2, int n3) {
        int n4 = bitMatrix.getHeight();
        int n5 = bitMatrix.getWidth();
        ResultPoint[] resultPointArray = new ResultPoint[8];
        Detector.a(resultPointArray, Detector.a(bitMatrix, n4, n5, n2, n3, c), a);
        if (resultPointArray[4] != null) {
            n3 = (int)resultPointArray[4].getX();
            n2 = (int)resultPointArray[4].getY();
        }
        Detector.a(resultPointArray, Detector.a(bitMatrix, n4, n5, n2, n3, d), b);
        return resultPointArray;
    }

    private static void a(ResultPoint[] resultPointArray, ResultPoint[] resultPointArray2, int[] nArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            resultPointArray[nArray[i2]] = resultPointArray2[i2];
        }
    }

    private static ResultPoint[] a(BitMatrix bitMatrix, int n2, int n3, int n4, int n5, int[] nArray) {
        int n6;
        ResultPoint[] resultPointArray = new ResultPoint[4];
        int n7 = 0;
        int[] nArray2 = new int[nArray.length];
        while (n4 < n2) {
            int[] nArray3 = Detector.a(bitMatrix, n5, n4, n3, false, nArray, nArray2);
            if (nArray3 != null) {
                while (n4 > 0) {
                    int[] nArray4;
                    if ((nArray4 = Detector.a(bitMatrix, n5, --n4, n3, false, nArray, nArray2)) != null) {
                        nArray3 = nArray4;
                        continue;
                    }
                    ++n4;
                    break;
                }
                resultPointArray[0] = new ResultPoint(nArray3[0], n4);
                resultPointArray[1] = new ResultPoint(nArray3[1], n4);
                n7 = 1;
                break;
            }
            n4 += 5;
        }
        if (n7 != 0) {
            n7 = 0;
            int[] nArray5 = new int[]{(int)resultPointArray[0].getX(), (int)resultPointArray[1].getX()};
            for (n6 = n4 + 1; n6 < n2; ++n6) {
                int[] nArray6 = Detector.a(bitMatrix, nArray5[0], n6, n3, false, nArray, nArray2);
                if (nArray6 != null && Math.abs(nArray5[0] - nArray6[0]) < 5 && Math.abs(nArray5[1] - nArray6[1]) < 5) {
                    nArray5 = nArray6;
                    n7 = 0;
                    continue;
                }
                if (n7 > 25) break;
                ++n7;
            }
            resultPointArray[2] = new ResultPoint(nArray5[0], n6 -= n7 + 1);
            resultPointArray[3] = new ResultPoint(nArray5[1], n6);
        }
        if (n6 - n4 < 10) {
            for (n7 = 0; n7 < resultPointArray.length; ++n7) {
                resultPointArray[n7] = null;
            }
        }
        return resultPointArray;
    }

    /*
     * WARNING - void declaration
     */
    private static int[] a(BitMatrix bitMatrix, int n2, int n3, int n4, boolean bl2, int[] nArray, int[] nArray2) {
        void var5_6;
        void var6_7;
        Arrays.fill((int[])var6_7, 0, ((void)var6_7).length, 0);
        int n5 = ((void)var5_6).length;
        boolean bl3 = false;
        int n6 = 0;
        while (bitMatrix.get(n2, n3) && n2 > 0 && n6++ < 3) {
            --n2;
        }
        int n7 = 0;
        for (n6 = n2; n6 < n4; ++n6) {
            boolean bl4 = bitMatrix.get(n6, n3);
            if (bl4 ^ bl3) {
                void v0 = var6_7;
                int n8 = n7;
                v0[n8] = v0[n8] + true;
                continue;
            }
            if (n7 == n5 - 1) {
                if (Detector.a((int[])var6_7, (int[])var5_6, 0.8f) < 0.42f) {
                    return new int[]{n2, n6};
                }
                n2 += var6_7[0] + var6_7[1];
                System.arraycopy(var6_7, 2, var6_7, 0, n5 - 2);
                var6_7[n5 - 2] = false;
                var6_7[n5 - 1] = false;
                --n7;
            } else {
                ++n7;
            }
            var6_7[n7] = true;
            bl3 = !bl3;
        }
        if (n7 == n5 - 1 && Detector.a((int[])var6_7, (int[])var5_6, 0.8f) < 0.42f) {
            return new int[]{n2, n6 - 1};
        }
        return null;
    }

    private static float a(int[] nArray, int[] nArray2, float f2) {
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 += nArray[i2];
            n4 += nArray2[i2];
        }
        if (n3 < n4) {
            return Float.POSITIVE_INFINITY;
        }
        float f3 = (float)n3 / (float)n4;
        float f4 = 0.8f * f3;
        float f5 = 0.0f;
        for (int i3 = 0; i3 < n2; ++i3) {
            float f6;
            int n5 = nArray[i3];
            float f7 = (float)nArray2[i3] * f3;
            float f8 = f6 = (float)n5 > f7 ? (float)n5 - f7 : f7 - (float)n5;
            if (f8 > f4) {
                return Float.POSITIVE_INFINITY;
            }
            f5 += f6;
        }
        return f5 / (float)n3;
    }
}

