/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.qrcode.decoder.Decoder;
import com.google.zxing.qrcode.decoder.QRCodeDecoderMetaData;
import com.google.zxing.qrcode.detector.Detector;
import java.util.Map;

public class QRCodeReader
implements Reader {
    private static final ResultPoint[] a = new ResultPoint[0];
    private final Decoder b = new Decoder();

    protected final Decoder getDecoder() {
        return this.b;
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap) {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public final Result decode(BinaryBitmap object, Map<DecodeHintType, ?> object2) {
        Object object3;
        if (object2 != null && object2.containsKey((Object)DecodeHintType.PURE_BARCODE)) {
            int n2;
            object = ((BinaryBitmap)object).getBlackMatrix();
            int[] nArray = ((BitMatrix)object).getTopLeftOnBit();
            int[] nArray2 = ((BitMatrix)object).getBottomRightOnBit();
            if (nArray == null || nArray2 == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            Object object4 = object;
            int[] nArray3 = nArray;
            int n3 = ((BitMatrix)object4).getHeight();
            int n4 = ((BitMatrix)object4).getWidth();
            int n5 = nArray3[0];
            int n6 = 1;
            int n7 = 0;
            for (n2 = nArray3[1]; n5 < n4 && n2 < n3; ++n5, ++n2) {
                if (n6 == ((BitMatrix)object4).get(n5, n2)) continue;
                if (++n7 == 5) break;
                n6 = n6 == 0 ? 1 : 0;
            }
            if (n5 == n4 || n2 == n3) {
                throw NotFoundException.getNotFoundInstance();
            }
            float f2 = (float)(n5 - nArray3[0]) / 7.0f;
            int n8 = nArray[1];
            n3 = nArray2[1];
            int n9 = nArray[0];
            int n10 = nArray2[0];
            if (n9 >= n10 || n8 >= n3) {
                throw NotFoundException.getNotFoundInstance();
            }
            if (n3 - n8 != n10 - n9) {
                n10 = n9 + (n3 - n8);
            }
            n4 = Math.round((float)(n10 - n9 + 1) / f2);
            n5 = Math.round((float)(n3 - n8 + 1) / f2);
            if (n4 <= 0 || n5 <= 0) {
                throw NotFoundException.getNotFoundInstance();
            }
            if (n5 != n4) {
                throw NotFoundException.getNotFoundInstance();
            }
            n2 = (int)(f2 / 2.0f);
            n8 += n2;
            if ((n10 = (n9 += n2) + (int)((float)(n4 - 1) * f2) - n10) > 0) {
                if (n10 > n2) {
                    throw NotFoundException.getNotFoundInstance();
                }
                n9 -= n10;
            }
            if ((n10 = n8 + (int)((float)(n5 - 1) * f2) - n3) > 0) {
                if (n10 > n2) {
                    throw NotFoundException.getNotFoundInstance();
                }
                n8 -= n10;
            }
            BitMatrix bitMatrix = new BitMatrix(n4, n5);
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = n8 + (int)((float)n3 * f2);
                for (n6 = 0; n6 < n4; ++n6) {
                    if (!((BitMatrix)object).get(n9 + (int)((float)n6 * f2), n2)) continue;
                    bitMatrix.set(n6, n3);
                }
            }
            object3 = bitMatrix;
            object = this.b.decode((BitMatrix)object3, (Map<DecodeHintType, ?>)object2);
            object2 = a;
        } else {
            object3 = new Detector(((BinaryBitmap)object).getBlackMatrix()).detect((Map<DecodeHintType, ?>)object2);
            object = this.b.decode(((DetectorResult)object3).getBits(), (Map<DecodeHintType, ?>)object2);
            object2 = ((DetectorResult)object3).getPoints();
        }
        if (((DecoderResult)object).getOther() instanceof QRCodeDecoderMetaData) {
            ((QRCodeDecoderMetaData)((DecoderResult)object).getOther()).applyMirroredCorrection((ResultPoint[])object2);
        }
        object3 = new Result(((DecoderResult)object).getText(), ((DecoderResult)object).getRawBytes(), (ResultPoint[])object2, BarcodeFormat.QR_CODE);
        object2 = ((DecoderResult)object).getByteSegments();
        if (object2 != null) {
            ((Result)object3).putMetadata(ResultMetadataType.BYTE_SEGMENTS, object2);
        }
        if ((object2 = ((DecoderResult)object).getECLevel()) != null) {
            ((Result)object3).putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, object2);
        }
        if (((DecoderResult)object).hasStructuredAppend()) {
            ((Result)object3).putMetadata(ResultMetadataType.STRUCTURED_APPEND_SEQUENCE, ((DecoderResult)object).getStructuredAppendSequenceNumber());
            ((Result)object3).putMetadata(ResultMetadataType.STRUCTURED_APPEND_PARITY, ((DecoderResult)object).getStructuredAppendParity());
        }
        return object3;
    }

    @Override
    public void reset() {
    }
}

