/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import java.util.Map;

public final class QRCodeWriter
implements Writer {
    @Override
    public final BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n2, int n3) {
        return this.encode(string, barcodeFormat, n2, n3, null);
    }

    @Override
    public final BitMatrix encode(String object, BarcodeFormat enum_, int n2, int n3, Map<EncodeHintType, ?> map) {
        Object object2;
        if (((String)object).isEmpty()) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (enum_ != BarcodeFormat.QR_CODE) {
            throw new IllegalArgumentException("Can only encode QR_CODE, but got " + enum_);
        }
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("Requested dimensions are too small: " + n2 + 'x' + n3);
        }
        enum_ = ErrorCorrectionLevel.L;
        int n4 = 4;
        if (map != null) {
            object2 = (ErrorCorrectionLevel)((Object)map.get((Object)EncodeHintType.ERROR_CORRECTION));
            if (object2 != null) {
                enum_ = object2;
            }
            if ((object2 = (Integer)map.get((Object)EncodeHintType.MARGIN)) != null) {
                n4 = (Integer)object2;
            }
        }
        object2 = Encoder.encode((String)object, (ErrorCorrectionLevel)enum_, map);
        int n5 = n2;
        int n6 = n3;
        n3 = n4;
        n2 = n6;
        int n7 = n5;
        object = object2;
        object = ((QRCode)object2).getMatrix();
        if (object == null) {
            throw new IllegalStateException();
        }
        int n8 = ((ByteMatrix)object).getWidth();
        n4 = ((ByteMatrix)object).getHeight();
        int n9 = n8 + (n3 << 1);
        n3 = n4 + (n3 << 1);
        n7 = Math.max(n7, n9);
        n2 = Math.max(n2, n3);
        n3 = Math.min(n7 / n9, n2 / n3);
        n9 = (n7 - n8 * n3) / 2;
        int n10 = (n2 - n4 * n3) / 2;
        BitMatrix bitMatrix = new BitMatrix(n7, n2);
        n2 = 0;
        while (n2 < n4) {
            int n11 = 0;
            int n12 = n9;
            while (n11 < n8) {
                if (((ByteMatrix)object).get(n11, n2) == 1) {
                    int n13 = n3;
                    bitMatrix.setRegion(n12, n10, n13, n13);
                }
                ++n11;
                n12 += n3;
            }
            ++n2;
            n10 += n3;
        }
        return bitMatrix;
    }
}

