/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.detector;

import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.common.GridSampler;
import com.google.zxing.common.PerspectiveTransform;
import com.google.zxing.common.detector.MathUtils;
import com.google.zxing.qrcode.decoder.Version;
import com.google.zxing.qrcode.detector.AlignmentPattern;
import com.google.zxing.qrcode.detector.FinderPattern;
import com.google.zxing.qrcode.detector.FinderPatternFinder;
import com.google.zxing.qrcode.detector.FinderPatternInfo;
import com.google.zxing.qrcode.detector.a;
import java.util.Map;

public class Detector {
    private final BitMatrix a;
    private ResultPointCallback b;

    public Detector(BitMatrix bitMatrix) {
        this.a = bitMatrix;
    }

    protected final BitMatrix getImage() {
        return this.a;
    }

    protected final ResultPointCallback getResultPointCallback() {
        return this.b;
    }

    public DetectorResult detect() {
        return this.detect(null);
    }

    public final DetectorResult detect(Map<DecodeHintType, ?> object) {
        this.b = object == null ? null : (ResultPointCallback)object.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK);
        FinderPatternFinder finderPatternFinder = new FinderPatternFinder(this.a, this.b);
        object = finderPatternFinder.b((Map<DecodeHintType, ?>)object);
        return this.processFinderPatternInfo((FinderPatternInfo)object);
    }

    protected final DetectorResult processFinderPatternInfo(FinderPatternInfo object) {
        float f2;
        float f3;
        float f4;
        float f5;
        FinderPattern finderPattern = ((FinderPatternInfo)object).getTopLeft();
        FinderPattern finderPattern2 = ((FinderPatternInfo)object).getTopRight();
        object = ((FinderPatternInfo)object).getBottomLeft();
        float f6 = this.calculateModuleSize(finderPattern, finderPattern2, (ResultPoint)object);
        if (f5 < 1.0f) {
            throw NotFoundException.getNotFoundInstance();
        }
        float f7 = f6;
        Object object2 = object;
        FinderPattern finderPattern3 = finderPattern2;
        Object object3 = finderPattern;
        int n2 = MathUtils.round(ResultPoint.distance((ResultPoint)object3, finderPattern3) / f7);
        int n3 = MathUtils.round(ResultPoint.distance((ResultPoint)object3, (ResultPoint)object2) / f7);
        n2 = (n2 + n3) / 2 + 7;
        switch (n2 & 3) {
            case 0: {
                ++n2;
                break;
            }
            case 2: {
                --n2;
                break;
            }
            case 3: {
                throw NotFoundException.getNotFoundInstance();
            }
        }
        int n4 = n2;
        object3 = Version.getProvisionalVersionForDimension(n4);
        int n5 = ((Version)object3).getDimensionForVersion() - 7;
        ResultPoint resultPoint = null;
        if (((Version)object3).getAlignmentPatternCenters().length > 0) {
            float f8 = finderPattern2.getX() - finderPattern.getX() + ((ResultPoint)object).getX();
            float f9 = finderPattern2.getY() - finderPattern.getY() + ((ResultPoint)object).getY();
            float f10 = 1.0f - 3.0f / (float)n5;
            int n6 = (int)(finderPattern.getX() + f10 * (f8 - finderPattern.getX()));
            n5 = (int)(finderPattern.getY() + f10 * (f9 - finderPattern.getY()));
            for (int i2 = 4; i2 <= 16; i2 <<= 1) {
                try {
                    resultPoint = this.findAlignmentInRegion(f6, n6, n5, i2);
                    break;
                }
                catch (NotFoundException notFoundException) {
                    continue;
                }
            }
        }
        n2 = n4;
        ResultPoint resultPoint2 = resultPoint;
        object2 = object;
        ResultPoint[] resultPointArray = finderPattern2;
        Object object4 = finderPattern;
        float f11 = (float)n2 - 3.5f;
        if (resultPoint2 != null) {
            f4 = resultPoint2.getX();
            f6 = resultPoint2.getY();
            f2 = f3 = f11 - 3.0f;
        } else {
            f4 = resultPointArray.getX() - ((ResultPoint)object4).getX() + ((ResultPoint)object2).getX();
            f6 = resultPointArray.getY() - ((ResultPoint)object4).getY() + ((ResultPoint)object2).getY();
            f3 = f11;
            f2 = f11;
        }
        object4 = PerspectiveTransform.quadrilateralToQuadrilateral(3.5f, 3.5f, f11, 3.5f, f3, f2, 3.5f, f11, ((ResultPoint)object4).getX(), ((ResultPoint)object4).getY(), resultPointArray.getX(), resultPointArray.getY(), f4, f6, ((ResultPoint)object2).getX(), ((ResultPoint)object2).getY());
        int n7 = n4;
        resultPointArray = object4;
        object4 = this.a;
        GridSampler gridSampler = GridSampler.getInstance();
        int n8 = n7;
        BitMatrix bitMatrix = gridSampler.sampleGrid((BitMatrix)object4, n8, n8, (PerspectiveTransform)resultPointArray);
        resultPointArray = resultPoint == null ? new ResultPoint[]{object, finderPattern, finderPattern2} : new ResultPoint[]{object, finderPattern, finderPattern2, resultPoint};
        return new DetectorResult(bitMatrix, resultPointArray);
    }

    protected final float calculateModuleSize(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3) {
        return (this.a(resultPoint, resultPoint2) + this.a(resultPoint, resultPoint3)) / 2.0f;
    }

    private float a(ResultPoint resultPoint, ResultPoint resultPoint2) {
        float f2 = this.a((int)resultPoint.getX(), (int)resultPoint.getY(), (int)resultPoint2.getX(), (int)resultPoint2.getY());
        float f3 = this.a((int)resultPoint2.getX(), (int)resultPoint2.getY(), (int)resultPoint.getX(), (int)resultPoint.getY());
        if (Float.isNaN(f2)) {
            return f3 / 7.0f;
        }
        if (Float.isNaN(f3)) {
            return f2 / 7.0f;
        }
        return (f2 + f3) / 14.0f;
    }

    private float a(int n2, int n3, int n4, int n5) {
        float f2 = this.b(n2, n3, n4, n5);
        float f3 = 1.0f;
        if ((n4 = n2 - (n4 - n2)) < 0) {
            f3 = (float)n2 / (float)(n2 - n4);
            n4 = 0;
        } else if (n4 >= this.a.getWidth()) {
            f3 = (float)(this.a.getWidth() - 1 - n2) / (float)(n4 - n2);
            n4 = this.a.getWidth() - 1;
        }
        n5 = (int)((float)n3 - (float)(n5 - n3) * f3);
        f3 = 1.0f;
        if (n5 < 0) {
            f3 = (float)n3 / (float)(n3 - n5);
            n5 = 0;
        } else if (n5 >= this.a.getHeight()) {
            f3 = (float)(this.a.getHeight() - 1 - n3) / (float)(n5 - n3);
            n5 = this.a.getHeight() - 1;
        }
        n4 = (int)((float)n2 + (float)(n4 - n2) * f3);
        return (f2 += this.b(n2, n3, n4, n5)) - 1.0f;
    }

    private float b(int n2, int n3, int n4, int n5) {
        int n6;
        boolean bl2 = Math.abs(n5 - n3) > Math.abs(n4 - n2);
        if (bl2) {
            n6 = n2;
            n2 = n3;
            n3 = n6;
            n6 = n4;
            n4 = n5;
            n5 = n6;
        }
        n6 = Math.abs(n4 - n2);
        int n7 = Math.abs(n5 - n3);
        int n8 = -n6 / 2;
        int n9 = n2 < n4 ? 1 : -1;
        int n10 = n3 < n5 ? 1 : -1;
        int n11 = 0;
        int n12 = n4 + n9;
        int n13 = n3;
        for (int i2 = n2; i2 != n12; i2 += n9) {
            int n14;
            int n15;
            if (n11 == 1 == this.a.get(n15 = bl2 ? n13 : i2, n14 = bl2 ? i2 : n13)) {
                if (n11 == 2) {
                    return MathUtils.distance(i2, n13, n2, n3);
                }
                ++n11;
            }
            if ((n8 += n7) <= 0) continue;
            if (n13 == n5) break;
            n13 += n10;
            n8 -= n6;
        }
        if (n11 == 2) {
            return MathUtils.distance(n4 + n9, n5, n2, n3);
        }
        return Float.NaN;
    }

    protected final AlignmentPattern findAlignmentInRegion(float f2, int n2, int n3, float f3) {
        int n4;
        int n5;
        int n6 = (int)(f3 * f2);
        int n7 = Math.max(0, n2 - n6);
        n2 = Math.min(this.a.getWidth() - 1, n2 + n6);
        if ((float)(n5 - n7) < f2 * 3.0f) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n8 = Math.max(0, n3 - n6);
        n3 = Math.min(this.a.getHeight() - 1, n3 + n6);
        if ((float)(n4 - n8) < f2 * 3.0f) {
            throw NotFoundException.getNotFoundInstance();
        }
        a a2 = new a(this.a, n7, n8, n2 - n7, n3 - n8, f2, this.b);
        return a2.a();
    }
}

