/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.encoder;

import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.CharacterSetECI;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonEncoder;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.Mode;
import com.google.zxing.qrcode.decoder.Version;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.QRCode;
import com.google.zxing.qrcode.encoder.a;
import com.google.zxing.qrcode.encoder.b;
import com.google.zxing.qrcode.encoder.c;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;

public final class Encoder {
    private static final int[] a = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 36, -1, -1, -1, 37, 38, -1, -1, -1, -1, 39, 40, -1, 41, 42, 43, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 44, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, -1, -1, -1, -1, -1};

    private Encoder() {
    }

    public static QRCode encode(String string, ErrorCorrectionLevel errorCorrectionLevel) {
        return Encoder.encode(string, errorCorrectionLevel, null);
    }

    public static QRCode encode(String string, ErrorCorrectionLevel errorCorrectionLevel, Map<EncodeHintType, ?> object) {
        ByteMatrix byteMatrix;
        int n2;
        int n3;
        byte[] byArray;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Object object2;
        Object object3;
        CharacterSetECI object52;
        if ((object = object == null ? null : (String)object.get((Object)EncodeHintType.CHARACTER_SET)) == null) {
            object = "ISO-8859-1";
        }
        Mode mode = Encoder.a(string, (String)object);
        BitArray bitArray = new BitArray();
        if (mode == Mode.BYTE && !"ISO-8859-1".equals(object) && (object52 = CharacterSetECI.getCharacterSetECIByName((String)object)) != null) {
            object3 = bitArray;
            object2 = object52;
            ((BitArray)object3).appendBits(Mode.ECI.getBits(), 4);
            ((BitArray)object3).appendBits(((CharacterSetECI)((Object)object2)).getValue(), 8);
        }
        object3 = bitArray;
        object2 = mode;
        ((BitArray)object3).appendBits(((Mode)((Object)object2)).getBits(), 4);
        BitArray n24 = new BitArray();
        Object object4 = object;
        Object object5 = n24;
        object3 = mode;
        object2 = string;
        switch (1.a[((Enum)object3).ordinal()]) {
            case 1: {
                int n9;
                BitArray bitArray2 = object5;
                Object object6 = object2;
                int n10 = object6.length();
                int n11 = 0;
                while (n11 < n10) {
                    n8 = object6.charAt(n11) - 48;
                    if (n11 + 2 < n10) {
                        n9 = object6.charAt(n11 + 1) - 48;
                        int n12 = object6.charAt(n11 + 2) - 48;
                        bitArray2.appendBits(n8 * 100 + n9 * 10 + n12, 10);
                        n11 += 3;
                        continue;
                    }
                    if (n11 + 1 < n10) {
                        n9 = object6.charAt(n11 + 1) - 48;
                        bitArray2.appendBits(n8 * 10 + n9, 7);
                        n11 += 2;
                        continue;
                    }
                    bitArray2.appendBits(n8, 4);
                    ++n11;
                }
                break;
            }
            case 2: {
                int n9;
                BitArray bitArray2 = object5;
                Object object6 = object2;
                int n10 = object6.length();
                int n11 = 0;
                while (n11 < n10) {
                    n8 = Encoder.a(object6.charAt(n11));
                    if (n8 == -1) {
                        throw new WriterException();
                    }
                    if (n11 + 1 < n10) {
                        n9 = Encoder.a(object6.charAt(n11 + 1));
                        if (n9 == -1) {
                            throw new WriterException();
                        }
                        bitArray2.appendBits(n8 * 45 + n9, 11);
                        n11 += 2;
                        continue;
                    }
                    bitArray2.appendBits(n8, 6);
                    ++n11;
                }
                break;
            }
            case 3: {
                Encoder.a((String)object2, (BitArray)object5, (String)object4);
                break;
            }
            case 4: {
                Encoder.a((String)object2, (BitArray)object5);
                break;
            }
            default: {
                throw new WriterException("Invalid mode: " + object3);
            }
        }
        int n12 = bitArray.getSize() + mode.getCharacterCountBits(Version.getVersionForNumber(1)) + n24.getSize();
        Version version = Encoder.a(n12, errorCorrectionLevel);
        int n13 = bitArray.getSize() + mode.getCharacterCountBits(version) + n24.getSize();
        Version version2 = Encoder.a(n13, errorCorrectionLevel);
        BitArray bitArray3 = new BitArray();
        bitArray3.appendBitArray(bitArray);
        int n14 = mode == Mode.BYTE ? n24.getSizeInBytes() : string.length();
        object4 = bitArray3;
        object5 = mode;
        object3 = version2;
        int n15 = n14;
        int n16 = ((Mode)((Object)object5)).getCharacterCountBits((Version)object3);
        if (n15 >= 1 << n16) {
            throw new WriterException(n15 + " is bigger than " + ((1 << n16) - 1));
        }
        ((BitArray)object4).appendBits(n15, n16);
        bitArray3.appendBitArray(n24);
        Object object10 = version2.getECBlocksForLevel(errorCorrectionLevel);
        int n17 = version2.getTotalCodewords() - ((Version.ECBlocks)object10).getTotalECCodewords();
        object3 = bitArray3;
        n15 = n17;
        int n18 = n17 << 3;
        if (((BitArray)object3).getSize() > n18) {
            throw new WriterException("data bits cannot fit in the QR Code" + ((BitArray)object3).getSize() + " > " + n18);
        }
        for (n7 = 0; n7 < 4 && ((BitArray)object3).getSize() < n18; ++n7) {
            ((BitArray)object3).appendBit(false);
        }
        n7 = ((BitArray)object3).getSize() & 7;
        if (n7 > 0) {
            for (n16 = n7; n16 < 8; ++n16) {
                ((BitArray)object3).appendBit(false);
            }
        }
        n16 = n15 - ((BitArray)object3).getSizeInBytes();
        for (n6 = 0; n6 < n16; ++n6) {
            ((BitArray)object3).appendBits((n6 & 1) == 0 ? 236 : 17, 8);
        }
        if (((BitArray)object3).getSize() != n18) {
            throw new WriterException("Bits size does not equal capacity");
        }
        n7 = ((Version.ECBlocks)object10).getNumBlocks();
        n18 = n17;
        int n19 = version2.getTotalCodewords();
        Object object7 = bitArray3;
        if (((BitArray)object7).getSizeInBytes() != n18) {
            throw new WriterException("Number of bits and data bytes does not match");
        }
        n16 = 0;
        n6 = 0;
        int n20 = 0;
        ArrayList<a> arrayList = new ArrayList<a>(n7);
        for (n8 = 0; n8 < n7; ++n8) {
            int n21;
            int[] nArray;
            int[] nArray2 = new int[1];
            Object[] objectArray = nArray = new int[1];
            int[] nArray3 = nArray2;
            int n22 = n8;
            n5 = n7;
            n4 = n18;
            int n23 = n19;
            if (n22 >= n5) {
                throw new WriterException("Block ID too large");
            }
            int n36 = n23 % n5;
            int n25 = n5 - n36;
            int n26 = n23 / n5;
            int n27 = n26 + 1;
            if ((n26 -= (n4 /= n5)) != (n27 -= (n21 = n4 + 1))) {
                throw new WriterException("EC bytes mismatch");
            }
            if (n5 != n25 + n36) {
                throw new WriterException("RS blocks mismatch");
            }
            if (n23 != (n4 + n26) * n25 + (n21 + n27) * n36) {
                throw new WriterException("Total bytes mismatch");
            }
            if (n22 < n25) {
                nArray3[0] = n4;
                objectArray[0] = n26;
            } else {
                nArray3[0] = n21;
                objectArray[0] = n27;
            }
            int n28 = nArray2[0];
            byArray = new byte[n28];
            ((BitArray)object7).toBytes(n16 * 8, byArray, 0, n28);
            n4 = nArray[0];
            byte[] byArray2 = byArray;
            n5 = byArray.length;
            object10 = new int[n5 + n4];
            for (int object12 = 0; object12 < n5; ++object12) {
                object10[object12] = byArray2[object12] & 0xFF;
            }
            new ReedSolomonEncoder(GenericGF.QR_CODE_FIELD_256).encode((int[])object10, n4);
            byte[] byArray3 = new byte[n4];
            for (int i2 = 0; i2 < n4; ++i2) {
                byArray3[i2] = (byte)object10[n5 + i2];
            }
            objectArray = byArray3;
            arrayList.add(new a(byArray, (byte[])objectArray));
            n6 = Math.max(n6, n28);
            n20 = Math.max(n20, objectArray.length);
            n16 += nArray2[0];
        }
        if (n18 != n16) {
            throw new WriterException("Data bytes does not match offset");
        }
        Object object8 = new BitArray();
        for (n3 = 0; n3 < n6; ++n3) {
            for (a a2 : arrayList) {
                byArray = a2.a();
                if (n3 >= byArray.length) continue;
                ((BitArray)object8).appendBits(byArray[n3], 8);
            }
        }
        for (n3 = 0; n3 < n20; ++n3) {
            for (a a3 : arrayList) {
                byArray = a3.b();
                if (n3 >= byArray.length) continue;
                ((BitArray)object8).appendBits(byArray[n3], 8);
            }
        }
        if (n19 != ((BitArray)object8).getSizeInBytes()) {
            throw new WriterException("Interleaving error: " + n19 + " and " + ((BitArray)object8).getSizeInBytes() + " differ.");
        }
        object10 = object8;
        QRCode qRCode = new QRCode();
        qRCode.setECLevel(errorCorrectionLevel);
        qRCode.setMode(mode);
        qRCode.setVersion(version2);
        int n29 = n2 = version2.getDimensionForVersion();
        ByteMatrix byteMatrix2 = byteMatrix = new ByteMatrix(n29, n29);
        Version version3 = version2;
        ErrorCorrectionLevel errorCorrectionLevel2 = errorCorrectionLevel;
        object7 = object10;
        n16 = Integer.MAX_VALUE;
        n6 = -1;
        for (n20 = 0; n20 < 8; ++n20) {
            int n30;
            c.a((BitArray)object7, errorCorrectionLevel2, version3, n20, byteMatrix2);
            object8 = byteMatrix2;
            int n31 = b.a((ByteMatrix)object8);
            Object object9 = object8;
            int n32 = 0;
            byte[][] byArray3 = ((ByteMatrix)object9).getArray();
            int n33 = ((ByteMatrix)object9).getWidth();
            int n34 = ((ByteMatrix)object9).getHeight();
            for (n30 = 0; n30 < n34 - 1; ++n30) {
                for (n4 = 0; n4 < n33 - 1; ++n4) {
                    n5 = byArray3[n30][n4];
                    if (n5 != byArray3[n30][n4 + 1] || n5 != byArray3[n30 + 1][n4] || n5 != byArray3[n30 + 1][n4 + 1]) continue;
                    ++n32;
                }
            }
            int n35 = n31 + 3 * n32 + b.b((ByteMatrix)object8);
            object9 = object8;
            n32 = 0;
            byte[][] byArray4 = ((ByteMatrix)object9).getArray();
            n33 = ((ByteMatrix)object9).getWidth();
            n34 = ((ByteMatrix)object9).getHeight();
            for (n30 = 0; n30 < n34; ++n30) {
                byte[] byArray5 = byArray4[n30];
                for (n5 = 0; n5 < n33; ++n5) {
                    if (byArray5[n5] != 1) continue;
                    ++n32;
                }
            }
            n30 = ((ByteMatrix)object9).getHeight() * ((ByteMatrix)object9).getWidth();
            n4 = Math.abs((n32 << 1) - n30) * 10 / n30;
            int n36 = n35 + n4 * 10;
            if (n36 >= n16) continue;
            n16 = n36;
            n6 = n20;
        }
        int n37 = n6;
        qRCode.setMaskPattern(n37);
        c.a((BitArray)object10, errorCorrectionLevel, version2, n37, byteMatrix);
        qRCode.setMatrix(byteMatrix);
        return qRCode;
    }

    private static int a(int n2) {
        if (n2 < a.length) {
            return a[n2];
        }
        return -1;
    }

    public static Mode chooseMode(String string) {
        return Encoder.a(string, null);
    }

    private static Mode a(String string, String string2) {
        if ("Shift_JIS".equals(string2)) {
            if (Encoder.a(string)) {
                return Mode.KANJI;
            }
            return Mode.BYTE;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '0' && c2 <= '9') {
                bl2 = true;
                continue;
            }
            if (Encoder.a(c2) != -1) {
                bl3 = true;
                continue;
            }
            return Mode.BYTE;
        }
        if (bl3) {
            return Mode.ALPHANUMERIC;
        }
        if (bl2) {
            return Mode.NUMERIC;
        }
        return Mode.BYTE;
    }

    private static boolean a(String object) {
        try {
            object = ((String)object).getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
        int n2 = ((Object)object).length;
        if (n2 % 2 != 0) {
            return false;
        }
        for (int i2 = 0; i2 < n2; i2 += 2) {
            int n3 = object[i2] & 0xFF;
            if (n3 >= 129 && n3 <= 159 || n3 >= 224 && n3 <= 235) continue;
            return false;
        }
        return true;
    }

    private static Version a(int n2, ErrorCorrectionLevel errorCorrectionLevel) {
        for (int i2 = 1; i2 <= 40; ++i2) {
            Version version = Version.getVersionForNumber(i2);
            int n3 = version.getTotalCodewords();
            Version.ECBlocks eCBlocks = version.getECBlocksForLevel(errorCorrectionLevel);
            int n4 = eCBlocks.getTotalECCodewords();
            if ((n3 -= n4) < (n4 = (n2 + 7) / 8)) continue;
            return version;
        }
        throw new WriterException("Data too big");
    }

    private static void a(String object, BitArray bitArray, String string) {
        try {
            object = ((String)object).getBytes(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WriterException(unsupportedEncodingException);
        }
        for (Object object2 : object) {
            bitArray.appendBits((int)object2, 8);
        }
    }

    private static void a(String object, BitArray bitArray) {
        try {
            object = ((String)object).getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WriterException(unsupportedEncodingException);
        }
        int n2 = ((Object)object).length;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            int n3 = object[i2] & 0xFF;
            int n4 = object[i2 + 1] & 0xFF;
            n3 = n3 << 8 | n4;
            n4 = -1;
            if (n3 >= 33088 && n3 <= 40956) {
                n4 = n3 - 33088;
            } else if (n3 >= 57408 && n3 <= 60351) {
                n4 = n3 - 49472;
            }
            if (n4 == -1) {
                throw new WriterException("Invalid byte sequence");
            }
            n3 = (n4 >> 8) * 192 + (n4 & 0xFF);
            bitArray.appendBits(n3, 13);
        }
    }
}

