/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.core;

import com.intellij.uiDesigner.core.AbstractLayout;
import com.intellij.uiDesigner.core.DimensionInfo;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.LayoutState;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.uiDesigner.core.Util;
import com.intellij.uiDesigner.core.a;
import com.intellij.uiDesigner.core.b;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Arrays;
import javax.swing.JComponent;

public final class GridLayoutManager
extends AbstractLayout {
    private int c = 20;
    private final int[] d;
    private final int[] e;
    private final int[] f;
    private final int[] g;
    private final int[] h;
    private final int[] i;
    private LayoutState j;
    a a;
    b b;
    private boolean k;
    private boolean l;
    public static Object DESIGN_TIME_INSETS = new Object();

    public GridLayoutManager(int n2, int n3) {
        int n4;
        if (n3 <= 0) {
            throw new IllegalArgumentException("wrong columnCount: " + n3);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("wrong rowCount: " + n2);
        }
        this.d = new int[n2];
        for (n4 = 0; n4 < n2; ++n4) {
            this.d[n4] = 1;
        }
        this.e = new int[n3];
        for (n4 = 0; n4 < n3; ++n4) {
            this.e[n4] = 1;
        }
        this.h = new int[n3];
        this.i = new int[n3];
        this.f = new int[n2];
        this.g = new int[n2];
    }

    public GridLayoutManager(int n2, int n3, Insets insets, int n4, int n5) {
        this(n2, n3);
        this.setMargin(insets);
        this.setHGap(n4);
        this.setVGap(n5);
        this.c = 0;
    }

    public GridLayoutManager(int n2, int n3, Insets insets, int n4, int n5, boolean bl2, boolean bl3) {
        this(n2, n3, insets, n4, n5);
        this.k = bl2;
        this.l = bl3;
    }

    @Override
    public final void addLayoutComponent(Component component, Object object) {
        GridConstraints gridConstraints = (GridConstraints)object;
        int n2 = gridConstraints.getRow();
        int n3 = gridConstraints.getRowSpan();
        int n4 = this.getRowCount();
        if (n2 < 0 || n2 >= n4) {
            throw new IllegalArgumentException("wrong row: " + n2);
        }
        if (n2 + n3 - 1 >= n4) {
            throw new IllegalArgumentException("wrong row span: " + n3 + "; row=" + n2 + " rowCount=" + n4);
        }
        n2 = gridConstraints.getColumn();
        int n5 = gridConstraints.getColSpan();
        n3 = this.getColumnCount();
        if (n2 < 0 || n2 >= n3) {
            throw new IllegalArgumentException("wrong column: " + n2);
        }
        if (n2 + n5 - 1 >= n3) {
            throw new IllegalArgumentException("wrong col span: " + n5 + "; column=" + n2 + " columnCount=" + n3);
        }
        super.addLayoutComponent(component, object);
    }

    public final int getRowCount() {
        return this.d.length;
    }

    public final int getColumnCount() {
        return this.e.length;
    }

    public final int getRowStretch(int n2) {
        return this.d[n2];
    }

    public final void setRowStretch(int n2, int n3) {
        if (n3 <= 0) {
            throw new IllegalArgumentException("wrong stretch: " + n3);
        }
        this.d[n2] = n3;
    }

    public final int getColumnStretch(int n2) {
        return this.e[n2];
    }

    public final void setColumnStretch(int n2, int n3) {
        if (n3 <= 0) {
            throw new IllegalArgumentException("wrong stretch: " + n3);
        }
        this.e[n2] = n3;
    }

    @Override
    public final Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public final Dimension minimumLayoutSize(Container serializable) {
        this.a((Container)serializable);
        Object object = this.a;
        b b2 = this.b;
        serializable = this.a((Container)serializable, (DimensionInfo)object, b2);
        DimensionInfo dimensionInfo = object;
        object = this;
        object = ((GridLayoutManager)object).a(dimensionInfo, true);
        if (this.k) {
            GridLayoutManager.a((int[])object);
        }
        ((Dimension)serializable).width += GridLayoutManager.b((int[])object);
        dimensionInfo = b2;
        object = this;
        object = ((GridLayoutManager)object).a(dimensionInfo, true);
        if (this.l) {
            GridLayoutManager.a((int[])object);
        }
        ((Dimension)serializable).height += GridLayoutManager.b((int[])object);
        return serializable;
    }

    private static void a(int[] nArray) {
        int n2;
        int n3 = nArray[0];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n4 = nArray[n2];
            n3 = Math.max(n4, n3);
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = n3;
        }
    }

    private static int[] a(DimensionInfo object, int n2) {
        object = new int[((DimensionInfo)object).getCellCount()];
        int n3 = n2 / ((Object)object).length;
        n2 %= ((Object)object).length;
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            object[i2] = n3;
            if (n2 <= 0) continue;
            Object object2 = object;
            int n4 = i2;
            object2[n4] = object2[n4] + true;
            --n2;
        }
        return object;
    }

    @Override
    public final Dimension preferredLayoutSize(Container serializable) {
        this.a((Container)serializable);
        Object object = this.a;
        b b2 = this.b;
        serializable = this.a((Container)serializable, (DimensionInfo)object, b2);
        DimensionInfo dimensionInfo = object;
        object = this;
        object = ((GridLayoutManager)object).a(dimensionInfo, false);
        if (this.k) {
            GridLayoutManager.a((int[])object);
        }
        ((Dimension)serializable).width += GridLayoutManager.b((int[])object);
        dimensionInfo = b2;
        object = this;
        object = ((GridLayoutManager)object).a(dimensionInfo, false);
        if (this.l) {
            GridLayoutManager.a((int[])object);
        }
        ((Dimension)serializable).height += GridLayoutManager.b((int[])object);
        return serializable;
    }

    private static int b(int[] nArray) {
        int n2 = 0;
        for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
            n2 += nArray[i2];
        }
        return n2;
    }

    private Dimension a(Container serializable, DimensionInfo dimensionInfo, DimensionInfo dimensionInfo2) {
        serializable = GridLayoutManager.c(serializable);
        return new Dimension(((Insets)serializable).left + ((Insets)serializable).right + GridLayoutManager.a(dimensionInfo, 0, dimensionInfo.getCellCount()) + this.myMargin.left + this.myMargin.right, ((Insets)serializable).top + ((Insets)serializable).bottom + GridLayoutManager.a(dimensionInfo2, 0, dimensionInfo2.getCellCount()) + this.myMargin.top + this.myMargin.bottom);
    }

    private static int b(Container container) {
        while (container != null) {
            Integer n2;
            if (container instanceof JComponent && (n2 = (Integer)((JComponent)container).getClientProperty(DESIGN_TIME_INSETS)) != null) {
                return n2;
            }
            container = container.getParent();
        }
        return 0;
    }

    private static Insets c(Container container) {
        Insets insets = container.getInsets();
        int n2 = GridLayoutManager.b(container);
        if (n2 != 0) {
            return new Insets(insets.top + n2, insets.left + n2, insets.bottom + n2, insets.right + n2);
        }
        return insets;
    }

    private static int a(DimensionInfo dimensionInfo, int n2, int n3) {
        int n4 = 0;
        for (n3 = n2 + n3 - 2; n3 >= n2; --n3) {
            if (!GridLayoutManager.b(dimensionInfo, n3)) continue;
            ++n4;
        }
        return n4 * dimensionInfo.getGap();
    }

    private static boolean b(DimensionInfo dimensionInfo, int n2) {
        int n3;
        if (n2 < 0 || n2 >= dimensionInfo.getCellCount()) {
            throw new IllegalArgumentException("wrong cellIndex: " + n2 + "; cellCount=" + dimensionInfo.getCellCount());
        }
        boolean bl2 = false;
        boolean bl3 = false;
        int n4 = -1;
        for (n3 = n2 + 1; n3 < dimensionInfo.getCellCount(); ++n3) {
            if (GridLayoutManager.c(dimensionInfo, n3)) continue;
            n4 = n3;
            break;
        }
        for (n3 = 0; n3 < dimensionInfo.getComponentCount(); ++n3) {
            Component component = dimensionInfo.getComponent(n3);
            if (component instanceof Spacer) continue;
            if (dimensionInfo.componentBelongsCell(n3, n2) && DimensionInfo.findAlignedChild(component, dimensionInfo.getConstraints(n3)) != null) {
                return true;
            }
            if (dimensionInfo.getCell(n3) == n4) {
                bl3 = true;
            }
            if (dimensionInfo.getCell(n3) + dimensionInfo.getSpan(n3) - 1 != n2) continue;
            bl2 = true;
        }
        return bl3 && bl2;
    }

    private static boolean c(DimensionInfo dimensionInfo, int n2) {
        if (n2 < 0 || n2 >= dimensionInfo.getCellCount()) {
            throw new IllegalArgumentException("wrong cellIndex: " + n2 + "; cellCount=" + dimensionInfo.getCellCount());
        }
        for (int i2 = 0; i2 < dimensionInfo.getComponentCount(); ++i2) {
            Component component = dimensionInfo.getComponent(i2);
            if (dimensionInfo.getCell(i2) != n2 || component instanceof Spacer) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void layoutContainer(Container serializable) {
        Insets insets;
        this.a((Container)serializable);
        LayoutState layoutState = this.j;
        a a2 = this.a;
        b b2 = this.b;
        Cloneable cloneable = insets = GridLayoutManager.c(serializable);
        Container container = serializable;
        GridLayoutManager gridLayoutManager = this;
        int n2 = 0;
        Object object = null;
        GridConstraints gridConstraints = null;
        Container container2 = container.getParent();
        if (container2 != null) {
            if (container2.getLayout() instanceof GridLayoutManager) {
                object = (GridLayoutManager)container2.getLayout();
                gridConstraints = ((AbstractLayout)object).getConstraintsForComponent(container);
            } else {
                container = container2.getParent();
                if (container != null && container.getLayout() instanceof GridLayoutManager) {
                    object = (GridLayoutManager)container.getLayout();
                    gridConstraints = ((AbstractLayout)object).getConstraintsForComponent(container2);
                }
            }
        }
        if (object != null && gridConstraints.isUseParentLayout()) {
            if (gridLayoutManager.d.length == gridConstraints.getRowSpan()) {
                int n3 = gridConstraints.getRow();
                gridLayoutManager.f[0] = cloneable.top + gridLayoutManager.myMargin.top;
                gridLayoutManager.g[0] = ((GridLayoutManager)object).g[n3] - gridLayoutManager.f[0];
                for (int i2 = 1; i2 < gridLayoutManager.d.length; ++i2) {
                    gridLayoutManager.f[i2] = ((GridLayoutManager)object).f[i2 + n3] - ((GridLayoutManager)object).f[n3];
                    gridLayoutManager.g[i2] = ((GridLayoutManager)object).g[i2 + n3];
                }
                int n4 = gridLayoutManager.d.length - 1;
                gridLayoutManager.g[n4] = gridLayoutManager.g[n4] - (cloneable.bottom + gridLayoutManager.myMargin.bottom);
                n2 = 1;
            }
            if (gridLayoutManager.e.length == gridConstraints.getColSpan()) {
                int n5 = gridConstraints.getColumn();
                gridLayoutManager.h[0] = cloneable.left + gridLayoutManager.myMargin.left;
                gridLayoutManager.i[0] = ((GridLayoutManager)object).i[n5] - gridLayoutManager.h[0];
                for (int i3 = 1; i3 < gridLayoutManager.e.length; ++i3) {
                    gridLayoutManager.h[i3] = ((GridLayoutManager)object).h[i3 + n5] - ((GridLayoutManager)object).h[n5];
                    gridLayoutManager.i[i3] = ((GridLayoutManager)object).i[i3 + n5];
                }
                int n6 = gridLayoutManager.e.length - 1;
                gridLayoutManager.i[n6] = gridLayoutManager.i[n6] - (cloneable.right + gridLayoutManager.myMargin.right);
                n2 |= 2;
            }
        }
        int n7 = n2;
        Object object2 = this.a((Container)serializable, a2, b2);
        cloneable = serializable.getSize();
        ((Dimension)cloneable).width -= ((Dimension)object2).width;
        ((Dimension)cloneable).height -= ((Dimension)object2).height;
        Dimension dimension = ((AbstractLayout)this).preferredLayoutSize((Container)serializable);
        dimension.width -= ((Dimension)object2).width;
        dimension.height -= ((Dimension)object2).height;
        serializable = ((AbstractLayout)this).minimumLayoutSize((Container)serializable);
        ((Dimension)serializable).width -= ((Dimension)object2).width;
        ((Dimension)serializable).height -= ((Dimension)object2).height;
        if (!(n7 & true)) {
            if (this.l) {
                object2 = GridLayoutManager.a(b2, Math.max(((Dimension)cloneable).height, ((Dimension)serializable).height));
            } else if (((Dimension)cloneable).height < dimension.height) {
                object = b2;
                object2 = this;
                object2 = ((GridLayoutManager)object2).a((DimensionInfo)object, true);
                this.a((int[])object2, 0, ((DimensionInfo)b2).getCellCount(), ((Dimension)cloneable).height, b2, true);
            } else {
                object = b2;
                object2 = this;
                object2 = ((GridLayoutManager)object2).a((DimensionInfo)object, false);
                this.a((int[])object2, 0, ((DimensionInfo)b2).getCellCount(), ((Dimension)cloneable).height, b2, false);
            }
            int n8 = insets.top + this.myMargin.top;
            for (int i4 = 0; i4 < ((Object)object2).length; ++i4) {
                this.f[i4] = n8;
                this.g[i4] = (int)object2[i4];
                n8 += object2[i4];
                if (!GridLayoutManager.b(b2, i4)) continue;
                n8 += b2.getGap();
            }
        }
        if ((n7 & 2) == 0) {
            if (this.k) {
                object2 = GridLayoutManager.a(a2, Math.max(((Dimension)cloneable).width, ((Dimension)serializable).width));
            } else if (((Dimension)cloneable).width < dimension.width) {
                a a3 = a2;
                object2 = this;
                object2 = ((GridLayoutManager)object2).a(a3, true);
                this.a((int[])object2, 0, ((DimensionInfo)a2).getCellCount(), ((Dimension)cloneable).width, a2, true);
            } else {
                a a4 = a2;
                object2 = this;
                object2 = ((GridLayoutManager)object2).a(a4, false);
                this.a((int[])object2, 0, ((DimensionInfo)a2).getCellCount(), ((Dimension)cloneable).width, a2, false);
            }
            int n9 = insets.left + this.myMargin.left;
            for (int i5 = 0; i5 < ((Object)object2).length; ++i5) {
                this.h[i5] = n9;
                this.i[i5] = (int)object2[i5];
                n9 += object2[i5];
                if (!GridLayoutManager.b(a2, i5)) continue;
                n9 += a2.getGap();
            }
        }
        for (int i6 = 0; i6 < layoutState.getComponentCount(); ++i6) {
            GridConstraints gridConstraints2 = layoutState.getConstraints(i6);
            Component component = layoutState.getComponent(i6);
            int n10 = a2.getCell(i6);
            int n11 = a2.getSpan(i6);
            n7 = b2.getCell(i6);
            int n12 = b2.getSpan(i6);
            n11 = this.h[n10 + n11 - 1] + this.i[n10 + n11 - 1] - this.h[n10];
            n12 = this.f[n7 + n12 - 1] + this.g[n7 + n12 - 1] - this.f[n7];
            dimension = new Dimension(n11, n12);
            if ((gridConstraints2.getFill() & 1) == 0) {
                dimension.width = Math.min(dimension.width, ((DimensionInfo)a2).getPreferredWidth(i6));
            }
            if ((gridConstraints2.getFill() & 2) == 0) {
                dimension.height = Math.min(dimension.height, ((DimensionInfo)b2).getPreferredWidth(i6));
            }
            Util.adjustSize(component, gridConstraints2, dimension);
            int n13 = 0;
            int n14 = 0;
            if ((gridConstraints2.getAnchor() & 4) != 0) {
                n13 = n11 - dimension.width;
            } else if ((gridConstraints2.getAnchor() & 8) == 0) {
                n13 = (n11 - dimension.width) / 2;
            }
            if ((gridConstraints2.getAnchor() & 2) != 0) {
                n14 = n12 - dimension.height;
            } else if ((gridConstraints2.getAnchor() & 1) == 0) {
                n14 = (n12 - dimension.height) / 2;
            }
            n11 = 10 * gridConstraints2.getIndent();
            dimension.width -= n11;
            component.setBounds(this.h[n10] + (n13 += n11), this.f[n7] + n14, dimension.width, dimension.height);
        }
    }

    @Override
    public final void invalidateLayout(Container container) {
        this.j = null;
        this.a = null;
        this.b = null;
    }

    final void a(Container container) {
        if (this.j == null) {
            this.j = new LayoutState(this, GridLayoutManager.b(container) == 0);
            this.a = new a(this.j, GridLayoutManager.getHGapImpl(container));
            this.b = new b(this.j, GridLayoutManager.getVGapImpl(container));
        }
    }

    public final int[] getXs() {
        return this.h;
    }

    public final int[] getWidths() {
        return this.i;
    }

    public final int[] getYs() {
        return this.f;
    }

    public final int[] getHeights() {
        return this.g;
    }

    public final int[] getCoords(boolean bl2) {
        if (bl2) {
            return this.f;
        }
        return this.h;
    }

    public final int[] getSizes(boolean bl2) {
        if (bl2) {
            return this.g;
        }
        return this.i;
    }

    private int[] a(DimensionInfo dimensionInfo, boolean bl2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray = new int[dimensionInfo.getCellCount()];
        for (n5 = 0; n5 < nArray.length; ++n5) {
            nArray[n5] = this.c;
        }
        for (n5 = dimensionInfo.getComponentCount() - 1; n5 >= 0; --n5) {
            if (dimensionInfo.getSpan(n5) != 1) continue;
            n4 = bl2 ? GridLayoutManager.d(dimensionInfo, n5) : Math.max(dimensionInfo.getMinimumWidth(n5), dimensionInfo.getPreferredWidth(n5));
            n3 = dimensionInfo.getCell(n5);
            n2 = GridLayoutManager.a(dimensionInfo, n3, dimensionInfo.getSpan(n5));
            n4 = Math.max(n4 - n2, 0);
            nArray[n3] = Math.max(nArray[n3], n4);
        }
        GridLayoutManager.a(dimensionInfo, bl2, nArray);
        boolean[] blArray = new boolean[dimensionInfo.getCellCount()];
        for (n4 = dimensionInfo.getComponentCount() - 1; n4 >= 0; --n4) {
            n3 = bl2 ? GridLayoutManager.d(dimensionInfo, n4) : Math.max(dimensionInfo.getMinimumWidth(n4), dimensionInfo.getPreferredWidth(n4));
            n2 = dimensionInfo.getSpan(n4);
            int n6 = dimensionInfo.getCell(n4);
            int n7 = GridLayoutManager.a(dimensionInfo, n6, n2);
            n3 = Math.max(n3 - n7, 0);
            Arrays.fill(blArray, false);
            n7 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                n7 += nArray[i2 + n6];
                blArray[i2 + n6] = true;
            }
            if (n7 >= n3) continue;
            boolean[] blArray2 = new boolean[blArray.length];
            this.a(dimensionInfo, blArray, blArray2, false, nArray);
            GridLayoutManager.a(blArray2, dimensionInfo, n3 - n7, nArray);
        }
        return nArray;
    }

    private static void a(DimensionInfo dimensionInfo, boolean bl2, int[] nArray) {
        for (int i2 = dimensionInfo.getComponentCount() - 1; i2 >= 0; --i2) {
            Component component = dimensionInfo.getComponent(i2);
            GridConstraints gridConstraints = dimensionInfo.getConstraints(i2);
            if (!gridConstraints.isUseParentLayout() || !(component instanceof Container)) continue;
            if (((Container)(component = (Container)component)).getLayout() instanceof GridLayoutManager) {
                GridLayoutManager.a(dimensionInfo, bl2, nArray, (Container)component, i2);
                continue;
            }
            if (((Container)component).getComponentCount() != 1 || !(((Container)component).getComponent(0) instanceof Container) || !(((Container)(component = (Container)((Container)component).getComponent(0))).getLayout() instanceof GridLayoutManager)) continue;
            GridLayoutManager.a(dimensionInfo, bl2, nArray, (Container)component, i2);
        }
    }

    private static void a(DimensionInfo dimensionInfo, boolean bl2, int[] nArray, Container object, int n2) {
        GridLayoutManager gridLayoutManager = (GridLayoutManager)((Container)object).getLayout();
        if (dimensionInfo.getSpan(n2) == dimensionInfo.a(gridLayoutManager)) {
            gridLayoutManager.a((Container)object);
            object = dimensionInfo instanceof a ? gridLayoutManager.a : gridLayoutManager.b;
            int[] nArray2 = gridLayoutManager.a((DimensionInfo)object, bl2);
            int n3 = dimensionInfo.getCell(n2);
            for (int i2 = 0; i2 < nArray2.length; ++i2) {
                nArray[n3 + i2] = Math.max(nArray[n3 + i2], nArray2[i2]);
            }
        }
    }

    private static int d(DimensionInfo dimensionInfo, int n2) {
        int n3 = (dimensionInfo.a(n2) & 1) != 0 ? dimensionInfo.getMinimumWidth(n2) : Math.max(dimensionInfo.getMinimumWidth(n2), dimensionInfo.getPreferredWidth(n2));
        return n3;
    }

    private void a(int[] nArray, int n2, int n3, int n4, DimensionInfo dimensionInfo, boolean bl2) {
        n2 = n4;
        for (n4 = 0; n4 < n3 + 0; ++n4) {
            n2 -= nArray[n4];
        }
        if (n2 <= 0) {
            return;
        }
        boolean[] blArray = new boolean[dimensionInfo.getCellCount()];
        for (int i2 = 0; i2 < n3 + 0; ++i2) {
            blArray[i2] = true;
        }
        boolean[] blArray2 = new boolean[dimensionInfo.getCellCount()];
        this.a(dimensionInfo, blArray, blArray2, bl2, nArray);
        GridLayoutManager.a(blArray2, dimensionInfo, n2, nArray);
    }

    private static void a(boolean[] blArray, DimensionInfo dimensionInfo, int n2, int[] nArray) {
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < dimensionInfo.getCellCount(); ++n3) {
            if (!blArray[n3]) continue;
            n4 += dimensionInfo.getStretch(n3);
        }
        n3 = n2;
        for (int i2 = 0; i2 < dimensionInfo.getCellCount(); ++i2) {
            if (!blArray[i2]) continue;
            int n5 = n3 * dimensionInfo.getStretch(i2) / n4;
            int n6 = i2;
            nArray[n6] = nArray[n6] + n5;
            n2 -= n5;
        }
        if (n2 != 0) {
            for (n3 = 0; n3 < dimensionInfo.getCellCount(); ++n3) {
                if (!blArray[n3]) continue;
                int n7 = n3;
                nArray[n7] = nArray[n7] + 1;
                if (--n2 == 0) break;
            }
        }
        if (n2 != 0) {
            throw new IllegalStateException("toDistribute = " + n2);
        }
    }

    private void a(DimensionInfo dimensionInfo, boolean[] blArray, boolean[] blArray2, boolean n2, int[] nArray) {
        Arrays.fill(blArray2, false);
        int n3 = 0;
        if (n2 != 0) {
            int[] nArray2 = this.a(dimensionInfo, false);
            for (int i2 = 0; i2 < blArray.length; ++i2) {
                if (!blArray[i2] || GridLayoutManager.c(dimensionInfo, i2) || nArray2[i2] <= nArray[i2]) continue;
                blArray2[i2] = true;
                ++n3;
            }
            if (n3 > 0) {
                return;
            }
        }
        for (n2 = 0; n2 < blArray.length; ++n2) {
            if (!blArray[n2] || (dimensionInfo.getCellSizePolicy(n2) & 4) == 0) continue;
            blArray2[n2] = true;
            ++n3;
        }
        if (n3 > 0) {
            return;
        }
        for (n2 = 0; n2 < blArray.length; ++n2) {
            if (!blArray[n2] || (dimensionInfo.getCellSizePolicy(n2) & 2) == 0) continue;
            blArray2[n2] = true;
            ++n3;
        }
        if (n3 > 0) {
            return;
        }
        for (n2 = 0; n2 < blArray.length; ++n2) {
            if (!blArray[n2] || GridLayoutManager.c(dimensionInfo, n2)) continue;
            blArray2[n2] = true;
            ++n3;
        }
        if (n3 > 0) {
            return;
        }
        for (n2 = 0; n2 < blArray.length; ++n2) {
            if (!blArray[n2]) continue;
            blArray2[n2] = true;
        }
    }

    public final boolean isSameSizeHorizontally() {
        return this.k;
    }

    public final boolean isSameSizeVertically() {
        return this.l;
    }

    public final void setSameSizeHorizontally(boolean bl2) {
        this.k = bl2;
    }

    public final void setSameSizeVertically(boolean bl2) {
        this.l = bl2;
    }

    public final int[] getHorizontalGridLines() {
        int[] nArray = new int[this.f.length + 1];
        int[] nArray2 = nArray;
        nArray[0] = this.f[0];
        for (int i2 = 0; i2 < this.f.length - 1; ++i2) {
            nArray2[i2 + 1] = (this.f[i2] + this.g[i2] + this.f[i2 + 1]) / 2;
        }
        nArray2[this.f.length] = this.f[this.f.length - 1] + this.g[this.f.length - 1];
        return nArray2;
    }

    public final int[] getVerticalGridLines() {
        int[] nArray = new int[this.h.length + 1];
        int[] nArray2 = nArray;
        nArray[0] = this.h[0];
        for (int i2 = 0; i2 < this.h.length - 1; ++i2) {
            nArray2[i2 + 1] = (this.h[i2] + this.i[i2] + this.h[i2 + 1]) / 2;
        }
        nArray2[this.h.length] = this.h[this.h.length - 1] + this.i[this.h.length - 1];
        return nArray2;
    }

    public final int getCellCount(boolean bl2) {
        if (bl2) {
            return this.getRowCount();
        }
        return this.getColumnCount();
    }

    public final int getCellSizePolicy(boolean bl2, int n2) {
        DimensionInfo dimensionInfo = bl2 ? this.b : this.a;
        if (dimensionInfo == null) {
            return 0;
        }
        return dimensionInfo.getCellSizePolicy(n2);
    }
}

