/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.core;

import com.intellij.uiDesigner.core.GridConstraints;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;

public final class Util {
    private static final Dimension a = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final int DEFAULT_INDENT = 10;

    public static Dimension getMinimumSize(Component serializable, GridConstraints gridConstraints, boolean bl2) {
        try {
            serializable = Util.a(gridConstraints.myMinimumSize, serializable.getMinimumSize());
            if (bl2) {
                ((Dimension)serializable).width += 10 * gridConstraints.getIndent();
            }
            return serializable;
        }
        catch (NullPointerException nullPointerException) {
            return new Dimension(0, 0);
        }
    }

    public static Dimension getMaximumSize(Component serializable, GridConstraints gridConstraints, boolean bl2) {
        try {
            serializable = Util.a(gridConstraints.myMaximumSize, a);
            if (bl2 && ((Dimension)serializable).width < Util.a.width) {
                ((Dimension)serializable).width += 10 * gridConstraints.getIndent();
            }
            return serializable;
        }
        catch (NullPointerException nullPointerException) {
            return new Dimension(0, 0);
        }
    }

    public static Dimension getPreferredSize(Component serializable, GridConstraints gridConstraints, boolean bl2) {
        try {
            serializable = Util.a(gridConstraints.myPreferredSize, serializable.getPreferredSize());
            if (bl2) {
                ((Dimension)serializable).width += 10 * gridConstraints.getIndent();
            }
            return serializable;
        }
        catch (NullPointerException nullPointerException) {
            return new Dimension(0, 0);
        }
    }

    private static Dimension a(Dimension dimension, Dimension dimension2) {
        int n2 = dimension.width >= 0 ? dimension.width : dimension2.width;
        int n3 = dimension.height >= 0 ? dimension.height : dimension2.height;
        return new Dimension(n2, n3);
    }

    public static void adjustSize(Component serializable, GridConstraints gridConstraints, Dimension dimension) {
        Dimension dimension2 = Util.getMinimumSize(serializable, gridConstraints, false);
        serializable = Util.getMaximumSize(serializable, gridConstraints, false);
        dimension.width = Math.max(dimension.width, dimension2.width);
        dimension.height = Math.max(dimension.height, dimension2.height);
        dimension.width = Math.min(dimension.width, ((Dimension)serializable).width);
        dimension.height = Math.min(dimension.height, ((Dimension)serializable).height);
    }

    public static int eliminate(int[] nArray, int[] nArray2, ArrayList arrayList) {
        int n2;
        int n3 = nArray.length;
        if (n3 != nArray2.length) {
            throw new IllegalArgumentException("size mismatch: " + n3 + ", " + nArray2.length);
        }
        if (arrayList != null && arrayList.size() != 0) {
            throw new IllegalArgumentException("eliminated must be empty");
        }
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n4 = Math.max(n4, nArray[n2] + nArray2[n2]);
        }
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            int n5;
            boolean bl2 = false;
            boolean bl3 = false;
            for (n5 = 0; n5 < n3; ++n5) {
                if (nArray[n5] == n2) {
                    bl2 = true;
                }
                if (nArray[n5] + nArray2[n5] - 1 != n2) continue;
                bl3 = true;
            }
            if (bl2 && bl3) continue;
            if (arrayList != null) {
                arrayList.add(n2);
            }
            for (n5 = 0; n5 < n3; ++n5) {
                bl2 = nArray[n5] <= n2 && n2 < nArray[n5] + nArray2[n5];
                boolean bl4 = bl3 = nArray[n5] > n2;
                if (bl2) {
                    int n6 = n5;
                    nArray2[n6] = nArray2[n6] - 1;
                }
                if (!bl3) continue;
                int n7 = n5;
                nArray[n7] = nArray[n7] - 1;
            }
            --n4;
        }
        return n4;
    }
}

