/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.bouncycastle;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfObject;
import java.io.IOException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;

public class BouncyCastleHelper {
    public static void checkCertificateEncodingOrThrowException(Certificate certificate) {
        try {
            new X509CertificateHolder(certificate.getEncoded());
            return;
        }
        catch (IOException | CertificateEncodingException exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static byte[] getEnvelopedData(PdfArray object, List<PdfObject> list, Certificate certificate, Key key, String string) {
        Object object2 = null;
        block2: for (PdfObject exception : ((PdfArray)((Object)object)).getElements()) {
            list.remove(exception);
            try {
                CMSEnvelopedData cMSEnvelopedData = new CMSEnvelopedData(exception.getBytes());
                Collection collection = cMSEnvelopedData.getRecipientInfos().getRecipients();
                for (RecipientInformation recipientInformation : collection) {
                    if (!recipientInformation.getRID().match((Object)certificate)) continue;
                    object2 = new JceKeyTransEnvelopedRecipient((PrivateKey)key).setProvider(string);
                    object2 = recipientInformation.getContent((Recipient)object2);
                    continue block2;
                }
            }
            catch (Exception exception2) {
                throw new ExceptionConverter(exception2);
            }
        }
        return object2;
    }
}

