/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.ElementTags;
import com.lowagie.text.List;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Table;
import com.lowagie.text.TableRectangle;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.alignment.HorizontalAlignment;
import com.lowagie.text.alignment.VerticalAlignment;
import com.lowagie.text.alignment.WithHorizontalAlignment;
import com.lowagie.text.alignment.WithVerticalAlignment;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.PdfPCell;
import java.util.ArrayList;
import java.util.Iterator;

public class Cell
extends TableRectangle
implements TextElementArray,
WithHorizontalAlignment,
WithVerticalAlignment {
    protected java.util.List<Element> arrayList = null;
    protected int horizontalAlignment = -1;
    protected int verticalAlignment = -1;
    protected float width;
    protected boolean percentage = false;
    protected int colspan = 1;
    protected int rowspan = 1;
    private float a = Float.NaN;
    protected boolean header;
    protected int maxLines = Integer.MAX_VALUE;
    private String b;
    protected boolean useAscender = false;
    protected boolean useDescender = false;
    protected boolean useBorderPadding;
    protected boolean groupChange = true;

    public Cell() {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBorder(-1);
        this.setBorderWidth(0.5f);
        this.arrayList = new ArrayList<Element>();
    }

    public Cell(boolean bl2) {
        this();
        this.arrayList.add(new Paragraph(0.0f));
    }

    public Cell(String string) {
        this();
        try {
            this.addElement(new Paragraph(string));
            return;
        }
        catch (BadElementException badElementException) {
            return;
        }
    }

    public Cell(Element element) {
        this();
        if (element instanceof Phrase) {
            this.setLeading(((Phrase)element).getLeading());
        }
        this.addElement(element);
    }

    @Override
    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    @Override
    public int type() {
        return 20;
    }

    @Override
    public ArrayList<Element> getChunks() {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Element element : this.arrayList) {
            arrayList.addAll(element.getChunks());
        }
        return arrayList;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n2) {
        this.horizontalAlignment = n2;
    }

    public void setHorizontalAlignment(String string) {
        this.setHorizontalAlignment(ElementTags.alignmentValue(string));
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int n2) {
        this.verticalAlignment = n2;
    }

    public void setVerticalAlignment(String string) {
        this.setVerticalAlignment(ElementTags.alignmentValue(string));
    }

    public void setWidth(float f2) {
        this.width = f2;
    }

    public void setWidth(String string) {
        if (string.endsWith("%")) {
            string = string.substring(0, string.length() - 1);
            this.percentage = true;
        }
        this.width = Integer.parseInt(string);
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    public String getWidthAsString() {
        String string = String.valueOf(this.width);
        if (string.endsWith(".0")) {
            string = string.substring(0, string.length() - 2);
        }
        if (this.percentage) {
            string = string + "%";
        }
        return string;
    }

    public void setColspan(int n2) {
        this.colspan = n2;
    }

    public int getColspan() {
        return this.colspan;
    }

    public void setRowspan(int n2) {
        this.rowspan = n2;
    }

    public int getRowspan() {
        return this.rowspan;
    }

    public void setLeading(float f2) {
        this.a = f2;
    }

    public float getLeading() {
        if (Float.isNaN(this.a)) {
            return 16.0f;
        }
        return this.a;
    }

    public void setHeader(boolean bl2) {
        this.header = bl2;
    }

    public boolean isHeader() {
        return this.header;
    }

    public void setMaxLines(int n2) {
        this.maxLines = n2;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setShowTruncation(String string) {
        this.b = string;
    }

    public String getShowTruncation() {
        return this.b;
    }

    public void setUseAscender(boolean bl2) {
        this.useAscender = bl2;
    }

    public boolean isUseAscender() {
        return this.useAscender;
    }

    public void setUseDescender(boolean bl2) {
        this.useDescender = bl2;
    }

    public boolean isUseDescender() {
        return this.useDescender;
    }

    public void setUseBorderPadding(boolean bl2) {
        this.useBorderPadding = bl2;
    }

    public boolean isUseBorderPadding() {
        return this.useBorderPadding;
    }

    public boolean getGroupChange() {
        return this.groupChange;
    }

    public void setGroupChange(boolean bl2) {
        this.groupChange = bl2;
    }

    public int size() {
        return this.arrayList.size();
    }

    public Iterator getElements() {
        return this.arrayList.iterator();
    }

    public void clear() {
        this.arrayList.clear();
    }

    public boolean isEmpty() {
        switch (this.size()) {
            case 0: {
                return true;
            }
            case 1: {
                Element element = this.arrayList.get(0);
                switch (element.type()) {
                    case 10: {
                        return ((Chunk)element).isEmpty();
                    }
                    case 11: 
                    case 12: 
                    case 17: {
                        return ((Phrase)element).isEmpty();
                    }
                    case 14: {
                        return ((List)element).isEmpty();
                    }
                }
                return false;
            }
        }
        return false;
    }

    final void a() {
        if (this.size() == 0) {
            this.arrayList.add(new Paragraph(0.0f));
        }
    }

    public boolean isTable() {
        return this.size() == 1 && this.arrayList.get(0).type() == 22;
    }

    public void addElement(Element element) {
        if (this.isTable()) {
            Table table = (Table)this.arrayList.get(0);
            Cell cell = new Cell(element);
            cell.setBorder(0);
            cell.setColspan(table.getColumns());
            table.addCell(cell);
            return;
        }
        switch (element.type()) {
            case 15: 
            case 20: 
            case 21: {
                throw new BadElementException(MessageLocalization.getComposedMessage("you.can.t.add.listitems.rows.or.cells.to.a.cell"));
            }
            case 14: {
                List list = (List)element;
                if (Float.isNaN(this.a)) {
                    this.setLeading(list.getTotalLeading());
                }
                if (list.isEmpty()) {
                    return;
                }
                this.arrayList.add(element);
                return;
            }
            case 11: 
            case 12: 
            case 17: {
                Phrase phrase = (Phrase)element;
                if (Float.isNaN(this.a)) {
                    this.setLeading(phrase.getLeading());
                }
                if (phrase.isEmpty()) {
                    return;
                }
                this.arrayList.add(element);
                return;
            }
            case 10: {
                if (((Chunk)element).isEmpty()) {
                    return;
                }
                this.arrayList.add(element);
                return;
            }
            case 22: {
                Table table = new Table(3);
                float[] fArray = new float[3];
                Object object = fArray;
                fArray[1] = ((Rectangle)((Table)element)).getWidth();
                switch (((Table)element).getAlignment()) {
                    case 0: {
                        object[0] = 0.0f;
                        object[2] = 100.0f - object[1];
                        break;
                    }
                    case 1: {
                        object[0] = (100.0f - object[1]) / 2.0f;
                        object[2] = object[0];
                        break;
                    }
                    case 2: {
                        object[0] = 100.0f - object[1];
                        object[2] = 0.0f;
                    }
                }
                table.setWidths((float[])object);
                if (this.arrayList.isEmpty()) {
                    table.addCell(Cell.b());
                } else {
                    Cell cell = new Cell();
                    object = cell;
                    cell.setBorder(0);
                    object.setColspan(3);
                    for (Element element2 : this.arrayList) {
                        object.add(element2);
                    }
                    table.addCell((Cell)object);
                }
                Cell cell = new Cell();
                object = cell;
                cell.setBorder(0);
                table.addCell((Cell)object);
                table.insertTable((Table)element);
                Cell cell2 = new Cell();
                object = cell2;
                cell2.setBorder(0);
                table.addCell((Cell)object);
                table.addCell(Cell.b());
                this.clear();
                this.arrayList.add(table);
                return;
            }
        }
        this.arrayList.add(element);
    }

    @Override
    public boolean add(Element element) {
        try {
            this.addElement(element);
            return true;
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException(MessageLocalization.getComposedMessage("you.can.only.add.objects.that.implement.the.element.interface"));
        }
        catch (BadElementException badElementException) {
            throw new ClassCastException(badElementException.getMessage());
        }
    }

    private static Cell b() {
        Cell cell = new Cell(true);
        cell.setColspan(3);
        cell.setBorder(0);
        return cell;
    }

    public PdfPCell createPdfPCell() {
        if (this.rowspan > 1) {
            throw new BadElementException(MessageLocalization.getComposedMessage("pdfpcells.can.t.have.a.rowspan.gt.1"));
        }
        if (this.isTable()) {
            return new PdfPCell(((Table)this.arrayList.get(0)).createPdfPTable());
        }
        PdfPCell pdfPCell = new PdfPCell();
        pdfPCell.setVerticalAlignment(this.verticalAlignment);
        pdfPCell.setHorizontalAlignment(this.horizontalAlignment);
        pdfPCell.setColspan(this.colspan);
        pdfPCell.setUseBorderPadding(this.useBorderPadding);
        pdfPCell.setUseDescender(this.useDescender);
        pdfPCell.setLeading(this.getLeading(), 0.0f);
        pdfPCell.cloneNonPositionParameters(this);
        pdfPCell.setNoWrap(this.getMaxLines() == 1);
        Iterator iterator = this.getElements();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (element.type() == 11 || element.type() == 12) {
                element = new Paragraph((Phrase)element);
                ((Paragraph)element).setAlignment(this.horizontalAlignment);
            }
            pdfPCell.addElement(element);
        }
        return pdfPCell;
    }

    @Override
    public float getTop() {
        throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("dimensions.of.a.cell.can.t.be.calculated.see.the.faq"));
    }

    @Override
    public float getBottom() {
        throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("dimensions.of.a.cell.can.t.be.calculated.see.the.faq"));
    }

    @Override
    public float getLeft() {
        throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("dimensions.of.a.cell.can.t.be.calculated.see.the.faq"));
    }

    @Override
    public float getRight() {
        throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("dimensions.of.a.cell.can.t.be.calculated.see.the.faq"));
    }

    public float top(int n2) {
        throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("dimensions.of.a.cell.can.t.be.calculated.see.the.faq"));
    }

    public float bottom(int n2) {
        throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("dimensions.of.a.cell.can.t.be.calculated.see.the.faq"));
    }

    public float left(int n2) {
        throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("dimensions.of.a.cell.can.t.be.calculated.see.the.faq"));
    }

    public float right(int n2) {
        throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("dimensions.of.a.cell.can.t.be.calculated.see.the.faq"));
    }

    public void setTop(int n2) {
        throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("dimensions.of.a.cell.are.attributed.automagically.see.the.faq"));
    }

    public void setBottom(int n2) {
        throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("dimensions.of.a.cell.are.attributed.automagically.see.the.faq"));
    }

    public void setLeft(int n2) {
        throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("dimensions.of.a.cell.are.attributed.automagically.see.the.faq"));
    }

    public void setRight(int n2) {
        throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("dimensions.of.a.cell.are.attributed.automagically.see.the.faq"));
    }

    @Override
    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == null) {
            return;
        }
        this.horizontalAlignment = horizontalAlignment.getId();
    }

    @Override
    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        if (verticalAlignment == null) {
            return;
        }
        this.verticalAlignment = verticalAlignment.getId();
    }
}

