/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.SplitCharacter;
import com.lowagie.text.Utilities;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.HyphenationEvent;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.draw.DrawInterface;
import java.awt.Color;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class Chunk
implements Element {
    public static final String OBJECT_REPLACEMENT_CHARACTER = "\ufffc";
    public static final Chunk NEWLINE = new Chunk("\n");
    public static final Chunk NEXTPAGE = new Chunk("");
    protected StringBuffer content = null;
    protected Font font = null;
    protected Map<String, Object> attributes = null;
    public static final String SEPARATOR = "SEPARATOR";
    public static final String TAB = "TAB";
    public static final String HSCALE = "HSCALE";
    public static final String UNDERLINE = "UNDERLINE";
    public static final String SUBSUPSCRIPT = "SUBSUPSCRIPT";
    public static final String SKEW = "SKEW";
    public static final String BACKGROUND = "BACKGROUND";
    public static final String TEXTRENDERMODE = "TEXTRENDERMODE";
    public static final String SPLITCHARACTER = "SPLITCHARACTER";
    public static final String HYPHENATION = "HYPHENATION";
    public static final String REMOTEGOTO = "REMOTEGOTO";
    public static final String LOCALGOTO = "LOCALGOTO";
    public static final String LOCALDESTINATION = "LOCALDESTINATION";
    public static final String GENERICTAG = "GENERICTAG";
    public static final String IMAGE = "IMAGE";
    public static final String ACTION = "ACTION";
    public static final String NEWPAGE = "NEWPAGE";
    public static final String PDFANNOTATION = "PDFANNOTATION";
    public static final String COLOR = "COLOR";
    public static final String ENCODING = "ENCODING";
    public static final String CHAR_SPACING = "CHAR_SPACING";

    public Chunk() {
        this.content = new StringBuffer();
        this.font = new Font();
    }

    public Chunk(Chunk chunk) {
        if (chunk.content != null) {
            this.content = new StringBuffer(chunk.content.toString());
        }
        if (chunk.font != null) {
            this.font = new Font(chunk.font);
        }
        if (chunk.attributes != null) {
            this.attributes = new HashMap<String, Object>(chunk.attributes);
        }
    }

    public Chunk(String string, Font font) {
        this.content = new StringBuffer(string);
        this.font = font;
    }

    public Chunk(String string) {
        this(string, new Font());
    }

    public Chunk(char c2, Font font) {
        this.content = new StringBuffer();
        this.content.append(c2);
        this.font = font;
    }

    public Chunk(char c2) {
        this(c2, new Font());
    }

    public Chunk(Image image, float f2, float f3) {
        this(OBJECT_REPLACEMENT_CHARACTER, new Font());
        image = Image.getInstance(image);
        image.setAbsolutePosition(Float.NaN, Float.NaN);
        this.a(IMAGE, new Object[]{image, Float.valueOf(f2), Float.valueOf(f3), Boolean.FALSE});
    }

    public Chunk(DrawInterface drawInterface) {
        this(drawInterface, false);
    }

    public Chunk(DrawInterface drawInterface, boolean bl2) {
        this(OBJECT_REPLACEMENT_CHARACTER, new Font());
        this.a(SEPARATOR, new Object[]{drawInterface, bl2});
    }

    public Chunk(DrawInterface drawInterface, float f2) {
        this(drawInterface, f2, false);
    }

    public Chunk(DrawInterface drawInterface, float f2, boolean bl2) {
        this(OBJECT_REPLACEMENT_CHARACTER, new Font());
        if (f2 < 0.0f) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("a.tab.position.may.not.be.lower.than.0.yours.is.1", String.valueOf(f2)));
        }
        this.a(TAB, new Object[]{drawInterface, Float.valueOf(f2), bl2, Float.valueOf(0.0f)});
    }

    public Chunk(Image image, float f2, float f3, boolean bl2) {
        this(OBJECT_REPLACEMENT_CHARACTER, new Font());
        this.a(IMAGE, new Object[]{image, Float.valueOf(f2), Float.valueOf(f3), bl2});
    }

    @Override
    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    @Override
    public int type() {
        return 10;
    }

    @Override
    public ArrayList<Element> getChunks() {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        arrayList.add(this);
        return arrayList;
    }

    public StringBuffer append(String string) {
        return this.content.append(string);
    }

    public void setFont(Font font) {
        this.font = font;
    }

    @Nullable
    public Font getFont() {
        return this.font;
    }

    public String getContent() {
        return this.content.toString();
    }

    @Override
    public String toString() {
        return this.getContent();
    }

    public boolean isEmpty() {
        return this.content.toString().trim().length() == 0 && !this.content.toString().contains("\n") && this.attributes == null;
    }

    public float getWidthPoint() {
        if (this.getImage() != null) {
            return this.getImage().getScaledWidth();
        }
        return this.font.getCalculatedBaseFont(true).getWidthPoint(this.getContent(), this.font.getCalculatedSize()) * this.getHorizontalScaling();
    }

    public boolean hasAttributes() {
        return this.attributes != null;
    }

    @Deprecated
    public HashMap getAttributes() {
        return (HashMap)this.attributes;
    }

    public Map<String, Object> getChunkAttributes() {
        return this.attributes;
    }

    @Deprecated
    public void setAttributes(HashMap hashMap) {
        this.attributes = hashMap;
    }

    public void setChunkAttributes(Map<String, Object> map) {
        this.attributes = map;
    }

    private Chunk a(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(string, object);
        return this;
    }

    public Chunk setHorizontalScaling(float f2) {
        return this.a(HSCALE, Float.valueOf(f2));
    }

    public float getHorizontalScaling() {
        if (this.attributes == null) {
            return 1.0f;
        }
        Float f2 = (Float)this.attributes.get(HSCALE);
        if (f2 == null) {
            return 1.0f;
        }
        return f2.floatValue();
    }

    public Chunk setUnderline(float f2, float f3) {
        return this.setUnderline(null, f2, 0.0f, f3, 0.0f, 0);
    }

    public Chunk setUnderline(Color objectArray, float f2, float f3, float f4, float f5, int n2) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        objectArray = new Object[]{objectArray, new float[]{f2, f3, f4, f5, n2}};
        objectArray = Utilities.addToArray((Object[][])this.attributes.get(UNDERLINE), objectArray);
        return this.a(UNDERLINE, objectArray);
    }

    public Chunk setTextRise(float f2) {
        return this.a(SUBSUPSCRIPT, Float.valueOf(f2));
    }

    public float getTextRise() {
        if (this.attributes != null && this.attributes.containsKey(SUBSUPSCRIPT)) {
            return ((Float)this.attributes.get(SUBSUPSCRIPT)).floatValue();
        }
        return 0.0f;
    }

    public Chunk setSkew(float f2, float f3) {
        f2 = (float)Math.tan((double)f2 * Math.PI / 180.0);
        f3 = (float)Math.tan((double)f3 * Math.PI / 180.0);
        return this.a(SKEW, new float[]{f2, f3});
    }

    public Chunk setBackground(Color color) {
        return this.setBackground(color, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Chunk setBackground(Color color, float f2, float f3, float f4, float f5) {
        return this.a(BACKGROUND, new Object[]{color, new float[]{f2, f3, f4, f5}});
    }

    public Chunk setTextRenderMode(int n2, float f2, Color color) {
        return this.a(TEXTRENDERMODE, new Object[]{n2, Float.valueOf(f2), color});
    }

    public Chunk setSplitCharacter(SplitCharacter splitCharacter) {
        return this.a(SPLITCHARACTER, splitCharacter);
    }

    public Chunk setHyphenation(HyphenationEvent hyphenationEvent) {
        return this.a(HYPHENATION, hyphenationEvent);
    }

    public Chunk setRemoteGoto(String string, String string2) {
        return this.a(REMOTEGOTO, new Object[]{string, string2});
    }

    public Chunk setRemoteGoto(String string, int n2) {
        return this.a(REMOTEGOTO, new Object[]{string, n2});
    }

    public Chunk setLocalGoto(String string) {
        return this.a(LOCALGOTO, string);
    }

    public Chunk setLocalDestination(String string) {
        return this.a(LOCALDESTINATION, string);
    }

    public Chunk setGenericTag(String string) {
        return this.a(GENERICTAG, string);
    }

    public Image getImage() {
        if (this.attributes == null) {
            return null;
        }
        Object[] objectArray = (Object[])this.attributes.get(IMAGE);
        if (objectArray == null) {
            return null;
        }
        return (Image)objectArray[0];
    }

    public Chunk setAction(PdfAction pdfAction) {
        return this.a(ACTION, pdfAction);
    }

    public Chunk setAnchor(URL uRL) {
        return this.a(ACTION, new PdfAction(uRL.toExternalForm()));
    }

    public Chunk setAnchor(String string) {
        return this.a(ACTION, new PdfAction(string));
    }

    public Chunk setNewPage() {
        return this.a(NEWPAGE, null);
    }

    public Chunk setAnnotation(PdfAnnotation pdfAnnotation) {
        return this.a(PDFANNOTATION, pdfAnnotation);
    }

    @Override
    public boolean isContent() {
        return true;
    }

    @Override
    public boolean isNestable() {
        return true;
    }

    public HyphenationEvent getHyphenation() {
        if (this.attributes == null) {
            return null;
        }
        return (HyphenationEvent)this.attributes.get(HYPHENATION);
    }

    public Chunk setCharacterSpacing(float f2) {
        return this.a(CHAR_SPACING, Float.valueOf(f2));
    }

    public float getCharacterSpacing() {
        if (this.attributes != null && this.attributes.containsKey(CHAR_SPACING)) {
            return ((Float)this.attributes.get(CHAR_SPACING)).floatValue();
        }
        return 0.0f;
    }

    static {
        NEXTPAGE.setNewPage();
    }
}

