/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.DocListener;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.OutputStreamCounter;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Properties;

public abstract class DocWriter
implements DocListener {
    public static final byte NEWLINE = 10;
    public static final byte TAB = 9;
    public static final byte LT = 60;
    public static final byte SPACE = 32;
    public static final byte EQUALS = 61;
    public static final byte QUOTE = 34;
    public static final byte GT = 62;
    public static final byte FORWARD = 47;
    protected Rectangle pageSize;
    protected Document document;
    protected OutputStreamCounter os;
    protected boolean open = false;
    protected boolean pause = false;
    protected boolean closeStream = true;

    protected DocWriter() {
    }

    protected DocWriter(Document document, OutputStream outputStream) {
        this.document = document;
        this.os = new OutputStreamCounter(new BufferedOutputStream(outputStream));
    }

    @Override
    public boolean add(Element element) {
        return false;
    }

    @Override
    public void open() {
        this.open = true;
    }

    @Override
    public boolean setPageSize(Rectangle rectangle) {
        this.pageSize = rectangle;
        return true;
    }

    @Override
    public boolean setMargins(float f2, float f3, float f4, float f5) {
        return false;
    }

    @Override
    public boolean newPage() {
        return this.open;
    }

    @Override
    public void setHeader(HeaderFooter headerFooter) {
    }

    @Override
    public void resetHeader() {
    }

    @Override
    public void setFooter(HeaderFooter headerFooter) {
    }

    @Override
    public void resetFooter() {
    }

    @Override
    public void resetPageCount() {
    }

    @Override
    public void setPageCount(int n2) {
    }

    @Override
    public void close() {
        if (!this.open) {
            return;
        }
        this.open = false;
        try {
            this.os.flush();
            if (this.closeStream) {
                this.os.close();
            }
            return;
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public static final byte[] getISOBytes(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = (byte)string.charAt(i2);
        }
        return byArray;
    }

    public void pause() {
        this.pause = true;
    }

    public boolean isPaused() {
        return this.pause;
    }

    public void resume() {
        this.pause = false;
    }

    public void flush() {
        try {
            this.os.flush();
            return;
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    protected void write(String string) {
        this.os.write(DocWriter.getISOBytes(string));
    }

    protected void addTabs(int n2) {
        this.os.write(10);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.os.write(9);
        }
    }

    protected void write(String string, String string2) {
        this.os.write(32);
        this.write(string);
        this.os.write(61);
        this.os.write(34);
        this.write(string2);
        this.os.write(34);
    }

    protected void writeStart(String string) {
        this.os.write(60);
        this.write(string);
    }

    protected void writeEnd(String string) {
        this.os.write(60);
        this.os.write(47);
        this.write(string);
        this.os.write(62);
    }

    protected void writeEnd() {
        this.os.write(32);
        this.os.write(47);
        this.os.write(62);
    }

    protected boolean writeMarkupAttributes(Properties properties) {
        if (properties == null) {
            return false;
        }
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string = String.valueOf(iterator.next());
            this.write(string, properties.getProperty(string));
        }
        properties.clear();
        return true;
    }

    public boolean isCloseStream() {
        return this.closeStream;
    }

    public void setCloseStream(boolean bl2) {
        this.closeStream = bl2;
    }

    @Override
    public boolean setMarginMirroring(boolean bl2) {
        return false;
    }

    @Override
    public boolean setMarginMirroringTopBottom(boolean bl2) {
        return false;
    }
}

